/*
 * Decompiled with CFR 0.152.
 */
package org.reclipse.structure.specification.ui.figures;

import java.text.DecimalFormat;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Graphics;
import org.eclipse.swt.graphics.Color;
import org.fujaba.commons.figures.LineBorderedRectangleFigure;
import org.reclipse.math.functions.MathematicalFunction;

public abstract class FuzzyFunctionFigure
extends LineBorderedRectangleFigure {
    protected MathematicalFunction function = null;
    private final int GAP = 10;
    protected double xValue = 0.0;
    protected double yValue = 0.0;
    private boolean valuesExist = false;
    protected String xName = null;
    protected int xStart = 20;
    protected int xEnd = 180;
    protected int yStart = 20;
    protected int yEnd = 80;

    public FuzzyFunctionFigure(String xName) {
        this.xName = xName;
    }

    public void setValues(double x, double y) {
        this.valuesExist = true;
        this.xValue = x;
        this.yValue = y;
    }

    public void paintClientArea(Graphics gc) {
        super.paintClientArea(gc);
        this.xEnd = this.bounds.width - 60;
        this.yEnd = this.bounds.height - 20;
        this.drawAxes(gc);
        if (this.function != null) {
            this.drawFunction(gc);
            if (this.valuesExist) {
                this.drawFunctionValue(gc);
            }
        }
    }

    private void drawAxes(Graphics gc) {
        gc.drawLine(this.xStart - 10, this.yEnd, this.xEnd + 40, this.yEnd);
        gc.drawLine(this.xStart, this.yStart - 10, this.xStart, this.yEnd + 10);
        Color background = gc.getBackgroundColor();
        gc.setBackgroundColor(ColorConstants.black);
        gc.fillPolygon(new int[]{this.xStart - 3, this.yStart + 5 - 10, this.xStart + 3, this.yStart + 5 - 10, this.xStart, this.yStart - 5 - 10});
        gc.fillPolygon(new int[]{this.xEnd + 35, this.yEnd - 3, this.xEnd + 35, this.yEnd + 3, this.xEnd + 45, this.yEnd});
        gc.setBackgroundColor(background);
        gc.setLineStyle(3);
        gc.setForegroundColor(ColorConstants.gray);
        gc.drawLine(this.xStart, this.yStart, this.xEnd, this.yStart);
        gc.drawLine(this.xEnd, this.yStart, this.xEnd, this.yEnd);
        gc.setForegroundColor(ColorConstants.black);
        gc.setLineStyle(1);
        gc.drawText("0", this.xStart - 10, this.yEnd);
        gc.drawText("1", this.xStart - 10, this.yStart - 5);
        gc.drawText("\u03bc", this.xStart - 10, 0);
        double range = this.getFunctionRangeX();
        DecimalFormat df = new DecimalFormat("0.00");
        gc.drawText(df.format(range), this.xEnd - 10, this.yEnd);
        gc.drawText(this.xName, this.xEnd + 20, this.yEnd);
    }

    protected void drawFunction(Graphics gc) {
        int x_pixel_count = this.xEnd - this.xStart;
        double x = 0.0;
        double y = 0.0;
        double width_of_1_pixel = this.getFunctionRangeX() / (double)x_pixel_count;
        int lastY = (int)Math.round((double)(this.yEnd - this.yStart) * (1.0 - this.function.value(0.0)));
        int i = 1;
        while (i < x_pixel_count) {
            x = (double)i * width_of_1_pixel;
            try {
                y = this.function.value(x);
            }
            catch (ArithmeticException e) {
                y = 0.0;
            }
            int currentY = (int)Math.round((double)(this.yEnd - this.yStart) * (1.0 - y));
            gc.drawLine(this.xStart + i - 1, this.yStart + lastY, this.xStart + i, this.yStart + currentY);
            lastY = currentY;
            ++i;
        }
    }

    protected void drawFunctionValue(Graphics gc) {
        int x_pixel_count = this.xEnd - this.xStart;
        double range = this.getFunctionRangeX();
        double relX = this.xValue / range;
        int x = (int)Math.round((double)x_pixel_count * relX);
        gc.setBackgroundColor(ColorConstants.red);
        int xValueCoordinate = this.xStart + x;
        int yValueCoordinate = (int)Math.round((double)(this.yEnd - this.yStart) * (1.0 - this.yValue) + (double)this.yStart);
        gc.fillOval(xValueCoordinate - 3, yValueCoordinate - 3, 6, 6);
    }

    public void setFunction(MathematicalFunction function) {
        this.function = function;
        this.repaint();
    }

    public MathematicalFunction getFunction() {
        return this.function;
    }

    protected boolean valuesExist() {
        return this.valuesExist;
    }

    protected abstract double getFunctionRangeX();
}

