/*
 * Decompiled with CFR 0.152.
 */
package org.reclipse.structure.specification.ui.editor;

import java.util.ArrayList;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.commands.Command;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TreeNode;
import org.eclipse.jface.viewers.TreeNodeContentProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.fujaba.commons.editor.AbstractPersistableModelViewMultiPageEditor;
import org.fujaba.commons.editor.overviewpage.NestedDiagramsTreeSectionPart;
import org.fujaba.commons.identifier.IdentifierPackage;
import org.fujaba.commons.properties.TreeNodeLabelProvider;
import org.reclipse.structure.specification.PSAnnotation;
import org.reclipse.structure.specification.PSCatalog;
import org.reclipse.structure.specification.PSNode;
import org.reclipse.structure.specification.PSPatternSpecification;
import org.reclipse.structure.specification.SpecificationPackage;
import org.reclipse.structure.specification.ui.edit.commands.CreatePSPatternSpecificationCommand;
import org.reclipse.structure.specification.ui.edit.commands.DeletePSPatternSpecificationCommand;
import org.reclipse.structure.specification.ui.editor.MultiPagePSCatalogEditor;

public class PatternSpecificationSectionPart
extends NestedDiagramsTreeSectionPart {
    private PSCatalog catalog;

    private PatternSpecificationSectionPart(MultiPagePSCatalogEditor editor, Composite parent, FormToolkit toolkit) {
        super((AbstractPersistableModelViewMultiPageEditor)editor, parent, toolkit);
        this.getSection().setText("Pattern Specifications contained in this catalog");
    }

    public PatternSpecificationSectionPart(MultiPagePSCatalogEditor editor, IManagedForm mForm) {
        this(editor, mForm.getForm().getBody(), mForm.getToolkit());
    }

    protected boolean canRemove(EObject[] selected) {
        int i = 0;
        while (i < selected.length) {
            if (selected[i] instanceof PSPatternSpecification) {
                PSPatternSpecification selectedPattern = (PSPatternSpecification)selected[i];
                if (!selectedPattern.getSubPatterns().isEmpty()) {
                    return false;
                }
                for (PSPatternSpecification other : selectedPattern.getCatalog().getPatternSpecifications()) {
                    if (other.equals(selected)) continue;
                    for (PSNode node : other.getNodes()) {
                        if (!(node instanceof PSAnnotation) || !selected.equals(((PSAnnotation)node).getType())) continue;
                        return false;
                    }
                }
            }
            ++i;
        }
        return true;
    }

    protected Command createAddDiagramCommand(String newName) {
        return new CreatePSPatternSpecificationCommand(this.catalog, this.editor.getDiagramResource(), newName);
    }

    protected Command createDeleteDiagramCommandFor(EObject diagramRoot) {
        if (diagramRoot instanceof PSPatternSpecification) {
            return new DeletePSPatternSpecificationCommand((PSPatternSpecification)diagramRoot, this.editor.getDiagramResource());
        }
        return null;
    }

    protected TreeNode[] getInput() {
        ArrayList<TreeNode> roots = new ArrayList<TreeNode>();
        for (PSPatternSpecification pattern : this.catalog.getPatternSpecifications()) {
            if (pattern.getSuperPattern() != null) continue;
            roots.add(this.createNode((EObject)pattern, null));
        }
        return roots.toArray(new TreeNode[roots.size()]);
    }

    protected void handleModelChanged(Notification msg) {
        Object feature = msg.getFeature();
        if (feature != null && (feature.equals(SpecificationPackage.Literals.PS_CATALOG__PATTERN_SPECIFICATIONS) || feature.equals(SpecificationPackage.Literals.PS_PATTERN_SPECIFICATION__ABSTRACT) || feature.equals(SpecificationPackage.Literals.PS_PATTERN_SPECIFICATION__SUB_PATTERNS) || feature.equals(IdentifierPackage.Literals.IDENTIFIER__NAME))) {
            this.refresh();
        }
    }

    public boolean setFormInput(Object input) {
        if (input instanceof PSCatalog) {
            if (this.catalog != null) {
                this.catalog.eAdapters().remove((Object)this);
                for (PSPatternSpecification pattern : this.catalog.getPatternSpecifications()) {
                    pattern.eAdapters().remove((Object)this);
                }
            }
            this.catalog = (PSCatalog)input;
            if (!this.catalog.eAdapters().contains((Object)this)) {
                this.catalog.eAdapters().add((Object)this);
            }
            for (PSPatternSpecification pattern : this.catalog.getPatternSpecifications()) {
                if (pattern.eAdapters().contains((Object)this)) continue;
                pattern.eAdapters().add((Object)this);
            }
            return true;
        }
        return super.setFormInput(input);
    }

    protected TreeNode createNode(EObject type, TreeNode parent) {
        assert (type instanceof PSPatternSpecification);
        PSPatternSpecification pattern = (PSPatternSpecification)type;
        TreeNode node = new TreeNode((Object)type);
        node.setParent(parent);
        EList children = pattern.getSubPatterns();
        TreeNode[] childrenNodes = new TreeNode[children.size()];
        int i = 0;
        for (PSPatternSpecification child : children) {
            childrenNodes[i] = this.createNode((EObject)child, node);
            ++i;
        }
        node.setChildren(childrenNodes);
        return node;
    }

    protected IBaseLabelProvider getLabelProvider() {
        return new TreeNodeLabelProvider(((MultiPagePSCatalogEditor)this.editor).getEditingDomain().getAdapterFactory());
    }

    protected IContentProvider getContentProvider() {
        return new TreeNodeContentProvider();
    }

    protected void openDiagramFor(EObject diagramRoot) {
        assert (diagramRoot instanceof PSPatternSpecification);
        ((MultiPagePSCatalogEditor)this.editor).addPageFor((PSPatternSpecification)diagramRoot);
    }
}

