/*
 * Decompiled with CFR 0.152.
 */
package org.reclipse.structure.specification.ui.editor;

import java.util.EventObject;
import java.util.HashMap;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.command.CommandStackListener;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.provider.EcoreItemProviderAdapterFactory;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.edit.provider.resource.ResourceItemProviderAdapterFactory;
import org.eclipse.emf.edit.ui.util.EditUIUtil;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.IPropertySourceProvider;
import org.eclipse.ui.views.properties.PropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.ITabbedPropertySheetPageContributor;
import org.fujaba.commons.editor.AbstractPersistableModelViewMultiPageEditor;
import org.fujaba.commons.editor.CommandStackDelegate;
import org.fujaba.commons.notation.HierarchicalNode;
import org.fujaba.commons.providers.ModelViewAdapterFactoryContentProvider;
import org.fujaba.commons.utils.IDUsingResourceFactory;
import org.reclipse.metamodel.MetaModel;
import org.reclipse.structure.specification.PSCatalog;
import org.reclipse.structure.specification.PSPatternSpecification;
import org.reclipse.structure.specification.provider.SpecificationItemProviderAdapterFactory;
import org.reclipse.structure.specification.ui.PSPlugin;
import org.reclipse.structure.specification.ui.editor.PSCatalogEditorPage;
import org.reclipse.structure.specification.ui.editor.PSCatalogOverviewPage;
import org.reclipse.structure.specification.ui.properties.PSTabbedPropertySheetPage;
import org.reclipse.structure.specification.ui.utils.IFile2EditingDomainMapping;
import org.reclipse.structure.specification.util.ModelHelper;

public class MultiPagePSCatalogEditor
extends AbstractPersistableModelViewMultiPageEditor
implements ITabbedPropertySheetPageContributor {
    private PSCatalogOverviewPage overviewPage;
    private ComposedAdapterFactory adapterFactory;
    private PSCatalog catalog;
    public static final String ID = "org.reclipse.structure.specification.ui.PSCatalogEditor";
    public static final String TABBED_PROPERTY_CONTRIBUTOR_ID = "org.reclipse.structure.specification.ui.property.contributor";
    protected PropertySheetPage propertySheetPage;

    public MultiPagePSCatalogEditor() {
        this.initializeEditingDomain();
    }

    public void save() {
        this.performSaveAs(null);
    }

    protected void addPages() {
        this.overviewPage = new PSCatalogOverviewPage(this);
        try {
            this.addPage((IFormPage)this.overviewPage);
        }
        catch (PartInitException e) {
            PSPlugin.getDefault().logError("Exception while adding overview page", e);
        }
    }

    public void removePageOf(PSPatternSpecification pattern) {
        int index = -1;
        int count = 0;
        for (Object page : this.pages) {
            PSCatalogEditorPage thePage;
            if (page != null && !page.equals((Object)this.overviewPage) && page instanceof PSCatalogEditorPage && pattern.equals((thePage = (PSCatalogEditorPage)((Object)page)).getDiagramModel())) {
                thePage.dispose();
                thePage.getGraphicalViewer().setContents(null);
                index = count;
                break;
            }
            ++count;
        }
        if (index > 0 && index < this.getPageCount()) {
            this.removePage(index);
        }
    }

    public void addPageFor(PSPatternSpecification pattern) {
        if (!this.catalog.getPatternSpecifications().contains((Object)pattern)) {
            return;
        }
        IEditorInput input = this.provideEditorInput((EObject)pattern);
        try {
            int pageIndex = this.findEditor(input);
            if (pageIndex < 0) {
                PSCatalogEditorPage page = new PSCatalogEditorPage(this);
                pageIndex = this.addPage((IEditorPart)page, input);
                this.setTabsToCloseable(pageIndex, page);
                this.setPageText(pageIndex, pattern.getName());
                this.setPageImage(pageIndex, page.getTitleImage());
            }
            this.setActivePage(pageIndex);
        }
        catch (PartInitException e) {
            PSPlugin.getDefault().logError("Could not create a new editor page", e);
        }
    }

    protected void setInput(IEditorInput input) {
        this.setInputWithNotify(input);
        if (input instanceof IFileEditorInput) {
            IFileEditorInput fileInput = (IFileEditorInput)input;
            IFile2EditingDomainMapping.register(fileInput.getFile(), this.editingDomain);
        }
        this.setPartName(input.getName());
        this.loadModel();
    }

    public void loadModel() {
        URI resourceURI = EditUIUtil.getURI((IEditorInput)this.getEditorInput());
        Exception exception = null;
        Resource resource = null;
        try {
            resource = this.editingDomain.getResourceSet().getResource(resourceURI, true);
        }
        catch (Exception e) {
            exception = e;
            PSPlugin.getDefault().logError("load on demand failed", exception);
            resource = this.editingDomain.getResourceSet().getResource(resourceURI, false);
        }
        EObject obj = (EObject)resource.getContents().get(0);
        if (obj instanceof HierarchicalNode) {
            PSPatternSpecification pattern = (PSPatternSpecification)((HierarchicalNode)obj).getModel();
            this.catalog = pattern.getCatalog();
            this.modelResource = pattern.eResource();
            this.diagramResource = resource;
            this.checkMetaModel();
        } else {
            MessageDialog.openError((Shell)this.getSite().getShell(), (String)"Error", (String)("Problems occured during loading of resource " + resourceURI.path()));
        }
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IPropertySheetPage.class && adapter != null && this.getContributorId() != null) {
            return new PSTabbedPropertySheetPage(this);
        }
        return super.getAdapter(adapter);
    }

    private void checkMetaModel() {
        MetaModel mm = ModelHelper.getMetaModel((PSCatalog)this.catalog);
        if (mm == null) {
            MessageDialog.openError((Shell)this.getSite().getShell(), (String)"Error", (String)"No abstract syntax graph meta model resource specified. \nYou might not be able to specify a type to your objecs.");
        } else {
            ModelHelper.getTypes((MetaModel)mm);
        }
    }

    protected void initializeEditingDomain() {
        this.adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
        this.adapterFactory.addAdapterFactory((AdapterFactory)new ResourceItemProviderAdapterFactory());
        this.adapterFactory.addAdapterFactory((AdapterFactory)new SpecificationItemProviderAdapterFactory());
        this.adapterFactory.addAdapterFactory((AdapterFactory)new EcoreItemProviderAdapterFactory());
        this.adapterFactory.addAdapterFactory((AdapterFactory)new ReflectiveItemProviderAdapterFactory());
        CommandStackDelegate commandStack = new CommandStackDelegate(this.getCommandStack());
        commandStack.addCommandStackListener(new CommandStackListener(){

            public void commandStackChanged(EventObject event) {
                MultiPagePSCatalogEditor.this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        MultiPagePSCatalogEditor.this.firePropertyChange(257);
                        if ((this).MultiPagePSCatalogEditor.this.propertySheetPage != null && !(this).MultiPagePSCatalogEditor.this.propertySheetPage.getControl().isDisposed()) {
                            (this).MultiPagePSCatalogEditor.this.propertySheetPage.refresh();
                        }
                    }
                });
            }
        });
        this.editingDomain = new AdapterFactoryEditingDomain((AdapterFactory)this.adapterFactory, (CommandStack)commandStack, new HashMap());
        this.editingDomain.getResourceSet().getResourceFactoryRegistry().getExtensionToFactoryMap().put("*", new IDUsingResourceFactory());
    }

    public AdapterFactoryEditingDomain getEditingDomain() {
        return (AdapterFactoryEditingDomain)super.getEditingDomain();
    }

    protected PropertySheetPage getPropertySheetPage() {
        if (this.propertySheetPage == null) {
            this.propertySheetPage = new PropertySheetPage();
            this.propertySheetPage.setPropertySourceProvider((IPropertySourceProvider)new ModelViewAdapterFactoryContentProvider((AdapterFactory)this.adapterFactory));
        }
        return this.propertySheetPage;
    }

    public PSCatalog getCatalog() {
        return this.catalog;
    }

    public String getContributorId() {
        return TABBED_PROPERTY_CONTRIBUTOR_ID;
    }
}

