/*
 * Decompiled with CFR 0.152.
 */
package org.reclipse.structure.specification.ui.edit.policies;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.requests.CreateRequest;
import org.fujaba.commons.edit.commands.SetConstraintCommand;
import org.fujaba.commons.edit.parts.AbstractDiagramEditPart;
import org.fujaba.commons.edit.parts.AbstractNodeEditPart;
import org.fujaba.commons.edit.parts.AbstractNodeViewEditPart;
import org.fujaba.commons.edit.policies.AbstractLayoutEditPolicy;
import org.fujaba.commons.notation.Node;
import org.reclipse.structure.specification.ModifierType;
import org.reclipse.structure.specification.PSAnnotation;
import org.reclipse.structure.specification.PSCombinedFragment;
import org.reclipse.structure.specification.PSCombinedFragmentItem;
import org.reclipse.structure.specification.PSObject;
import org.reclipse.structure.specification.PSSpecificationConstraint;
import org.reclipse.structure.specification.ui.edit.commands.CreatePSAnnotationCommand;
import org.reclipse.structure.specification.ui.edit.commands.CreatePSCombinedFragmentCommand;
import org.reclipse.structure.specification.ui.edit.commands.CreatePSObjectCommand;
import org.reclipse.structure.specification.ui.edit.commands.CreatePSSpecificationConstraintCommand;
import org.reclipse.structure.specification.ui.edit.parts.PSCombinedFragmentEditPart;
import org.reclipse.structure.specification.ui.edit.parts.PSPatternSpecificationEditPart;
import org.reclipse.structure.specification.util.ModelHelper;

public class PSLayoutEditPolicy
extends AbstractLayoutEditPolicy {
    protected Command createChangeConstraintCommand(EditPart child, Object constraint) {
        if (this.getHost() instanceof PSCombinedFragmentEditPart && child instanceof AbstractNodeViewEditPart) {
            Rectangle rect = (Rectangle)constraint;
            CompoundCommand cc = new CompoundCommand();
            cc.add((Command)new SetConstraintCommand((AbstractNodeViewEditPart)child, rect));
            if (child instanceof PSCombinedFragmentEditPart) {
                PSCombinedFragmentEditPart part = (PSCombinedFragmentEditPart)child;
                for (Object partChild : part.getChildren()) {
                    AbstractNodeViewEditPart realChild = (AbstractNodeViewEditPart)partChild;
                    Rectangle childRect = new Rectangle(this.getRectangle(realChild.getModel()));
                    cc.add((Command)new SetConstraintCommand(realChild, childRect));
                }
            }
            return cc.unwrap();
        }
        return super.createChangeConstraintCommand(child, constraint);
    }

    protected Command getCreateCommand(CreateRequest request) {
        if (this.getHost() instanceof AbstractDiagramEditPart && request.getNewObjectType() instanceof Class) {
            AbstractDiagramEditPart host = (AbstractDiagramEditPart)this.getHost();
            Class type = (Class)request.getNewObjectType();
            if (PSObject.class.isAssignableFrom(type)) {
                return this.createPSObjectCommand(host, request);
            }
            if (PSAnnotation.class.isAssignableFrom(type)) {
                return this.createPSAnnotationCommand(host, request);
            }
            if (PSCombinedFragment.class.isAssignableFrom(type)) {
                return this.createPSCombinedFragmentCommand(host, request);
            }
            if (PSSpecificationConstraint.class.isAssignableFrom(type)) {
                return this.createPSSpecificationConstraintCommand(host, request);
            }
        }
        return null;
    }

    private Command createPSSpecificationConstraintCommand(AbstractDiagramEditPart host, CreateRequest req) {
        Rectangle bounds = (Rectangle)this.getConstraintFor(req);
        return new CreatePSSpecificationConstraintCommand(host, bounds);
    }

    private Command createPSAnnotationCommand(AbstractDiagramEditPart host, CreateRequest req) {
        Rectangle bounds = (Rectangle)this.getConstraintFor(req);
        return new CreatePSAnnotationCommand(host, bounds);
    }

    private Command createPSObjectCommand(AbstractDiagramEditPart host, CreateRequest req) {
        Rectangle bounds = (Rectangle)this.getConstraintFor(req);
        return new CreatePSObjectCommand(host, bounds);
    }

    private Command createPSCombinedFragmentCommand(AbstractDiagramEditPart host, CreateRequest req) {
        Rectangle bounds = (Rectangle)this.getConstraintFor(req);
        ArrayList<Node> elements = new ArrayList<Node>();
        this.addPartsInside(elements, host, bounds);
        PSCombinedFragment newFragment = (PSCombinedFragment)req.getNewObject();
        CompoundCommand cc = new CompoundCommand();
        if (this.isValidFragment(host.getRealModel(), newFragment, elements)) {
            if (newFragment.getKind() == ModifierType.SET) {
                cc.add((Command)new CreatePSCombinedFragmentCommand(host, newFragment, bounds, elements, true));
            } else {
                List<AbstractNodeEditPart> children = this.getDirectPartsInside(host, bounds);
                ArrayList<Node> cNodes = new ArrayList<Node>();
                for (AbstractNodeEditPart child : children) {
                    Rectangle constraint = this.getRectangle(child.getModel());
                    constraint.x -= bounds.x + 1;
                    constraint.y -= bounds.y + 20;
                    cc.add((Command)new SetConstraintCommand((AbstractNodeViewEditPart)child, constraint));
                    cNodes.add(child.getModel());
                }
                cc.add((Command)new CreatePSCombinedFragmentCommand(host, newFragment, bounds, cNodes, false));
            }
        }
        return cc;
    }

    private boolean isValidFragment(EObject hostModel, PSCombinedFragment newFrag, List<Node> nodes) {
        block11: {
            ArrayList<PSCombinedFragmentItem> items;
            block10: {
                items = new ArrayList<PSCombinedFragmentItem>();
                for (Node node : nodes) {
                    if (!(node.getModel() instanceof PSCombinedFragmentItem)) continue;
                    items.add((PSCombinedFragmentItem)node.getModel());
                }
                if (items.isEmpty()) {
                    return false;
                }
                if (newFrag.getKind() != ModifierType.NEGATIVE) break block10;
                if (hostModel instanceof PSCombinedFragment && ((PSCombinedFragment)hostModel).getKind() == ModifierType.NEGATIVE) {
                    return false;
                }
                for (PSCombinedFragmentItem item : items) {
                    if (item instanceof PSCombinedFragment) {
                        return false;
                    }
                    for (PSCombinedFragment parent : item.getParents()) {
                        if (parent.getKind() == ModifierType.NEGATIVE) {
                            return false;
                        }
                        if (parent.getParents().isEmpty()) continue;
                        return false;
                    }
                }
                break block11;
            }
            if (newFrag.getKind() != ModifierType.ADDITIONAL) break block11;
            for (PSCombinedFragmentItem item : items) {
                if (item instanceof PSCombinedFragment && this.getDepth((PSCombinedFragment)item) > 1) {
                    return false;
                }
                for (PSCombinedFragment parent : item.getParents()) {
                    if (parent.getParents().isEmpty()) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private int getDepth(PSCombinedFragment item) {
        int depth = 0;
        for (PSCombinedFragmentItem child : item.getChildren()) {
            if (!(child instanceof PSCombinedFragment)) continue;
            depth += this.getDepth((PSCombinedFragment)child);
        }
        return depth + 1;
    }

    private List<AbstractNodeEditPart> getDirectPartsInside(AbstractDiagramEditPart host, Rectangle bounds) {
        ArrayList<AbstractNodeEditPart> list = new ArrayList<AbstractNodeEditPart>();
        for (Object child : host.getChildren()) {
            AbstractNodeEditPart cPart;
            if (!(child instanceof AbstractNodeEditPart) || !bounds.contains(this.getRectangle((cPart = (AbstractNodeEditPart)child).getModel())) || cPart.getRealModel() instanceof PSAnnotation && ModelHelper.isCreate((PSAnnotation)((PSAnnotation)cPart.getRealModel()))) continue;
            list.add(cPart);
        }
        return list;
    }

    private Rectangle getRectangle(Node model) {
        int x = model.getX();
        int y = model.getY();
        int w = model.getWidth();
        int h = model.getHeight();
        return new Rectangle(x, y, w, h);
    }

    private List<Node> addPartsInside(List<Node> items, AbstractDiagramEditPart part, Rectangle bounds) {
        if (!(!bounds.contains(this.getRectangle((Node)part.getModel())) || part.getRealModel() instanceof PSAnnotation && ModelHelper.isCreate((PSAnnotation)((PSAnnotation)part.getRealModel())))) {
            items.add((Node)part.getModel());
        }
        if (part instanceof PSCombinedFragmentEditPart || part instanceof PSPatternSpecificationEditPart) {
            for (Object child : part.getChildren()) {
                if (!(child instanceof AbstractDiagramEditPart)) continue;
                this.addPartsInside(items, (AbstractDiagramEditPart)child, bounds);
            }
        }
        return items;
    }
}

