/*
 * Decompiled with CFR 0.152.
 */
package org.reclipse.structure.specification.ui.edit.policies;

import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.editpolicies.ComponentEditPolicy;
import org.eclipse.gef.requests.GroupRequest;
import org.fujaba.commons.edit.commands.SetConstraintCommand;
import org.fujaba.commons.edit.parts.AbstractDiagramEditPart;
import org.fujaba.commons.edit.parts.AbstractEdgeEditPart;
import org.fujaba.commons.edit.parts.AbstractNodeEditPart;
import org.fujaba.commons.edit.parts.AbstractNodeViewEditPart;
import org.fujaba.commons.notation.Edge;
import org.fujaba.commons.notation.HierarchicalNode;
import org.fujaba.commons.notation.Node;
import org.reclipse.structure.specification.PSAnnotation;
import org.reclipse.structure.specification.PSCombinedFragment;
import org.reclipse.structure.specification.PSNode;
import org.reclipse.structure.specification.PSNodeConstraint;
import org.reclipse.structure.specification.PSSpecificationConstraint;
import org.reclipse.structure.specification.ui.edit.commands.DeletePSCombinedFragmentItemCommand;
import org.reclipse.structure.specification.ui.edit.commands.DeletePSConnectionCommand;
import org.reclipse.structure.specification.ui.edit.commands.DeletePSNodeConstraintCommand;
import org.reclipse.structure.specification.ui.edit.commands.DragPSCombinedFragmentItemCommand;
import org.reclipse.structure.specification.util.ModelHelper;

public class PSDeleteEditPolicy
extends ComponentEditPolicy {
    protected Command createDeleteCommand(GroupRequest request) {
        if (request.getEditParts().size() > 0) {
            CompoundCommand compound = new CompoundCommand();
            for (Object part : request.getEditParts()) {
                EObject model;
                HierarchicalNode parent;
                HierarchicalNode view;
                if (part instanceof AbstractDiagramEditPart) {
                    view = ((AbstractDiagramEditPart)part).getModel();
                    parent = view.getParent();
                    model = view.getModel();
                    if (model instanceof PSCombinedFragment) {
                        compound.add(this.getPSCombinedFragmentDeleteCommand((AbstractDiagramEditPart)part, ((AbstractDiagramEditPart)part).getParent()));
                        continue;
                    }
                    if (!(model instanceof PSNode) || model instanceof PSAnnotation && ModelHelper.isCreate((PSAnnotation)((PSAnnotation)model))) continue;
                    compound.add(this.getPSNodeDeleteCommand(view, parent));
                    continue;
                }
                if (part instanceof AbstractNodeEditPart) {
                    view = ((AbstractNodeEditPart)part).getModel();
                    parent = view.getParent();
                    model = view.getModel();
                    if (model instanceof PSSpecificationConstraint) {
                        compound.add(this.getPSSpecificationConstraintDeleteCommand((Node)view, parent));
                        continue;
                    }
                    if (!(model instanceof PSNodeConstraint)) continue;
                    compound.add(this.getPSNodeConstraintDeleteCommand((Node)view, parent));
                    continue;
                }
                if (!(part instanceof AbstractEdgeEditPart)) continue;
                view = ((AbstractEdgeEditPart)part).getModel();
                compound.add(this.getPSConnectionDeleteCommand((Edge)view));
            }
            return compound.unwrap();
        }
        return null;
    }

    private Command getPSNodeConstraintDeleteCommand(Node view, HierarchicalNode parent) {
        return new DeletePSNodeConstraintCommand(view, parent);
    }

    private Command getPSConnectionDeleteCommand(Edge view) {
        return new DeletePSConnectionCommand(view);
    }

    private Command getPSCombinedFragmentDeleteCommand(AbstractDiagramEditPart part, EditPart parent) {
        CompoundCommand compound = new CompoundCommand();
        for (Object child : part.getChildren()) {
            AbstractNodeEditPart cPart;
            if (!(child instanceof AbstractNodeEditPart) || (cPart = (AbstractNodeEditPart)child).getRealModel() instanceof PSNodeConstraint) continue;
            Rectangle nRect = this.getRectangle(cPart.getModel());
            nRect.x += part.getModel().getX() + 1;
            nRect.y += part.getModel().getY() + 20;
            compound.add((Command)new DragPSCombinedFragmentItemCommand(cPart.getModel(), part.getModel()));
            compound.add((Command)new SetConstraintCommand((AbstractNodeViewEditPart)cPart, nRect));
        }
        if (parent != null && parent instanceof AbstractDiagramEditPart) {
            compound.add((Command)new DeletePSCombinedFragmentItemCommand((Node)part.getModel(), ((AbstractDiagramEditPart)parent).getModel()));
        }
        return compound;
    }

    private Rectangle getRectangle(Node model) {
        int x = model.getX();
        int y = model.getY();
        int w = model.getWidth();
        int h = model.getHeight();
        return new Rectangle(x, y, w, h);
    }

    private Command getPSSpecificationConstraintDeleteCommand(Node node, HierarchicalNode parent) {
        return new DeletePSCombinedFragmentItemCommand(node, parent);
    }

    private Command getPSNodeDeleteCommand(HierarchicalNode node, HierarchicalNode parent) {
        CompoundCommand cmd = new CompoundCommand();
        for (Node constraints : node.getNodes()) {
            cmd.add(this.getPSNodeConstraintDeleteCommand(constraints, node));
        }
        for (Edge source : node.getIncoming()) {
            cmd.add(this.getPSConnectionDeleteCommand(source));
        }
        for (Edge target : node.getOutgoing()) {
            cmd.add(this.getPSConnectionDeleteCommand(target));
        }
        cmd.add((Command)new DeletePSCombinedFragmentItemCommand((Node)node, parent));
        return cmd.unwrap();
    }
}

