/*
 * Decompiled with CFR 0.152.
 */
package org.reclipse.structure.specification.ui.edit.parts;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.RotatableDecoration;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.gef.EditPolicy;
import org.fujaba.commons.edit.parts.AbstractEdgeEditPart;
import org.fujaba.commons.figures.DoublePolylineConnection;
import org.fujaba.commons.figures.utils.ConnectionDecorationFactory;
import org.reclipse.structure.specification.PSPath;
import org.reclipse.structure.specification.ui.edit.policies.PSDeleteEditPolicy;

public class PSPathEditPart
extends AbstractEdgeEditPart {
    public void notifyChanged(Notification notification) {
        int featureId = notification.getFeatureID(PSPath.class);
        if (featureId == 2 || featureId == 7 || featureId == 3) {
            this.refreshVisuals();
        }
        super.notifyChanged(notification);
    }

    protected void createEditPolicies() {
        super.createEditPolicies();
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new PSDeleteEditPolicy());
    }

    protected IFigure createFigure() {
        DoublePolylineConnection connection = new DoublePolylineConnection();
        connection.setForegroundColor(ColorConstants.black);
        connection.setTargetDecoration((RotatableDecoration)ConnectionDecorationFactory.createDecoration((int)1));
        this.connection = connection;
        return this.connection;
    }

    public void refreshVisuals() {
        super.refreshVisuals();
        PSPath model = (PSPath)this.getRealModel();
        if (model.getTabooClasses().isEmpty()) {
            this.placeLabel(new String());
        } else {
            StringBuffer labelBuffer = new StringBuffer("( w/o ");
            for (EClass taboo : model.getTabooClasses()) {
                labelBuffer.append(String.valueOf(taboo.getName()) + ", ");
            }
            this.placeLabel(labelBuffer.delete(labelBuffer.length() - 2, labelBuffer.length() - 1) + ")");
        }
    }
}

