/*
 * Decompiled with CFR 0.152.
 */
package org.reclipse.structure.specification.ui.edit.parts;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.TextUtilities;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.fujaba.commons.Commons4EclipseFonts;
import org.fujaba.commons.edit.parts.AbstractDiagramEditPart;
import org.fujaba.commons.edit.parts.AbstractNodeViewEditPart;
import org.fujaba.commons.figures.LabelFigure;
import org.reclipse.structure.specification.ModifierType;
import org.reclipse.structure.specification.PSAttributeConstraint;
import org.reclipse.structure.specification.PSFuzzyMetricConstraint;
import org.reclipse.structure.specification.PSFuzzySetRatingConstraint;
import org.reclipse.structure.specification.PSMetricConstraint;
import org.reclipse.structure.specification.PSNodeConstraint;
import org.reclipse.structure.specification.PSObject;
import org.reclipse.structure.specification.ui.edit.policies.PSDeleteEditPolicy;
import org.reclipse.structure.specification.ui.edit.policies.PSNodeEditPolicy;
import org.reclipse.structure.specification.ui.figures.PSObjectFigure;

public class PSObjectEditPart
extends AbstractDiagramEditPart {
    public PSObject getRealModel() {
        return (PSObject)super.getRealModel();
    }

    public PSObjectFigure getFigure() {
        return (PSObjectFigure)super.getFigure();
    }

    protected IFigure createFigure() {
        return new PSObjectFigure();
    }

    protected void createEditPolicies() {
        this.installEditPolicy("NodeEditPolicy", (EditPolicy)new PSNodeEditPolicy());
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new PSDeleteEditPolicy());
    }

    public void notifyChanged(Notification notification) {
        int featureId = notification.getFeatureID(PSObject.class);
        if (featureId == 2 || featureId == 3 || featureId == 6 || featureId == 11) {
            this.refreshVisuals();
        } else if (featureId == 10) {
            this.refreshChildren();
        }
        super.notifyChanged(notification);
    }

    protected void refreshVisuals() {
        super.refreshVisuals();
        String type = "null";
        if (this.getRealModel().getInstanceOf() != null) {
            type = this.getRealModel().getInstanceOf().getName();
        }
        String weight = new String();
        if (this.getRealModel().getWeight() != 1.0) {
            weight = "{w=" + this.getRealModel().getWeight() + "}";
        }
        boolean negative = this.getRealModel().getModifier() == ModifierType.NEGATIVE;
        boolean dashed = this.getRealModel().getModifier() == ModifierType.ADDITIONAL || this.getRealModel().getModifier() == ModifierType.SET;
        this.getFigure().setName(String.valueOf(this.getRealModel().getName()) + ":" + type);
        this.getFigure().setWeightText(weight);
        this.getFigure().setNegative(negative);
        this.getFigure().setDashedLine(dashed);
        this.getFigure().setTrigger(this.getRealModel().isTrigger());
        this.getFigure().setShadowed(this.getRealModel().getModifier() == ModifierType.SET);
        this.getFigure().revalidate();
    }

    protected void addChildVisual(EditPart child, int index) {
        PSNodeConstraint model = (PSNodeConstraint)((AbstractNodeViewEditPart)child).getRealModel();
        LabelFigure figure = (LabelFigure)((AbstractGraphicalEditPart)child).getFigure();
        this.addConstraint(figure, model);
    }

    protected void removeChildVisual(EditPart child) {
        PSNodeConstraint model = (PSNodeConstraint)((AbstractNodeViewEditPart)child).getRealModel();
        LabelFigure figure = (LabelFigure)((AbstractGraphicalEditPart)child).getFigure();
        this.removeConstraint(figure, model);
    }

    private void removeConstraint(LabelFigure child, PSNodeConstraint type) {
        PSObjectFigure figure = this.getFigure();
        if (type instanceof PSAttributeConstraint) {
            figure.removeFromAttributeConstraints(child);
        } else if (type instanceof PSMetricConstraint) {
            String acronym = ((PSMetricConstraint)type).getMetricAcronym();
            if (acronym != null && acronym.equals("SIZE")) {
                figure.removeFromSetConstraints(child);
            } else {
                figure.removeFromMetricConstraints(child);
            }
        } else if (type instanceof PSFuzzyMetricConstraint) {
            if (((PSFuzzyMetricConstraint)type).getMetricAcronym().equals("SIZE")) {
                figure.removeFromSetConstraints(child);
            } else {
                figure.removeFromMetricConstraints(child);
            }
        } else if (type instanceof PSFuzzySetRatingConstraint) {
            figure.removeFromSetConstraints(child);
        }
    }

    public void addConstraint(LabelFigure child, PSNodeConstraint type) {
        PSObjectFigure figure = this.getFigure();
        if (type instanceof PSAttributeConstraint) {
            figure.addToAttributeConstraints(child);
        } else if (type instanceof PSMetricConstraint) {
            String acronym = ((PSMetricConstraint)type).getMetricAcronym();
            if (acronym != null && acronym.equals("SIZE")) {
                figure.addToSetConstraints(child);
            } else {
                figure.addToMetricConstraints(child);
            }
        } else if (type instanceof PSFuzzyMetricConstraint) {
            if (((PSFuzzyMetricConstraint)type).getMetricAcronym().equals("SIZE")) {
                figure.addToSetConstraints(child);
            } else {
                figure.addToMetricConstraints(child);
            }
        } else if (type instanceof PSFuzzySetRatingConstraint) {
            figure.addToSetConstraints(child);
        }
    }

    public Dimension getMinimumSize() {
        int gapH = 6;
        int gapW = 14;
        if (this.getRealModel().isTrigger()) {
            gapW += 2;
        }
        StringBuffer text = new StringBuffer(String.valueOf(this.getRealModel().getName()) + ":");
        if (this.getRealModel().getInstanceOf() != null) {
            text.append(this.getRealModel().getInstanceOf().getName());
        } else {
            text.append("null");
        }
        Dimension min = TextUtilities.INSTANCE.getStringExtents(text.toString(), Commons4EclipseFonts.getFont((String)"org.fujaba.commons.FONT_BOLD"));
        return new Dimension(min.width + gapW, min.height + gapH);
    }
}

