/*
 * Decompiled with CFR 0.152.
 */
package org.reclipse.structure.specification.ui.edit.parts;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.ConnectionLocator;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.RotatableDecoration;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.gef.EditPolicy;
import org.eclipse.swt.graphics.Color;
import org.fujaba.commons.edit.parts.AbstractEdgeEditPart;
import org.fujaba.commons.figures.CrossFigure;
import org.fujaba.commons.figures.utils.ConnectionDecorationFactory;
import org.reclipse.structure.specification.PSAnnotation;
import org.reclipse.structure.specification.PSLink;
import org.reclipse.structure.specification.ui.edit.policies.PSDeleteEditPolicy;
import org.reclipse.structure.specification.ui.utils.PSConstants;
import org.reclipse.structure.specification.util.ModelHelper;

public class PSLinkEditPart
extends AbstractEdgeEditPart {
    private CrossFigure crossFigure = null;
    private ConnectionLocator crossLocator = null;

    public void notifyChanged(Notification notification) {
        int featureId = notification.getFeatureID(PSLink.class);
        if (featureId == 9 || featureId == 2 || featureId == 8 || featureId == 7 || featureId == 3) {
            this.refreshVisuals();
        }
        super.notifyChanged(notification);
    }

    protected void createEditPolicies() {
        super.createEditPolicies();
        this.installEditPolicy("ConnectionEditPolicy", (EditPolicy)new PSDeleteEditPolicy());
    }

    public void refreshVisuals() {
        super.refreshVisuals();
        StringBuffer text = new StringBuffer();
        PSLink model = this.getRealModel();
        this.placeReadingDirectionArrow(true);
        this.connection.setForegroundColor(ColorConstants.black);
        if (model.getSource() instanceof PSAnnotation) {
            if (ModelHelper.isCreate((PSAnnotation)((PSAnnotation)model.getSource()))) {
                Color createColor = PSConstants.COLOR__CREATE;
                this.connection.setForegroundColor(createColor);
                this.placeReadingDirectionArrow(true, createColor, createColor);
                text.append("\u00abcreate\u00bb");
                text.append("\n");
            }
            if (model.getQualifier() != null && model.getQualifier().length() > 0) {
                text.append(model.getQualifier());
            } else {
                text.append("\u00abno qualifier\u00bb");
            }
        } else {
            if (model.getInstanceOf() != null) {
                if (model.getInstanceOf().getEOpposite() == null) {
                    this.connection.setTargetDecoration((RotatableDecoration)ConnectionDecorationFactory.createDecoration((int)1));
                } else {
                    this.connection.setTargetDecoration(null);
                }
                text.append(model.getInstanceOf().getName());
            } else {
                text.append("\u00abno qualifier\u00bb");
            }
            if (model.getQualifier() != null && model.getQualifier().length() > 0) {
                text.append(" [" + model.getQualifier() + "]");
            }
        }
        if (text.length() > 0) {
            this.placeLabel(text.toString());
        }
        if (model.isNegative()) {
            if (this.crossFigure == null) {
                this.crossFigure = new CrossFigure();
                this.crossLocator = new ConnectionLocator((Connection)this.connection, 4);
            }
            this.connection.add((IFigure)this.crossFigure, (Object)this.crossLocator);
        } else if (this.crossFigure != null && this.crossFigure.getParent() == this.connection) {
            this.connection.remove((IFigure)this.crossFigure);
        }
    }

    public PSLink getRealModel() {
        return (PSLink)super.getRealModel();
    }
}

