/*
 * Decompiled with CFR 0.152.
 */
package org.reclipse.structure.specification.ui.edit.parts;

import org.eclipse.draw2d.IFigure;
import org.eclipse.emf.common.notify.Notification;
import org.fujaba.commons.figures.LabelFigure;
import org.reclipse.math.functions.Lim0EFunction;
import org.reclipse.math.functions.Lim1EFunction;
import org.reclipse.math.functions.Lim1EFunctionNOA;
import org.reclipse.math.functions.Lim1EFunctionNOM;
import org.reclipse.math.functions.Lim1EFunctionWLOC;
import org.reclipse.math.functions.LinearFunction;
import org.reclipse.math.functions.MathematicalFunction;
import org.reclipse.structure.specification.PSFuzzyConstraint;
import org.reclipse.structure.specification.PSFuzzyMetricConstraint;
import org.reclipse.structure.specification.PSFuzzySetRatingConstraint;
import org.reclipse.structure.specification.SpecificationPackage;
import org.reclipse.structure.specification.ui.edit.parts.AbstractPSNodeConstraintEditPart;
import org.reclipse.structure.specification.ui.figures.FuzzyFunctionFigure;
import org.reclipse.structure.specification.ui.figures.Lim0EFunctionFigure;
import org.reclipse.structure.specification.ui.figures.Lim1EFunctionFigure;
import org.reclipse.structure.specification.ui.figures.LinearFunctionFigure;
import org.reclipse.structure.specification.ui.utils.MathFunctionHelper;

public class PSFuzzyConstraintEditPart
extends AbstractPSNodeConstraintEditPart {
    public PSFuzzyConstraint getRealModel() {
        return (PSFuzzyConstraint)super.getRealModel();
    }

    public void notifyChanged(Notification notification) {
        SpecificationPackage p = SpecificationPackage.eINSTANCE;
        Object feature = notification.getFeature();
        if (p.getPSFuzzyMetricConstraint_MetricAcronym().equals(feature) || p.getPSItem_Weight().equals(feature)) {
            this.refreshVisuals();
        }
        if (p.getPSFunctionParameter_Value().equals(feature) || p.getPSFuzzyConstraint_MathFunctionID().equals(feature) || p.getPSFuzzyConstraint_Parameters().equals(feature)) {
            this.configureToolTip();
        }
        super.notifyChanged(notification);
    }

    protected void refreshVisuals() {
        super.refreshVisuals();
        LabelFigure figure = this.getFigure();
        StringBuilder text = new StringBuilder();
        if (this.getRealModel() instanceof PSFuzzyMetricConstraint) {
            text.append("fuzzy constraint: ");
            PSFuzzyMetricConstraint expr = (PSFuzzyMetricConstraint)this.getRealModel();
            text.append(expr.getMetricAcronym());
        } else if (this.getRealModel() instanceof PSFuzzySetRatingConstraint) {
            text.append("set rating function");
        }
        figure.setText(text.toString());
    }

    protected void configureToolTip() {
        LabelFigure figure = this.getFigure();
        if (figure.getToolTip() != null && ((FuzzyFunctionFigure)this.getFigure().getToolTip()).getFunction() == MathFunctionHelper.getMathematicalFunction(this.getRealModel())) {
            return;
        }
        figure.setToolTip((IFigure)this.getToolTipFigure());
    }

    protected FuzzyFunctionFigure getToolTipFigure() {
        MathematicalFunction function = MathFunctionHelper.getMathematicalFunction(this.getRealModel());
        FuzzyFunctionFigure figure = null;
        String xName = "";
        if (this.getRealModel() instanceof PSFuzzyMetricConstraint) {
            PSFuzzyMetricConstraint expr = (PSFuzzyMetricConstraint)this.getRealModel();
            xName = expr.getMetricAcronym();
        }
        if (function instanceof Lim0EFunction) {
            figure = new Lim0EFunctionFigure(xName);
        } else if (function instanceof Lim1EFunction || function instanceof Lim1EFunctionNOA || function instanceof Lim1EFunctionNOM || function instanceof Lim1EFunctionWLOC) {
            figure = new Lim1EFunctionFigure(xName);
        } else if (function instanceof LinearFunction) {
            figure = new LinearFunctionFigure(xName);
        }
        if (figure != null) {
            figure.setPreferredSize(300, 150);
            figure.setFunction(function);
        }
        return figure;
    }
}

