/*
 * Decompiled with CFR 0.152.
 */
package org.reclipse.structure.specification.ui.edit.parts;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.fujaba.commons.edit.parts.AbstractDiagramEditPart;
import org.fujaba.commons.edit.parts.AbstractNodeEditPart;
import org.fujaba.commons.figures.LabelFigure;
import org.reclipse.structure.specification.OperatorType;
import org.reclipse.structure.specification.PSCombinedFragment;
import org.reclipse.structure.specification.PSFuzzyMetricConstraint;
import org.reclipse.structure.specification.PSMetricConstraint;
import org.reclipse.structure.specification.ui.edit.parts.PSFuzzyConstraintEditPart;
import org.reclipse.structure.specification.ui.edit.parts.PSMetricConstraintEditPart;
import org.reclipse.structure.specification.ui.edit.policies.PSDeleteEditPolicy;
import org.reclipse.structure.specification.ui.edit.policies.PSLayoutEditPolicy;
import org.reclipse.structure.specification.ui.figures.PSCombinedFragmentFigure;
import org.reclipse.structure.specification.util.ModelHelper;

public class PSCombinedFragmentEditPart
extends AbstractDiagramEditPart {
    public PSCombinedFragment getRealModel() {
        return (PSCombinedFragment)super.getRealModel();
    }

    protected void createEditPolicies() {
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)new PSLayoutEditPolicy());
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new PSDeleteEditPolicy());
    }

    protected IFigure createFigure() {
        return new PSCombinedFragmentFigure();
    }

    public void notifyChanged(Notification notification) {
        int fid = notification.getFeatureID(PSCombinedFragment.class);
        if (6 == fid || 2 == fid || 3 == fid) {
            this.refreshVisuals();
        }
        super.notifyChanged(notification);
    }

    public Dimension getPreferredSize() {
        int height = this.getFigure().getPreferredSize().height;
        int width = this.getFigure().getPreferredSize().width;
        for (Object child : this.getChildren()) {
            int right = ((AbstractNodeEditPart)child).getFigure().getBounds().right();
            int bottom = ((AbstractNodeEditPart)child).getFigure().getBounds().bottom();
            height = Math.max(height, bottom + 10 - this.getFigure().getBounds().y);
            width = Math.max(width, right + 10 - this.getFigure().getBounds().x);
        }
        return new Dimension(width, height);
    }

    protected void refreshVisuals() {
        super.refreshVisuals();
        PSCombinedFragment model = this.getRealModel();
        PSCombinedFragmentFigure figure = (PSCombinedFragmentFigure)this.getFigure();
        StringBuilder text = new StringBuilder();
        switch (model.getKind()) {
            case ADDITIONAL: {
                text.append("additional");
                break;
            }
            case NEGATIVE: {
                text.append("negative");
                break;
            }
            case SET: {
                text.append("set");
                figure.setOpaque(false);
                break;
            }
            default: {
                text.append("none");
            }
        }
        if (model.getWeight() != 1.0) {
            text.append(" {w=" + model.getWeight() + "}");
        }
        if (model.getConstraint() != null) {
            if (model.getConstraint() instanceof PSMetricConstraint) {
                PSMetricConstraint c = (PSMetricConstraint)model.getConstraint();
                text.append(" (size ");
                text.append(ModelHelper.getReadable((OperatorType)c.getOperator()));
                text.append(" " + c.getValueExpression());
                text.append(")");
            } else if (model.getConstraint() instanceof PSFuzzyMetricConstraint) {
                text.append(" (fuzzy constrained size)");
            }
        }
        figure.setText(text.toString());
        figure.revalidate();
    }

    protected void addChildVisual(EditPart child, int index) {
        if (child instanceof PSFuzzyConstraintEditPart || child instanceof PSMetricConstraintEditPart) {
            PSCombinedFragmentFigure figure = (PSCombinedFragmentFigure)this.getFigure();
            LabelFigure childFigure = (LabelFigure)((AbstractNodeEditPart)child).getFigure();
            figure.addConstraint(childFigure);
        } else {
            super.addChildVisual(child, index);
        }
    }

    protected void removeChildVisual(EditPart child) {
        if (child instanceof PSFuzzyConstraintEditPart || child instanceof PSMetricConstraintEditPart) {
            PSCombinedFragmentFigure figure = (PSCombinedFragmentFigure)this.getFigure();
            LabelFigure constraint = (LabelFigure)((AbstractNodeEditPart)child).getFigure();
            figure.removeConstraint(constraint);
        } else {
            super.removeChildVisual(child);
        }
    }
}

