/*
 * Decompiled with CFR 0.152.
 */
package org.reclipse.structure.specification.ui.edit.parts;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.EllipseAnchor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.fujaba.commons.Commons4EclipseFonts;
import org.fujaba.commons.edit.parts.AbstractDiagramEditPart;
import org.fujaba.commons.figures.LabelFigure;
import org.reclipse.structure.specification.ModifierType;
import org.reclipse.structure.specification.PSAnnotation;
import org.reclipse.structure.specification.ui.edit.policies.PSDeleteEditPolicy;
import org.reclipse.structure.specification.ui.edit.policies.PSNodeEditPolicy;
import org.reclipse.structure.specification.ui.figures.PSAnnotationFigure;
import org.reclipse.structure.specification.util.ModelHelper;

public class PSAnnotationEditPart
extends AbstractDiagramEditPart {
    private LabelFigure create;

    public PSAnnotation getRealModel() {
        return (PSAnnotation)super.getRealModel();
    }

    public PSAnnotationFigure getFigure() {
        return (PSAnnotationFigure)super.getFigure();
    }

    protected IFigure createFigure() {
        PSAnnotationFigure figure = new PSAnnotationFigure();
        this.anchor = new EllipseAnchor((IFigure)figure);
        return figure;
    }

    protected void createEditPolicies() {
        this.installEditPolicy("NodeEditPolicy", (EditPolicy)new PSNodeEditPolicy());
        if (!ModelHelper.isCreate((PSAnnotation)this.getRealModel())) {
            this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new PSDeleteEditPolicy());
        }
    }

    public void notifyChanged(Notification notification) {
        int id = notification.getFeatureID(PSAnnotation.class);
        if (id == 2 || id == 3 || id == 6 || id == 5 || id == 11) {
            this.refreshVisuals();
        } else if (id == 10) {
            this.refreshChildren();
        }
        super.notifyChanged(notification);
    }

    protected void refreshVisuals() {
        super.refreshVisuals();
        PSAnnotationFigure figure = this.getFigure();
        PSAnnotation model = this.getRealModel();
        boolean isCreate = ModelHelper.isCreate((PSAnnotation)model);
        String name = "";
        String type = "";
        String weight = "";
        if (!isCreate) {
            name = model.getName();
        } else {
            this.addCreateProperties(figure);
        }
        if (model.getType() != null) {
            type = model.getType().getName();
        }
        if (model.getWeight() != 1.0) {
            weight = "{w=" + model.getWeight() + "}";
        }
        boolean negative = model.getModifier() == ModifierType.NEGATIVE;
        boolean dashed = model.getModifier() == ModifierType.ADDITIONAL || model.getModifier() == ModifierType.SET;
        figure.setName(String.valueOf(name) + ":" + type);
        figure.setWeightText(weight);
        if (model.getType() != null) {
            figure.setAbstract(model.getType().isAbstract());
        }
        figure.setCreate(isCreate);
        figure.setTrigger(model.isTrigger());
        figure.setNegative(negative);
        figure.setDashedLine(dashed);
        figure.setShadowed(model.getModifier() == ModifierType.SET);
        figure.revalidate();
    }

    public void addCreateProperties(PSAnnotationFigure figure) {
        if (this.create == null) {
            this.create = new LabelFigure("\u00abcreate\u00bb", Commons4EclipseFonts.getFont((String)"org.eclipse.jface.defaultfont"));
            this.create.setForegroundColor(ColorConstants.darkGreen);
            figure.getParent().add((IFigure)this.create);
        }
        if (figure.getParent() != null) {
            int w = this.create.getPreferredSize().width;
            int h = this.create.getPreferredSize().height;
            int x = this.getModel().getX() + (this.getModel().getWidth() - w) / 2;
            int y = this.getModel().getY() - h - 5;
            Rectangle rect = new Rectangle(x, y, w, h);
            figure.getParent().setConstraint((IFigure)this.create, (Object)rect);
        }
    }

    protected void addChildVisual(EditPart child, int index) {
        LabelFigure label = (LabelFigure)((GraphicalEditPart)child).getFigure();
        this.getFigure().addToSetConstraints(label);
    }

    protected void removeChildVisual(EditPart child) {
        LabelFigure label = (LabelFigure)((GraphicalEditPart)child).getFigure();
        this.getFigure().removeFromSetConstraints(label);
    }
}

