/*
 * Decompiled with CFR 0.152.
 */
package org.reclipse.structure.specification.ui.edit.parts;

import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.editpolicies.NonResizableEditPolicy;
import org.fujaba.commons.edit.parts.AbstractNodeEditPart;
import org.fujaba.commons.figures.LabelFigure;
import org.reclipse.structure.specification.OperatorType;
import org.reclipse.structure.specification.PSBooleanConstraint;
import org.reclipse.structure.specification.PSNodeConstraint;
import org.reclipse.structure.specification.ui.edit.policies.PSDeleteEditPolicy;

public class AbstractPSNodeConstraintEditPart
extends AbstractNodeEditPart {
    public PSNodeConstraint getRealModel() {
        return (PSNodeConstraint)super.getRealModel();
    }

    protected IFigure createFigure() {
        MarginBorder border = new MarginBorder(2, 5, 2, 5);
        LabelFigure figure = new LabelFigure();
        figure.setLabelAlignment(1);
        figure.setBorder((Border)border);
        return figure;
    }

    public LabelFigure getFigure() {
        return (LabelFigure)super.getFigure();
    }

    protected void createEditPolicies() {
        NonResizableEditPolicy nonResizable = new NonResizableEditPolicy();
        nonResizable.setDragAllowed(false);
        this.installEditPolicy("Selection Feedback", (EditPolicy)nonResizable);
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new PSDeleteEditPolicy());
    }

    protected String getBooleanConstraintSuffix() {
        if (this.getRealModel() instanceof PSBooleanConstraint) {
            PSBooleanConstraint model = (PSBooleanConstraint)this.getRealModel();
            StringBuffer text = new StringBuffer();
            if (model.isAdditional() || model.getWeight() != 1.0) {
                text.append(" {");
                if (model.isAdditional()) {
                    text.append("additional");
                }
                if (model.getWeight() != 1.0) {
                    if (model.isAdditional()) {
                        text.append(", ");
                    }
                    text.append("w=" + model.getWeight());
                }
                text.append("}");
            }
            return text.toString();
        }
        return null;
    }

    protected String getOperatorString(OperatorType operator) {
        switch (operator) {
            case EQUAL: {
                return "=";
            }
            case UNEQUAL: {
                return "!=";
            }
            case LESS: {
                return "<";
            }
            case LESS_OR_EQUAL: {
                return "\u2264";
            }
            case GREATER: {
                return ">";
            }
            case GREATER_OR_EQUAL: {
                return "\u2265";
            }
            case REGULAR_EXPRESSION: {
                return "= RegEx:";
            }
        }
        throw new IllegalArgumentException("Unknown operator.");
    }
}

