/*
 * Decompiled with CFR 0.152.
 */
package org.reclipse.structure.specification.ui.edit.commands;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.gef.commands.Command;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.ui.PlatformUI;
import org.reclipse.structure.specification.PSFunctionParameter;
import org.reclipse.structure.specification.PSFuzzyConstraint;
import org.reclipse.structure.specification.ui.wizards.EditPSFuzzyExpressionWizard;

public class EditPSFuzzyExpressionCommand
extends Command {
    private PSFuzzyConstraint constraint = null;
    private String oldMathFct;
    private String newMathFct;
    private ArrayList<PSFunctionParameter> oldParams = new ArrayList();
    private ArrayList<PSFunctionParameter> newParams = new ArrayList();

    public EditPSFuzzyExpressionCommand(PSFuzzyConstraint constraint) {
        super("edit fuzzy constraint/function");
        this.constraint = constraint;
    }

    public void execute() {
        this.redo();
    }

    public void redo() {
        if (this.oldMathFct == null) {
            this.oldMathFct = this.constraint.getMathFunctionID();
            this.oldParams.addAll((Collection<PSFunctionParameter>)this.constraint.getParameters());
            EditPSFuzzyExpressionWizard wizard = new EditPSFuzzyExpressionWizard(this.constraint);
            WizardDialog wizardDialog = new WizardDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (IWizard)wizard);
            wizardDialog.create();
            wizardDialog.open();
            this.newParams.addAll((Collection<PSFunctionParameter>)this.constraint.getParameters());
            this.newMathFct = this.constraint.getMathFunctionID();
        } else {
            this.constraint.setMathFunctionID(this.newMathFct);
            this.constraint.getParameters().clear();
            this.constraint.getParameters().addAll(this.newParams);
        }
    }

    public void undo() {
        this.constraint.setMathFunctionID(this.oldMathFct);
        this.constraint.getParameters().clear();
        this.constraint.getParameters().addAll(this.oldParams);
    }
}

