/*
 * Decompiled with CFR 0.152.
 */
package org.reclipse.structure.specification.ui.edit.commands;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.gef.commands.Command;
import org.fujaba.commons.notation.HierarchicalNode;
import org.fujaba.commons.notation.NotationFactory;
import org.reclipse.structure.specification.PSAnnotation;
import org.reclipse.structure.specification.PSCatalog;
import org.reclipse.structure.specification.PSPatternSpecification;
import org.reclipse.structure.specification.SpecificationFactory;

public class CreatePSPatternSpecificationCommand
extends Command {
    private PSCatalog catalog;
    private Resource diagramResource;
    private String name;
    private PSPatternSpecification newPattern;
    private PSAnnotation newAnnotation;
    private HierarchicalNode newPatternView;
    private HierarchicalNode newAnnotationView;

    public CreatePSPatternSpecificationCommand(PSCatalog catalog, Resource diagramResource, String initialName) {
        super("create new pattern specification");
        this.catalog = catalog;
        this.diagramResource = diagramResource;
        this.name = initialName == null ? "New Pattern" : initialName;
    }

    public void execute() {
        this.redo();
    }

    public void redo() {
        if (this.newPattern == null) {
            this.newPattern = SpecificationFactory.eINSTANCE.createPSPatternSpecification();
        }
        this.newPattern.setName(this.name);
        this.newPattern.setCatalog(this.catalog);
        if (this.newAnnotation == null) {
            this.newAnnotation = SpecificationFactory.eINSTANCE.createPSAnnotation();
        }
        this.newAnnotation.setPatternSpecification(this.newPattern);
        this.newAnnotation.setType(this.newPattern);
        this.newAnnotation.setWeight(1.0);
        if (this.newPatternView == null) {
            this.newPatternView = NotationFactory.eINSTANCE.createHierarchicalNode();
        }
        this.newPatternView.setModel((EObject)this.newPattern);
        if (this.newAnnotationView == null) {
            this.newAnnotationView = NotationFactory.eINSTANCE.createHierarchicalNode();
        }
        this.newAnnotationView.setModel((EObject)this.newAnnotation);
        this.newAnnotationView.setPersistent(true);
        this.newAnnotationView.setVisible(true);
        this.newAnnotationView.setHeight(80);
        this.newAnnotationView.setWidth(180);
        this.newAnnotationView.setX(60);
        this.newAnnotationView.setY(40);
        this.newAnnotationView.setParent(this.newPatternView);
        this.diagramResource.getContents().add((Object)this.newPatternView);
    }

    public void undo() {
        this.catalog.getPatternSpecifications().remove((Object)this.newPattern);
        this.diagramResource.getContents().remove((Object)this.newPatternView);
    }
}

