/*
 * Decompiled with CFR 0.152.
 */
package org.reclipse.structure.specification.ui.edit.commands;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.gef.DefaultEditDomain;
import org.eclipse.ui.IEditorPart;
import org.fujaba.commons.edit.parts.AbstractDiagramEditPart;
import org.fujaba.commons.notation.Node;
import org.reclipse.structure.inference.annotations.AnnotationsPackage;
import org.reclipse.structure.specification.PSAnnotation;
import org.reclipse.structure.specification.PSLink;
import org.reclipse.structure.specification.PSNode;
import org.reclipse.structure.specification.PSObject;
import org.reclipse.structure.specification.SpecificationFactory;
import org.reclipse.structure.specification.ui.edit.commands.AbstractCreatePSConnectionCommand;
import org.reclipse.structure.specification.util.ModelHelper;

public class CreatePSLinkCommand
extends AbstractCreatePSConnectionCommand {
    private ResourceSet resourceSet;

    public CreatePSLinkCommand(Node source, AbstractDiagramEditPart host) {
        super("create link", source);
        IEditorPart editor = ((DefaultEditDomain)host.getViewer().getEditDomain()).getEditorPart();
        Object provider = editor.getAdapter(IEditingDomainProvider.class);
        if (provider != null && provider instanceof IEditingDomainProvider) {
            this.resourceSet = ((IEditingDomainProvider)provider).getEditingDomain().getResourceSet();
        }
    }

    protected PSLink getModel() {
        if (this.modelElement == null) {
            PSLink link = SpecificationFactory.eINSTANCE.createPSLink();
            link.setName("link" + (this.getNumberOfPaths(false) + 1));
            link.setWeight(1.0);
            link.setQualifier(this.getNextQualifier());
            if (this.modelSource instanceof PSAnnotation && ModelHelper.isCreate((PSAnnotation)((PSAnnotation)this.modelSource))) {
                link.setName("annotatedElement");
            }
            this.modelElement = link;
        }
        return (PSLink)this.modelElement;
    }

    private String getNextQualifier() {
        EObject source = this.getSource().getModel();
        if (source instanceof PSAnnotation && ModelHelper.isCreate((PSAnnotation)((PSAnnotation)source))) {
            StringBuilder qualifier = new StringBuilder();
            qualifier.append("element");
            int count = ((PSNode)source).getOutgoing().size() + 1;
            qualifier.append(count);
            return qualifier.toString();
        }
        return null;
    }

    @Override
    protected void redoModel() {
        PSAnnotation anno;
        super.redoModel();
        EReference inst = ModelHelper.getFirstReference((PSNode)this.getModel().getSource(), (PSNode)this.getModel().getTarget());
        if (inst != null) {
            this.getModel().setInstanceOf(inst);
        }
        if (this.getModel().getSource() instanceof PSAnnotation) {
            this.getModel().setInstanceOf(AnnotationsPackage.eINSTANCE.getASGAnnotation_AnnotatedElements());
        }
        if (this.getModel().getSource() instanceof PSAnnotation && this.getModel().getTarget() instanceof PSObject && !ModelHelper.isCreate((PSAnnotation)(anno = (PSAnnotation)this.getModel().getSource()))) {
            this.getModel().setQualifier(ModelHelper.getFirstQualifier((PSAnnotation)anno, (PSObject)((PSObject)this.getModel().getTarget())));
        }
    }

    public ResourceSet getResourceSet() {
        return this.resourceSet;
    }
}

