/*
 * Decompiled with CFR 0.152.
 */
package org.reclipse.structure.specification.ui.edit.commands;

import org.fujaba.commons.edit.commands.AbstractCreateEdgeCommand;
import org.fujaba.commons.notation.Node;
import org.reclipse.structure.specification.PSConnection;
import org.reclipse.structure.specification.PSLink;
import org.reclipse.structure.specification.PSNode;
import org.reclipse.structure.specification.PSPath;
import org.reclipse.structure.specification.PSPatternSpecification;

public abstract class AbstractCreatePSConnectionCommand
extends AbstractCreateEdgeCommand {
    protected PSPatternSpecification modelParent;
    protected PSNode modelSource;
    protected PSNode modelTarget;

    public AbstractCreatePSConnectionCommand(String label, Node source) {
        super(label, AbstractCreatePSConnectionCommand.getSubParent(source));
        this.setSource(source);
        this.modelSource = (PSNode)source.getModel();
        this.modelParent = this.modelSource.getPatternSpecification();
    }

    private static Node getSubParent(Node source) {
        Node result = source;
        while (!(result.getParent().getModel() instanceof PSPatternSpecification)) {
            result = result.getParent();
        }
        return result;
    }

    protected void redoModel() {
        this.modelParent.getConnections().add((Object)this.getModel());
        this.modelSource.getOutgoing().add((Object)this.getModel());
        this.modelTarget.getIncoming().add((Object)this.getModel());
    }

    protected void undoModel() {
        this.modelParent.getConnections().remove((Object)this.getModel());
        this.modelSource.getOutgoing().remove((Object)this.getModel());
        this.modelTarget.getIncoming().remove((Object)this.getModel());
    }

    protected int getNumberOfPaths(boolean path) {
        int count = 0;
        for (PSConnection connection : this.modelParent.getConnections()) {
            if (path && connection instanceof PSPath) {
                ++count;
                continue;
            }
            if (path || !(connection instanceof PSLink)) continue;
            ++count;
        }
        return count;
    }

    protected abstract PSConnection getModel();

    public void setSource(Node source) {
        super.setSource(source);
        this.modelSource = (PSNode)source.getModel();
    }

    public void setTarget(Node target) {
        super.setTarget(target);
        this.modelTarget = (PSNode)target.getModel();
    }
}

