/*
 * Decompiled with CFR 0.152.
 */
package org.reclipse.structure.specification.ui;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.commands.operations.OperationHistoryFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.emf.common.archive.ArchiveURLConnection;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.workspace.AbstractEMFOperation;
import org.eclipse.emf.workspace.WorkspaceEditingDomainFactory;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;
import org.fujaba.commons.notation.HierarchicalNode;
import org.fujaba.commons.notation.NotationFactory;
import org.reclipse.structure.specification.PSCatalog;
import org.reclipse.structure.specification.PSPatternSpecification;
import org.reclipse.structure.specification.ui.PSPlugin;

public class PSCatalogUtil {
    public static IEditorPart openDiagram(Resource diagram) throws PartInitException {
        String path = diagram.getURI().toPlatformString(true);
        IResource workspaceResource = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)new Path(path));
        if (workspaceResource instanceof IFile) {
            IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            return page.openEditor((IEditorInput)new FileEditorInput((IFile)workspaceResource), "org.reclipse.structure.specification.ui.PSCatalogEditor");
        }
        return null;
    }

    public static Resource createDiagram(URI diagramURI, URI modelURI, final PSCatalog catalog, final String encoding, IProgressMonitor mon) {
        TransactionalEditingDomain editingDomain = WorkspaceEditingDomainFactory.INSTANCE.createEditingDomain();
        ResourceSet resources = editingDomain.getResourceSet();
        mon.beginTask("Create Diagram Progress Task", 3);
        final Resource diagramResource = resources.createResource(diagramURI);
        final Resource modelResource = resources.createResource(modelURI);
        AbstractEMFOperation command = new AbstractEMFOperation(editingDomain, "Create Diagram Command Label"){

            protected IStatus doExecute(IProgressMonitor arg0, IAdaptable arg1) throws ExecutionException {
                modelResource.getContents().add((Object)catalog);
                if (catalog.getPatternSpecifications().size() == 1) {
                    PSPatternSpecification patternModel = (PSPatternSpecification)catalog.getPatternSpecifications().get(0);
                    HierarchicalNode patternView = NotationFactory.eINSTANCE.createHierarchicalNode();
                    patternView.setModel((EObject)patternModel);
                    if (patternModel.getNodes().size() == 1) {
                        HierarchicalNode annoView = NotationFactory.eINSTANCE.createHierarchicalNode();
                        annoView.setModel((EObject)patternModel.getNodes().get(0));
                        annoView.setPersistent(true);
                        annoView.setVisible(true);
                        annoView.setHeight(80);
                        annoView.setWidth(180);
                        annoView.setX(60);
                        annoView.setY(40);
                        patternView.getNodes().add((Object)annoView);
                    }
                    diagramResource.getContents().add((Object)patternView);
                }
                try {
                    modelResource.save(PSCatalogUtil.getSaveOptions(encoding));
                    diagramResource.save(PSCatalogUtil.getSaveOptions(encoding));
                }
                catch (IOException e) {
                    PSPlugin.getDefault().logError("Unable to store model and diagram resources", e);
                }
                return Status.OK_STATUS;
            }
        };
        try {
            OperationHistoryFactory.getOperationHistory().execute((IUndoableOperation)command, (IProgressMonitor)new SubProgressMonitor(mon, 1), null);
        }
        catch (ExecutionException e) {
            PSPlugin.getDefault().logError("Unable to create model and diagram", e);
        }
        PSCatalogUtil.setCharset(PSCatalogUtil.getFile(modelResource));
        PSCatalogUtil.setCharset(PSCatalogUtil.getFile(diagramResource));
        return diagramResource;
    }

    public static Map<String, String> getSaveOptions() {
        return PSCatalogUtil.getSaveOptions("UTF-8");
    }

    public static Map<String, String> getSaveOptions(String encoding) {
        HashMap<String, String> saveOptions = new HashMap<String, String>();
        saveOptions.put("ENCODING", encoding == null ? "UTF-8" : encoding);
        saveOptions.put("SAVE_ONLY_IF_CHANGED", "MEMORY_BUFFER");
        return saveOptions;
    }

    public static void setCharset(IFile file) {
        if (file == null) {
            return;
        }
        try {
            file.setCharset("UTF-8", (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            PSPlugin.getDefault().logError("Unable to set charset for file " + file.getFullPath(), e);
        }
    }

    public static IFile getFile(Resource resource) {
        if (resource == null) {
            return null;
        }
        ResourceSet rset = resource.getResourceSet();
        return PSCatalogUtil.getFile(resource.getURI(), rset != null ? rset.getURIConverter() : null, false);
    }

    private static IFile getFile(URI uri, URIConverter converter, boolean considerArchives) {
        URI normalized;
        IFile result = null;
        if (considerArchives && uri.isArchive()) {
            class MyArchiveURLConnection
            extends ArchiveURLConnection {
                public MyArchiveURLConnection(String url) {
                    super(url);
                }

                public String getNestedURI() {
                    try {
                        return this.getNestedURL();
                    }
                    catch (IOException exception) {
                        return "";
                    }
                }
            }
            MyArchiveURLConnection archiveURLConnection = new MyArchiveURLConnection(uri.toString());
            result = PSCatalogUtil.getFile(URI.createURI((String)archiveURLConnection.getNestedURI()), converter, considerArchives);
        } else if (uri.isPlatformResource()) {
            Path path = new Path(uri.toPlatformString(true));
            result = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)path);
        } else if (uri.isFile() && !uri.isRelative()) {
            result = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)new Path(uri.toFileString()));
        } else if (converter != null && !uri.equals(normalized = converter.normalize(uri))) {
            result = PSCatalogUtil.getFile(normalized, converter, considerArchives);
        }
        if (result == null && !uri.isRelative()) {
            try {
                IFile[] files = ResourcesPlugin.getWorkspace().getRoot().findFilesForLocationURI(new java.net.URI(uri.toString()));
                if (files.length > 0) {
                    result = files[0];
                }
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        return result;
    }

    protected static void configure(TransactionalEditingDomain domain) {
        final ResourceSet rset = domain.getResourceSet();
        Resource.Factory.Registry existingRegistry = rset.getResourceFactoryRegistry();
        rset.setResourceFactoryRegistry(new Resource.Factory.Registry(existingRegistry){
            private Resource.Factory.Registry delegateRegistry;
            {
                this.delegateRegistry = registry;
            }

            public Map<String, Object> getContentTypeToFactoryMap() {
                return this.delegateRegistry.getContentTypeToFactoryMap();
            }

            public Map<String, Object> getExtensionToFactoryMap() {
                return this.delegateRegistry.getExtensionToFactoryMap();
            }

            public Resource.Factory getFactory(URI uri, String contentType) {
                if (uri != null && uri.scheme() != null) {
                    uri = rset.getURIConverter().normalize(uri);
                }
                return this.delegateRegistry.getFactory(uri, contentType);
            }

            public Resource.Factory getFactory(URI uri) {
                if (uri != null && uri.scheme() != null) {
                    uri = rset.getURIConverter().normalize(uri);
                }
                return this.delegateRegistry.getFactory(uri);
            }

            public Map<String, Object> getProtocolToFactoryMap() {
                return this.delegateRegistry.getProtocolToFactoryMap();
            }
        });
    }
}

