/*
 * Decompiled with CFR 0.152.
 */
package org.reclipse.structure.specification.ui;

import java.io.IOException;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.command.CommandStackListener;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.provider.EcoreItemProviderAdapterFactory;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.edit.provider.resource.ResourceItemProviderAdapterFactory;
import org.eclipse.emf.edit.ui.util.EditUIUtil;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.views.properties.IPropertySourceProvider;
import org.eclipse.ui.views.properties.PropertySheetPage;
import org.fujaba.commons.FujabaCommonsPlugin;
import org.fujaba.commons.editor.AbstractSimpleEditorPart;
import org.fujaba.commons.editor.CommandStackDelegate;
import org.fujaba.commons.notation.HierarchicalNode;
import org.fujaba.commons.providers.ModelViewAdapterFactoryContentProvider;
import org.reclipse.metamodel.MetaModel;
import org.reclipse.structure.specification.PSPatternSpecification;
import org.reclipse.structure.specification.provider.SpecificationItemProviderAdapterFactory;
import org.reclipse.structure.specification.ui.PSImages;
import org.reclipse.structure.specification.ui.PSPlugin;
import org.reclipse.structure.specification.ui.edit.parts.PSEditPartFactory;
import org.reclipse.structure.specification.ui.utils.IFile2EditingDomainMapping;
import org.reclipse.structure.specification.util.ModelHelper;

public class PSCatalogEditor
extends AbstractSimpleEditorPart
implements IEditingDomainProvider {
    public static final String ID = "org.reclipse.structure.specification.ui.PSCatalogEditor";
    private ComposedAdapterFactory adapterFactory;
    private EditingDomain editingDomain;

    public PSCatalogEditor() {
        this.initializeEditingDomain();
    }

    protected void performSaveAs(IFile diagramFile) {
        ResourceSet resourceSet = this.editingDomain.getResourceSet();
        resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("*", new XMIResourceFactoryImpl());
        Resource diagramResource = this.getDiagram().eResource();
        Resource modelResource = this.getDiagramModel().eResource();
        if (!diagramResource.getContents().contains((Object)this.getDiagram())) {
            diagramResource.getContents().add((Object)this.getDiagram());
        }
        try {
            modelResource.save(Collections.EMPTY_MAP);
            diagramResource.save(Collections.EMPTY_MAP);
        }
        catch (IOException e) {
            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Save Error", (String)("During saving of the latest changes an exception occurred: " + e.getMessage() + "\nsee Error Log for Stacktrace"));
            FujabaCommonsPlugin.getDefault().logError(e.getMessage(), (Throwable)e);
        }
    }

    protected void setInput(IEditorInput input) {
        this.setInputWithNotify(input);
        if (input instanceof IFileEditorInput) {
            IFileEditorInput fileInput = (IFileEditorInput)input;
            IFile2EditingDomainMapping.register(fileInput.getFile(), this.editingDomain);
        }
        this.setPartName(input.getName());
        this.loadModel();
    }

    public void loadModel() {
        URI resourceURI = EditUIUtil.getURI((IEditorInput)this.getEditorInput());
        Exception exception = null;
        Resource resource = null;
        try {
            resource = this.editingDomain.getResourceSet().getResource(resourceURI, true);
        }
        catch (Exception e) {
            exception = e;
            PSPlugin.getDefault().logError("load on demand failed", exception);
            resource = this.editingDomain.getResourceSet().getResource(resourceURI, false);
        }
        EObject obj = (EObject)resource.getContents().get(0);
        if (obj instanceof HierarchicalNode) {
            this.setDiagram((HierarchicalNode)obj);
            this.checkMetaModel();
        } else {
            MessageDialog.openError((Shell)this.getSite().getShell(), (String)"Error", (String)("Problems occured during loading of resource " + resourceURI.path()));
        }
    }

    private void checkMetaModel() {
        MetaModel mm = ModelHelper.getMetaModel((PSPatternSpecification)this.getDiagramModel());
        if (mm == null) {
            MessageDialog.openError((Shell)this.getSite().getShell(), (String)"Error", (String)"No abstract syntax graph meta model resource specified. \nYou might not be able to specify a type to your objecs.");
        } else {
            ModelHelper.getTypes((MetaModel)mm);
        }
    }

    protected void createEditPartFactory() {
        this.editPartFactory = new PSEditPartFactory();
    }

    protected Image createEditorImage() {
        return PSImages.getImage("icons/full/obj16/PSPatternSpecification.gif");
    }

    public Object getAdapter(Class adapter) {
        if (adapter.equals(IEditingDomainProvider.class)) {
            return this;
        }
        return super.getAdapter(adapter);
    }

    protected void initializeEditingDomain() {
        this.adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
        this.adapterFactory.addAdapterFactory((AdapterFactory)new ResourceItemProviderAdapterFactory());
        this.adapterFactory.addAdapterFactory((AdapterFactory)new SpecificationItemProviderAdapterFactory());
        this.adapterFactory.addAdapterFactory((AdapterFactory)new EcoreItemProviderAdapterFactory());
        this.adapterFactory.addAdapterFactory((AdapterFactory)new ReflectiveItemProviderAdapterFactory());
        CommandStackDelegate commandStack = new CommandStackDelegate(this.getCommandStack());
        commandStack.addCommandStackListener(new CommandStackListener(){

            public void commandStackChanged(EventObject event) {
                PSCatalogEditor.this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        PSCatalogEditor.this.firePropertyChange(257);
                        if (PSCatalogEditor.this.propertySheetPage != null && !PSCatalogEditor.this.propertySheetPage.getControl().isDisposed()) {
                            PSCatalogEditor.this.propertySheetPage.refresh();
                        }
                    }
                });
            }
        });
        this.editingDomain = new AdapterFactoryEditingDomain((AdapterFactory)this.adapterFactory, (CommandStack)commandStack, new HashMap());
    }

    protected PropertySheetPage getPropertySheetPage() {
        if (this.propertySheetPage == null) {
            this.propertySheetPage = new PropertySheetPage();
            this.propertySheetPage.setPropertySourceProvider((IPropertySourceProvider)new ModelViewAdapterFactoryContentProvider((AdapterFactory)this.adapterFactory));
        }
        return this.propertySheetPage;
    }

    public EditingDomain getEditingDomain() {
        return this.editingDomain;
    }

    public PSPatternSpecification getDiagramModel() {
        return (PSPatternSpecification)super.getDiagramModel();
    }
}

