/*
 * Decompiled with CFR 0.152.
 */
package org.reclipse.structure.inference.util;

import java.io.InvalidClassException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.reclipse.structure.inference.IAnnotationEvaluator;

public final class InferenceExtensionsHelper {
    private static final String EPID_EVALUATORS = "org.reclipse.structure.inference.evaluator";
    private static final String ID = "id";
    private static final String NAME = "name";
    private static final String DESC = "description";
    private static final String CLASS = "class";
    private static List<AnnotationEvaluatorItem> evaluators;

    private InferenceExtensionsHelper() {
    }

    public static List<AnnotationEvaluatorItem> getRegisteredEvaluators() {
        if (evaluators == null) {
            evaluators = new LinkedList<AnnotationEvaluatorItem>();
            IConfigurationElement[] iConfigurationElementArray = Platform.getExtensionRegistry().getConfigurationElementsFor(EPID_EVALUATORS);
            int n = iConfigurationElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement ce = iConfigurationElementArray[n2];
                try {
                    Object strategy;
                    String id = ce.getAttribute(ID);
                    String name = ce.getAttribute(NAME);
                    String desc = null;
                    IConfigurationElement[] descContainer = ce.getChildren(DESC);
                    if (descContainer.length == 1) {
                        desc = descContainer[0].getValue();
                    }
                    if (!((strategy = ce.createExecutableExtension(CLASS)) instanceof IAnnotationEvaluator)) {
                        throw new InvalidClassException("The class has to implement IAnnotationEvaluator.");
                    }
                    AnnotationEvaluatorItem item = new AnnotationEvaluatorItem(id, name, desc, (IAnnotationEvaluator)strategy);
                    if (evaluators.contains(item)) {
                        System.out.println("Two annotation evaluators with the same ID wanted to be registered: duplicate ignored.");
                    } else {
                        evaluators.add(item);
                    }
                }
                catch (Exception e) {
                    System.out.println("Error on reading the registered annotation evaluator.");
                }
                ++n2;
            }
            if (evaluators.isEmpty()) {
                System.out.println("No annotation evaluator registered.");
            } else {
                Collections.sort(evaluators);
            }
        }
        return evaluators;
    }

    public static class AnnotationEvaluatorItem
    implements Comparable<AnnotationEvaluatorItem> {
        private final String id;
        private final String name;
        private final String description;
        private final IAnnotationEvaluator evaluator;

        public AnnotationEvaluatorItem(String id, String name, String description, IAnnotationEvaluator evaluator) {
            this.id = id;
            this.name = name;
            this.description = description == null || description.length() < 1 ? "No description available." : description;
            this.evaluator = evaluator;
        }

        public String getID() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }

        public IAnnotationEvaluator getEvaluator() {
            return this.evaluator;
        }

        @Override
        public int compareTo(AnnotationEvaluatorItem o) {
            return this.getName().compareTo(o.getName());
        }

        public boolean equals(Object o) {
            if (o instanceof AnnotationEvaluatorItem) {
                return this.getID().equals(((AnnotationEvaluatorItem)o).getID());
            }
            return super.equals(o);
        }
    }
}

