/*
 * Decompiled with CFR 0.152.
 */
package org.reclipse.structure.inference.strategy;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.fujaba.commons.console.ReportLevel;
import org.reclipse.structure.inference.InferenceEngine;
import org.reclipse.structure.inference.InferenceStrategy;
import org.reclipse.structure.inference.annotations.ASGAnnotation;
import org.reclipse.structure.inference.notification.InferenceProgressProvider;
import org.reclipse.structure.inference.strategy.BottomUpQueue;
import org.reclipse.structure.inference.strategy.ContextPatternPair;
import org.reclipse.structure.specification.PSAnnotation;
import org.reclipse.structure.specification.PSCatalog;
import org.reclipse.structure.specification.PSNode;
import org.reclipse.structure.specification.PSObject;
import org.reclipse.structure.specification.PSPatternSpecification;
import org.reclipse.structure.specification.util.SpecificationUtil;
import org.reclipse.structure.specification.util.TriggerManager;

public class BottomUpStrategy
extends InferenceStrategy {
    private BottomUpQueue queue;
    private TriggerManager triggerManager;

    public BottomUpStrategy(InferenceEngine engine, PSCatalog catalog) {
        super(engine, catalog);
        this.triggerManager = new TriggerManager((Collection)catalog.getPatternSpecifications());
        this.queue = new BottomUpQueue(this, true);
    }

    @Override
    protected void processInference(IProgressMonitor monitor) {
        InferenceProgressProvider progress = this.getEngine().getInferenceProgressProvider();
        this.task("Creating context queue", new Object[0]);
        this.fillAxiomPairsIntoQueue();
        if (!this.queue.isEmpty()) {
            monitor.subTask("Analyzing Host Graph...");
            this.task("Starting to detect patterns", new Object[0]);
            progress.incrementMaximum(this.queue.size());
        }
        PSPatternSpecification currentPattern = null;
        while (!(this.queue.isEmpty() || this.getEngine().isAborted() || monitor.isCanceled())) {
            if (!this.getEngine().isPaused()) {
                ContextPatternPair pair = this.queue.dequeue();
                if (!pair.getPattern().equals(currentPattern)) {
                    currentPattern = pair.getPattern();
                    monitor.subTask(String.format("Searching for Pattern '%1s'...", currentPattern.getName()));
                }
                this.reportAnnotate(pair);
                Collection<ASGAnnotation> annotated = this.getEngine().annotate(pair);
                progress.increment();
                if (annotated.isEmpty()) continue;
                for (ASGAnnotation annotation : annotated) {
                    for (PSPatternSpecification patternToTrigger : this.triggerManager.getPatternThatShouldBeTriggeredOnFoundAnnotation(currentPattern)) {
                        if (patternToTrigger.isAbstract()) continue;
                        PSNode triggerNode = this.triggerManager.getTrigger(patternToTrigger);
                        if (triggerNode instanceof PSAnnotation) {
                            if (!SpecificationUtil.getInstancePatterns((PSAnnotation)((PSAnnotation)triggerNode)).contains(currentPattern) || this.getFactory().contains((EObject)annotation, patternToTrigger)) continue;
                            ContextPatternPair nextPair = this.getFactory().create((EObject)annotation, patternToTrigger);
                            this.queue.enqueue(nextPair);
                            this.debug("Enqueued pattern '%1s' to be searched from '%2s'.", patternToTrigger.getName(), annotation);
                            continue;
                        }
                        if (!(triggerNode instanceof PSObject)) continue;
                        Set<EObject> elements = this.collectHostGraphElementsOfTriggerType((PSObject)triggerNode);
                        for (EObject context : elements) {
                            if (this.getFactory().contains(context, patternToTrigger)) continue;
                            ContextPatternPair nextPair = this.getFactory().create(context, patternToTrigger);
                            this.queue.enqueue(nextPair);
                            this.debug("Enqueued pattern '%1s' to be searched from '%2s'.", patternToTrigger.getName(), context);
                        }
                    }
                }
                progress.incrementMaximum(this.queue.size());
                continue;
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private void fillAxiomPairsIntoQueue() {
        this.task("Collecting axiom elements", new Object[0]);
        for (PSPatternSpecification pattern : this.getCatalog().getPatternSpecifications()) {
            PSNode triggerNode;
            if (pattern.isAbstract() || !((triggerNode = this.triggerManager.getTrigger(pattern)) instanceof PSObject)) continue;
            Set<EObject> current = this.collectHostGraphElementsOfTriggerType((PSObject)triggerNode);
            for (EObject element : current) {
                if (this.getFactory().contains(element, pattern)) continue;
                ContextPatternPair pair = this.getFactory().create(element, pattern);
                this.queue.enqueue(pair);
            }
            this.debug("Collected %1s axiom elements for pattern '%2s'.", current.size(), pattern.getName());
        }
        this.info("Axiom elements collected.", ReportLevel.TASK);
    }

    private Set<EObject> collectHostGraphElementsOfTriggerType(PSObject trigger) {
        HashSet<EObject> result = new HashSet<EObject>();
        EClass triggerType = trigger.getInstanceOf();
        TreeIterator contents = EcoreUtil.getAllContents(this.getEngine().getHost());
        while (contents.hasNext()) {
            Notifier element = (Notifier)contents.next();
            if (!triggerType.isInstance((Object)element)) continue;
            result.add((EObject)element);
        }
        return result;
    }

    public int getRank(PSPatternSpecification pattern) {
        return this.triggerManager.getRank(pattern);
    }

    private void reportAnnotate(ContextPatternPair pair) {
        StringBuilder message = new StringBuilder();
        message.append("Searching for pattern '");
        message.append(pair.getPattern().getName());
        message.append("' from context '");
        message.append(pair.getContext());
        message.append("'.");
        this.debug(message.toString(), new Object[0]);
    }
}

