/*
 * Decompiled with CFR 0.152.
 */
package org.reclipse.structure.inference.notification;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.fujaba.commons.console.IProcessConsoleListener;
import org.fujaba.commons.console.ProcessConsoleState;
import org.reclipse.metamodel.AbstractElementLabeler;
import org.reclipse.structure.inference.InferenceEngine;
import org.reclipse.structure.inference.annotations.ASGAnnotation;
import org.reclipse.structure.inference.notification.InferenceProgressListener;
import org.reclipse.structure.specification.PSPatternSpecification;
import org.reclipse.structure.specification.util.ModelHelper;

public class InferenceProgressProvider
implements InferenceProgressListener {
    private static final Map<InferenceEngine, InferenceProgressProvider> INSTANCES = new WeakHashMap<InferenceEngine, InferenceProgressProvider>();
    private InferenceEngine engine;
    private final Set<InferenceProgressListener> listeners;
    private AbstractElementLabeler labeler;
    private int progress;
    private int maximum;

    public static InferenceProgressProvider get(InferenceEngine engine) {
        if (engine == null) {
            throw new IllegalArgumentException("InferenceEngine must not be null.");
        }
        InferenceProgressProvider provider = INSTANCES.get(engine);
        if (provider == null) {
            provider = new InferenceProgressProvider(engine);
            INSTANCES.put(engine, provider);
        }
        return provider;
    }

    private InferenceProgressProvider(InferenceEngine engine) {
        this.engine = engine;
        this.listeners = new HashSet<InferenceProgressListener>();
        this.progress = 0;
        this.maximum = 1;
        this.addListener(this);
    }

    public boolean addListener(InferenceProgressListener listener) {
        return this.engine.getConsole().addListener((IProcessConsoleListener)listener) && this.listeners.add(listener);
    }

    public void fireInit() {
        for (InferenceProgressListener listener : this.listeners) {
            listener.init();
        }
    }

    public void fireNewAnnotation(ASGAnnotation annotation) {
        for (InferenceProgressListener listener : this.listeners) {
            listener.newAnnotation(annotation);
        }
    }

    private void fireNewProgressValues() {
        for (InferenceProgressListener listener : this.listeners) {
            listener.newValues(this.progress, this.maximum);
        }
    }

    public void increment() {
        ++this.progress;
        this.fireNewProgressValues();
    }

    public void incrementMaximum(int rest) {
        this.maximum = this.progress + rest;
        this.fireNewProgressValues();
    }

    public boolean removeListener(InferenceProgressListener listener) {
        return this.engine.getConsole().removeListener((IProcessConsoleListener)listener) && this.listeners.remove(listener);
    }

    public void newState(ProcessConsoleState state) {
    }

    @Override
    public void init() {
        this.progress = 0;
        this.maximum = 1;
    }

    @Override
    public void newValues(int current, int maximum) {
    }

    @Override
    public void newAnnotation(ASGAnnotation annotation) {
        if (this.labeler == null) {
            this.labeler = ModelHelper.getMetaModel((PSPatternSpecification)annotation.getPattern()).getLabeler();
        }
        this.engine.info("Found pattern '%1s'.", annotation.getPattern().getName());
    }
}

