/*
 * Decompiled with CFR 0.152.
 */
package org.reclipse.structure.inference.evaluation;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.reclipse.math.functions.MathematicalFunction;
import org.reclipse.metrics.extensionpoints.MetricUtil;
import org.reclipse.structure.inference.IAnnotationEvaluator;
import org.reclipse.structure.inference.annotations.ASGAnnotation;
import org.reclipse.structure.inference.annotations.SatisfiedAttributeConstraint;
import org.reclipse.structure.inference.annotations.SatisfiedConstraint;
import org.reclipse.structure.specification.ModifierType;
import org.reclipse.structure.specification.OperatorType;
import org.reclipse.structure.specification.PSAnnotation;
import org.reclipse.structure.specification.PSAttributeConstraint;
import org.reclipse.structure.specification.PSBooleanConstraint;
import org.reclipse.structure.specification.PSCombinedFragment;
import org.reclipse.structure.specification.PSCombinedFragmentItem;
import org.reclipse.structure.specification.PSFuzzyConstraint;
import org.reclipse.structure.specification.PSFuzzyMetricConstraint;
import org.reclipse.structure.specification.PSFuzzySetRatingConstraint;
import org.reclipse.structure.specification.PSMetricConstraint;
import org.reclipse.structure.specification.PSNode;
import org.reclipse.structure.specification.PSNodeConstraint;
import org.reclipse.structure.specification.PSObject;
import org.reclipse.structure.specification.PSPatternSpecification;
import org.reclipse.structure.specification.PSSpecificationConstraint;
import org.reclipse.structure.specification.ui.utils.MathFunctionHelper;
import org.reclipse.structure.specification.util.ModelHelper;

public class SimilarityEvaluator
implements IAnnotationEvaluator {
    @Override
    public double evaluate(ASGAnnotation asg) {
        return this.evaluate(asg, asg.getPattern()) * 100.0;
    }

    private double evaluate(ASGAnnotation asg, PSPatternSpecification pattern) {
        return this.rank(pattern, asg) / this.weight(pattern);
    }

    public double rank(PSPatternSpecification pattern, ASGAnnotation asg) {
        double rank = 0.0;
        for (PSCombinedFragment frag : pattern.getCombinedFragments()) {
            if (!ModifierType.ADDITIONAL.equals((Object)frag.getKind())) continue;
            rank += this.rank(frag, asg);
        }
        for (PSNode node : pattern.getNodes()) {
            if (node.equals(ModelHelper.getCreateAnnotation((PSPatternSpecification)pattern)) || ModelHelper.isContainedInAdditionalFragment((PSCombinedFragmentItem)node)) continue;
            if (node instanceof PSAnnotation) {
                rank += this.rank((PSAnnotation)node, asg);
                continue;
            }
            if (node instanceof PSObject) {
                rank += this.rank((PSObject)node, asg);
                continue;
            }
            if (!(node instanceof PSSpecificationConstraint)) continue;
            rank += this.rank((PSSpecificationConstraint)node, asg);
        }
        return rank;
    }

    public double rank(PSCombinedFragment fragment, ASGAnnotation asg) {
        double rank = 0.0;
        for (PSCombinedFragmentItem child : fragment.getChildren()) {
            if (child instanceof PSAnnotation) {
                rank += this.rank((PSAnnotation)child, asg);
                continue;
            }
            if (child instanceof PSObject) {
                rank += this.rank((PSObject)child, asg);
                continue;
            }
            if (!(child instanceof PSSpecificationConstraint)) continue;
            rank += this.rank((PSSpecificationConstraint)child, asg);
        }
        return rank * fragment.getWeight();
    }

    public double rank(PSAnnotation annotation, ASGAnnotation asg) {
        if (ModifierType.NEGATIVE.equals((Object)annotation.getModifier())) {
            return annotation.getWeight();
        }
        List boundObjects = (List)asg.getBoundObjects().get((Object)annotation.getName());
        if (boundObjects == null || boundObjects.isEmpty()) {
            return 0.0;
        }
        double rank = annotation.getWeight();
        if (ModifierType.SET.equals((Object)annotation.getModifier())) {
            double annotationWeight = annotation.getWeight();
            double boundObjectsRank = 0.0;
            for (EObject bound : boundObjects) {
                PSPatternSpecification pattern = ((ASGAnnotation)bound).getPattern();
                boundObjectsRank += this.evaluate((ASGAnnotation)bound, pattern);
            }
            rank = SimilarityEvaluator.scale(boundObjectsRank, (PSNode)annotation) * annotationWeight;
            for (PSNodeConstraint constraint : annotation.getNodeConstraints()) {
                if (constraint instanceof PSMetricConstraint) {
                    rank += this.rank((PSMetricConstraint)constraint, asg);
                    continue;
                }
                if (!(constraint instanceof PSFuzzyMetricConstraint)) continue;
                rank += this.rank((PSFuzzyMetricConstraint)constraint, asg);
            }
        } else {
            ASGAnnotation bounded = (ASGAnnotation)boundObjects.get(0);
            PSPatternSpecification pattern = bounded.getPattern();
            rank *= this.evaluate(bounded, pattern);
        }
        return rank;
    }

    public double rank(PSObject object, ASGAnnotation asg) {
        if (ModifierType.NEGATIVE.equals((Object)object.getModifier())) {
            return object.getWeight();
        }
        List boundObjects = (List)asg.getBoundObjects().get((Object)object.getName());
        if (boundObjects == null || boundObjects.isEmpty()) {
            return 0.0;
        }
        double rank = 0.0;
        if (ModifierType.SET.equals((Object)object.getModifier())) {
            double weightOfOneObject = object.getWeight();
            for (PSNodeConstraint constraint : object.getNodeConstraints()) {
                if (!(constraint instanceof PSBooleanConstraint)) continue;
                weightOfOneObject += this.weight(constraint);
            }
            double allObjectsTmpRank = 0.0;
            for (EObject boundObject : boundObjects) {
                allObjectsTmpRank += object.getWeight();
                for (PSNodeConstraint constraint : object.getNodeConstraints()) {
                    if (constraint instanceof PSAttributeConstraint) {
                        allObjectsTmpRank += this.rank((PSAttributeConstraint)constraint, boundObject, asg);
                        continue;
                    }
                    if (constraint instanceof PSMetricConstraint) {
                        allObjectsTmpRank += this.rank((PSMetricConstraint)constraint, boundObject);
                        continue;
                    }
                    if (constraint instanceof PSFuzzyMetricConstraint) {
                        allObjectsTmpRank += this.rank((PSFuzzyMetricConstraint)constraint, boundObject);
                        continue;
                    }
                    if (!(constraint instanceof PSFuzzySetRatingConstraint)) continue;
                    throw new UnsupportedOperationException("The rating of fuzzy set rating constraints is not yet supported.");
                }
            }
            if (weightOfOneObject > 0.0) {
                rank = SimilarityEvaluator.scale(allObjectsTmpRank / weightOfOneObject, (PSNode)object) * weightOfOneObject;
            }
            for (PSNodeConstraint constraint : object.getNodeConstraints()) {
                if (constraint instanceof PSMetricConstraint && "SIZE".equals(((PSMetricConstraint)constraint).getMetricAcronym())) {
                    rank += this.rank((PSMetricConstraint)constraint, asg);
                    continue;
                }
                if (!(constraint instanceof PSFuzzyMetricConstraint) || !"SIZE".equals(((PSFuzzyMetricConstraint)constraint).getMetricAcronym())) continue;
                rank += this.rank((PSFuzzyMetricConstraint)constraint, asg);
            }
        } else {
            rank = object.getWeight();
            EObject boundObject = (EObject)boundObjects.get(0);
            for (PSNodeConstraint constraint : object.getNodeConstraints()) {
                if (constraint instanceof PSAttributeConstraint) {
                    rank += this.rank((PSAttributeConstraint)constraint, boundObject, asg);
                    continue;
                }
                if (constraint instanceof PSMetricConstraint) {
                    rank += this.rank((PSMetricConstraint)constraint, boundObject);
                    continue;
                }
                if (!(constraint instanceof PSFuzzyMetricConstraint)) continue;
                rank += this.rank((PSFuzzyMetricConstraint)constraint, boundObject);
            }
        }
        return rank;
    }

    public double rank(PSSpecificationConstraint constraint, ASGAnnotation asg) {
        if (constraint.isAdditional()) {
            return 0.0;
        }
        if (!constraint.isAdditional() || asg.getSatisfiedConstraints().contains((Object)constraint.getName())) {
            return constraint.getWeight();
        }
        return 0.0;
    }

    public double rank(PSAttributeConstraint constraint, EObject bounded, ASGAnnotation asg) {
        if (!constraint.isAdditional()) {
            return constraint.getWeight();
        }
        int index = -1;
        int currentIndex = 0;
        Iterator constraintIter = constraint.getNode().getNodeConstraints().iterator();
        while (index == -1 && constraintIter.hasNext()) {
            PSNodeConstraint other = (PSNodeConstraint)constraintIter.next();
            if (other.equals(constraint)) {
                index = currentIndex;
            }
            ++currentIndex;
        }
        if (SimilarityEvaluator.hasInSatisfiedConstraints(asg, bounded, constraint.getNode().getName(), index)) {
            return constraint.getWeight();
        }
        return 0.0;
    }

    public double rank(PSMetricConstraint constraint, EObject boundObject) {
        double actual = MetricUtil.getMetricValue((EObject)boundObject, (String)constraint.getMetricAcronym());
        double expected = Double.parseDouble(constraint.getValueExpression());
        OperatorType operator = constraint.getOperator();
        if (!constraint.isAdditional() || SimilarityEvaluator.checkExpression(actual, operator, expected)) {
            return constraint.getWeight();
        }
        return 0.0;
    }

    public double rank(PSMetricConstraint constraint, ASGAnnotation asg) {
        if (!constraint.getMetricAcronym().equals("SIZE")) {
            return 0.0;
        }
        if (!constraint.isAdditional()) {
            return constraint.getWeight();
        }
        int desiredSize = Integer.valueOf(constraint.getValueExpression());
        OperatorType operator = constraint.getOperator();
        int realSize = SimilarityEvaluator.getObjectCount((PSNodeConstraint)constraint, asg);
        if (SimilarityEvaluator.checkExpression(realSize, operator, desiredSize)) {
            return constraint.getWeight();
        }
        return 0.0;
    }

    public double rank(PSFuzzyMetricConstraint constraint, EObject boundObject) {
        String acronym = constraint.getMetricAcronym();
        double metricValue = MetricUtil.getMetricValue((EObject)boundObject, (String)acronym);
        double result = SimilarityEvaluator.getMembershipValue(constraint, metricValue);
        return result *= constraint.getWeight();
    }

    public double rank(PSFuzzyMetricConstraint constraint, ASGAnnotation asg) {
        if (!constraint.getMetricAcronym().equals("SIZE")) {
            return 0.0;
        }
        int setSize = SimilarityEvaluator.getObjectCount((PSNodeConstraint)constraint, asg);
        return SimilarityEvaluator.getMembershipValue(constraint, setSize);
    }

    public double weightPattern(PSPatternSpecification pattern) {
        double weight = 0.0;
        PSAnnotation specifiedPatternAnno = ModelHelper.getCreateAnnotation((PSPatternSpecification)pattern);
        for (PSCombinedFragment fragment : pattern.getCombinedFragments()) {
            if (!ModifierType.ADDITIONAL.equals((Object)fragment.getKind())) continue;
            weight += this.weight(fragment);
        }
        for (PSNode node : pattern.getNodes()) {
            if (node.equals(specifiedPatternAnno) || ModelHelper.isContainedInAdditionalFragment((PSCombinedFragmentItem)node)) continue;
            if (node instanceof PSAnnotation) {
                weight += this.weight((PSAnnotation)node);
                continue;
            }
            if (!(node instanceof PSObject)) continue;
            weight += this.weight((PSObject)node);
        }
        for (PSSpecificationConstraint constraint : pattern.getConstraints()) {
            weight += this.weight(constraint);
        }
        return weight;
    }

    public double weight(PSPatternSpecification pattern) {
        if (this.isRecursive(pattern)) {
            return Double.MAX_VALUE;
        }
        return this.weightPattern(pattern);
    }

    public double weight(PSCombinedFragment fragment) {
        double weight = 0.0;
        for (PSCombinedFragmentItem item : fragment.getChildren()) {
            if (item instanceof PSAnnotation) {
                weight += this.weight((PSAnnotation)item);
                continue;
            }
            if (item instanceof PSObject) {
                weight += this.weight((PSObject)item);
                continue;
            }
            if (!(item instanceof PSCombinedFragment) || !ModifierType.ADDITIONAL.equals((Object)((PSCombinedFragment)item).getKind())) continue;
            weight += this.weight((PSCombinedFragment)item);
        }
        if (fragment.getConstraint() != null) {
            weight += this.weight(fragment.getConstraint());
        }
        return weight * fragment.getWeight();
    }

    public double weight(PSAnnotation annotation) {
        switch (annotation.getModifier()) {
            default: {
                return annotation.getWeight();
            }
            case SET: 
        }
        double weight = annotation.getWeight();
        for (PSNodeConstraint constraint : annotation.getNodeConstraints()) {
            weight += this.weight(constraint);
        }
        return weight;
    }

    public double weight(PSObject object) {
        switch (object.getModifier()) {
            default: {
                double weight = object.getWeight();
                for (PSNodeConstraint constraint : object.getNodeConstraints()) {
                    weight += this.weight(constraint);
                }
                return weight;
            }
            case NEGATIVE: 
        }
        return object.getWeight();
    }

    public double weight(PSSpecificationConstraint constraint) {
        if (constraint.isAdditional()) {
            return 0.0;
        }
        return constraint.getWeight();
    }

    public double weight(PSNodeConstraint constraint) {
        return constraint.getWeight();
    }

    private boolean isRecursive(PSPatternSpecification specification) {
        ArrayList<PSPatternSpecification> list = new ArrayList<PSPatternSpecification>();
        list.add(specification);
        return this.findRecursion(specification, list);
    }

    private boolean findRecursion(PSPatternSpecification specification, ArrayList<PSPatternSpecification> list) {
        for (PSNode node : specification.getNodes()) {
            if (!(node instanceof PSAnnotation) || ModelHelper.isCreate((PSAnnotation)((PSAnnotation)node))) continue;
            PSAnnotation anno = (PSAnnotation)node;
            PSPatternSpecification newPattern = anno.getType();
            if (list.contains(newPattern)) {
                return true;
            }
            list.add(newPattern);
            if (this.findRecursion(newPattern, list)) {
                return true;
            }
            list.remove(newPattern);
        }
        return false;
    }

    private static int getObjectCount(PSNodeConstraint constraint, ASGAnnotation asg) {
        String name = constraint.getNode().getName();
        return ((EList)asg.getBoundObjects().get((Object)name)).size();
    }

    private static double getMembershipValue(PSFuzzyMetricConstraint constraint, double value) {
        MathematicalFunction function = MathFunctionHelper.getMathematicalFunction((PSFuzzyConstraint)constraint);
        double result = function.value(value);
        if (result > 1.0) {
            result = 1.0;
        } else if (result < 0.0) {
            result = 0.0;
        }
        return result;
    }

    private static double scale(double value, PSNode node) {
        PSFuzzySetRatingConstraint setRatingFunction = null;
        for (PSNodeConstraint constraint : node.getNodeConstraints()) {
            if (!(constraint instanceof PSFuzzySetRatingConstraint)) continue;
            setRatingFunction = (PSFuzzySetRatingConstraint)constraint;
            break;
        }
        if (setRatingFunction != null) {
            MathematicalFunction function = MathFunctionHelper.getMathematicalFunction(setRatingFunction);
            return function.value(value);
        }
        return 2.0 / (1.0 + Math.exp(-value / 5.0)) - 1.0;
    }

    private static boolean checkExpression(double number1, OperatorType operator, double number2) {
        if (OperatorType.EQUAL.equals((Object)operator)) {
            return number1 == number2;
        }
        if (OperatorType.LESS.equals((Object)operator)) {
            return number1 < number2;
        }
        if (OperatorType.LESS_OR_EQUAL.equals((Object)operator)) {
            return number1 <= number2;
        }
        if (OperatorType.GREATER.equals((Object)operator)) {
            return number1 > number2;
        }
        if (OperatorType.GREATER_OR_EQUAL.equals((Object)operator)) {
            return number1 >= number2;
        }
        if (OperatorType.UNEQUAL.equals((Object)operator)) {
            return number1 != number2;
        }
        throw new IllegalArgumentException("Unsupported operator found in an expression. Supported operators are =, <, >, <=, >=, and !=.");
    }

    private static boolean hasInSatisfiedConstraints(ASGAnnotation asg, EObject context, String nodeID, int attributeIndex) {
        for (SatisfiedConstraint constraint : asg.getSatisfiedConstraints()) {
            SatisfiedAttributeConstraint attrConstraint;
            if (!(constraint instanceof SatisfiedAttributeConstraint) || !(attrConstraint = (SatisfiedAttributeConstraint)constraint).getContext().equals(context) || !attrConstraint.getNodeID().equals(nodeID) || attrConstraint.getAttributeIndex() != attributeIndex) continue;
            return true;
        }
        return false;
    }
}

