/*
 * Decompiled with CFR 0.152.
 */
package org.reclipse.structure.inference;

import de.mdelab.sdm.interpreter.core.SDMException;
import de.mdelab.sdm.interpreter.core.notifications.NotificationEmitter;
import de.mdelab.sdm.interpreter.core.notifications.NotificationReceiver;
import de.mdelab.sdm.interpreter.core.notifications.OutputStreamNotificationReceiver;
import de.mdelab.sdm.interpreter.core.variables.Variable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.EcorePackage;
import org.fujaba.commons.console.IControllableReportListener;
import org.reclipse.structure.inference.InferenceEngine;
import org.reclipse.structure.inference.annotations.ASGAnnotation;
import org.reclipse.structure.inference.annotations.AnnotationSet;
import org.reclipse.structure.specification.PSPatternSpecification;
import org.storydriven.storydiagrams.activities.Activity;
import org.storydriven.storydiagrams.activities.OperationExtension;
import org.storydriven.storydiagrams.interpreter.eclipse.StoryDrivenEclipseInterpreter;

public class InterpreterInferenceEngine
extends InferenceEngine {
    private StoryDrivenEclipseInterpreter interpreter = null;

    public InterpreterInferenceEngine(IControllableReportListener reporter) {
        this(reporter, false);
    }

    public InterpreterInferenceEngine(IControllableReportListener reporter, boolean isDebug) {
        super(reporter, isDebug);
    }

    @Override
    protected Collection<ASGAnnotation> applyPatternSearch(PSPatternSpecification pattern, EObject context) {
        EObject engine = (EObject)this.engines.get(pattern);
        if (engine == null) {
            String message = "Exception occurred on search for '%1s': Could not find an engine class.";
            this.warn(String.format(message, pattern.getName()), new Object[0]);
            return Collections.emptyList();
        }
        ArrayList<Variable> params = new ArrayList<Variable>();
        params.add(new Variable("this", (Object)engine.eClass(), (Object)engine));
        params.add(new Variable("element", (Object)context.eClass(), (Object)context));
        params.add(new Variable("searchForOptionalElements", (Object)EcorePackage.Literals.EBOOLEAN, (Object)this.searchForAdditionalElements));
        Activity activity = this.getAnnotateActivity(pattern);
        if (activity != null) {
            try {
                Variable v;
                if (this.isDebug()) {
                    NotificationEmitter emitter = new NotificationEmitter();
                    this.interpreter = new StoryDrivenEclipseInterpreter(this.getClass().getClassLoader(), emitter);
                    emitter.addNotificationReceiver((NotificationReceiver)new OutputStreamNotificationReceiver(this.interpreter.getFacadeFactory()));
                } else {
                    this.interpreter = new StoryDrivenEclipseInterpreter(this.getClass().getClassLoader());
                }
                Map executionResult = this.interpreter.executeActivity((Object)activity, params);
                if (executionResult != null && (v = (Variable)executionResult.get(((EParameter)activity.getOutParameters().get(0)).getName())).getValue() instanceof AnnotationSet) {
                    return ((AnnotationSet)v.getValue()).getAnnotations();
                }
            }
            catch (SDMException e) {
                String message = "Exception occurred on search for '%1$s'!";
                this.warn(String.format(message, pattern.getName()), new Object[0]);
                e.printStackTrace();
            }
        }
        return Collections.emptyList();
    }

    private Activity getAnnotateActivity(PSPatternSpecification pattern) {
        EObject engine = (EObject)this.engines.get(pattern);
        EOperation annotateOperation = null;
        for (EOperation operation : engine.eClass().getEOperations()) {
            if (!"annotate".equals(operation.getName())) continue;
            annotateOperation = operation;
            break;
        }
        if (annotateOperation != null) {
            OperationExtension operExt = null;
            block1: for (EAnnotation anno : annotateOperation.getEAnnotations()) {
                for (EObject o : anno.getContents()) {
                    if (!(o instanceof OperationExtension)) continue;
                    operExt = (OperationExtension)o;
                    continue block1;
                }
            }
            if (operExt != null) {
                return operExt.getOwnedActivity();
            }
        }
        String message = "Exception occurred on search for '%1s': Could not find annotate operation!";
        this.warn(String.format(message, pattern.getName()), new Object[0]);
        return null;
    }
}

