/*
 * Decompiled with CFR 0.152.
 */
package org.reclipse.structure.inference;

import java.util.HashSet;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EClass;
import org.fujaba.commons.console.IReportListener;
import org.reclipse.metamodel.ITriggerChooser;
import org.reclipse.structure.inference.InferenceEngine;
import org.reclipse.structure.inference.strategy.ContextPatternPairFactory;
import org.reclipse.structure.specification.ModifierType;
import org.reclipse.structure.specification.PSCatalog;
import org.reclipse.structure.specification.PSCombinedFragmentItem;
import org.reclipse.structure.specification.PSNode;
import org.reclipse.structure.specification.PSObject;
import org.reclipse.structure.specification.PSPatternSpecification;
import org.reclipse.structure.specification.util.ContainmentWeightedTriggerChooser;
import org.reclipse.structure.specification.util.ModelHelper;

public abstract class InferenceStrategy
implements IReportListener {
    private PSCatalog catalog;
    private ITriggerChooser chooser;
    private ContextPatternPairFactory factory;
    private InferenceEngine engine;

    public InferenceStrategy(InferenceEngine engine, PSCatalog catalog) {
        this.engine = engine;
        this.catalog = catalog;
        this.chooser = new ContainmentWeightedTriggerChooser();
        this.factory = new ContextPatternPairFactory();
    }

    protected EClass getTrigger(PSPatternSpecification pattern) {
        HashSet<PSObject> objects = new HashSet<PSObject>();
        for (PSNode node : pattern.getNodes()) {
            if (!(node instanceof PSObject)) continue;
            objects.add((PSObject)node);
        }
        HashSet<EClass> types = new HashSet<EClass>();
        for (PSObject object : objects) {
            if (ModelHelper.isContainedInAdditionalFragment((PSCombinedFragmentItem)object) || ModelHelper.isContainedInNegativeFragment((PSCombinedFragmentItem)object) || ModifierType.ADDITIONAL.equals((Object)object.getModifier()) || ModifierType.NEGATIVE.equals((Object)object.getModifier())) continue;
            types.add(object.getInstanceOf());
        }
        return this.chooser.getTrigger(types);
    }

    protected InferenceEngine getEngine() {
        return this.engine;
    }

    protected PSCatalog getCatalog() {
        return this.catalog;
    }

    protected ITriggerChooser getChooser() {
        return this.chooser;
    }

    protected ContextPatternPairFactory getFactory() {
        return this.factory;
    }

    public final void startInference(IProgressMonitor monitor) {
        this.preProcess(monitor);
        this.processInference(monitor);
    }

    protected void preProcess(IProgressMonitor monitor) {
    }

    protected abstract void processInference(IProgressMonitor var1);

    public IStatus error(String message, Object ... args) {
        return this.engine.error(message, args);
    }

    public void warn(String message, Object ... args) {
        this.engine.warn(message, args);
    }

    public void append(String message, Object ... args) {
        this.engine.append(message, args);
    }

    public void task(String message, Object ... args) {
        this.engine.task(message, args);
    }

    public void info(String message, Object ... args) {
        this.engine.info(message, args);
    }

    public void debug(String message, Object ... args) {
        this.engine.debug(message, args);
    }
}

