/*
 * Decompiled with CFR 0.152.
 */
package org.reclipse.structure.inference;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.MissingFormatArgumentException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.NotificationImpl;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.fujaba.commons.console.IControllableReportListener;
import org.fujaba.commons.console.IProcessConsole;
import org.fujaba.commons.console.IReportListener;
import org.reclipse.structure.inference.IAnnotationEvaluator;
import org.reclipse.structure.inference.InferenceStrategy;
import org.reclipse.structure.inference.annotations.ASGAnnotation;
import org.reclipse.structure.inference.annotations.AnnotationCollector;
import org.reclipse.structure.inference.annotations.AnnotationEngine;
import org.reclipse.structure.inference.annotations.AnnotationSet;
import org.reclipse.structure.inference.annotations.AnnotationsFactory;
import org.reclipse.structure.inference.notification.InferenceProgressProvider;
import org.reclipse.structure.inference.strategy.BottomUpStrategy;
import org.reclipse.structure.inference.strategy.ContextPatternPair;
import org.reclipse.structure.specification.PSCatalog;
import org.reclipse.structure.specification.PSPatternSpecification;

public abstract class InferenceEngine
implements IReportListener {
    protected final IControllableReportListener reporter;
    protected Collection<EObject> host;
    protected PSCatalog catalog;
    protected final Map<PSPatternSpecification, AnnotationEngine> engines;
    protected InferenceStrategy strategy;
    protected IAnnotationEvaluator annotationEvaluator;
    protected boolean searchForAdditionalElements;
    protected InferenceProgressProvider progressProvider;
    protected Map<PSPatternSpecification, Collection<ASGAnnotation>> results;
    private boolean isDebug;

    public InferenceEngine(IControllableReportListener reporter, boolean isDebug) {
        this.reporter = reporter;
        this.isDebug = isDebug;
        this.progressProvider = InferenceProgressProvider.get(this);
        this.results = new HashMap<PSPatternSpecification, Collection<ASGAnnotation>>();
        this.engines = new HashMap<PSPatternSpecification, AnnotationEngine>();
    }

    protected boolean isDebug() {
        return this.isDebug;
    }

    public boolean isAborted() {
        return this.reporter.isAborted();
    }

    public boolean isPaused() {
        return this.reporter.isPaused();
    }

    public void setCatalog(PSCatalog catalog) {
        this.catalog = catalog;
    }

    public void setHost(Collection<EObject> host) {
        this.host = host;
    }

    public Collection<EObject> getHost() {
        return this.host;
    }

    public void setAnnotationEvaluator(IAnnotationEvaluator annotationEvaluator) {
        this.annotationEvaluator = annotationEvaluator;
    }

    public void setSearchForAdditionalElements(boolean searchForAdditionalElements) {
        this.searchForAdditionalElements = searchForAdditionalElements;
    }

    public InferenceProgressProvider getInferenceProgressProvider() {
        return this.progressProvider;
    }

    public IStatus start(IProgressMonitor monitor) {
        this.progressProvider.fireInit();
        this.strategy = new BottomUpStrategy(this, this.catalog);
        this.strategy.startInference(monitor);
        AnnotationCollector.get().clear();
        Resource resource = this.catalog.eResource();
        resource.eNotify((Notification)new NotificationImpl(4, false, false));
        return Status.OK_STATUS;
    }

    public Collection<ASGAnnotation> annotate(ContextPatternPair pair) {
        Collection<ASGAnnotation> result = this.applyPatternSearch(pair.getPattern(), pair.getContext());
        Collection<ASGAnnotation> annotationSet = this.results.get(pair.getPattern());
        if (annotationSet == null) {
            annotationSet = new HashSet<ASGAnnotation>();
            this.results.put(pair.getPattern(), annotationSet);
        }
        for (ASGAnnotation annotation : result) {
            annotation.setPattern(pair.getPattern());
            annotation.setAnnotationRanking(this.annotationEvaluator.evaluate(annotation));
            if (annotationSet.contains(annotation)) continue;
            annotationSet.add(annotation);
            this.progressProvider.fireNewAnnotation(annotation);
        }
        return result;
    }

    protected abstract Collection<ASGAnnotation> applyPatternSearch(PSPatternSpecification var1, EObject var2);

    public void setEnginePackage(EPackage enginesPack) {
        EFactory factory = enginesPack.getEFactoryInstance();
        for (EClassifier classifier : enginesPack.getEClassifiers()) {
            AnnotationEngine engine = (AnnotationEngine)factory.create((EClass)classifier);
            AnnotationSet resultSet = AnnotationsFactory.eINSTANCE.createAnnotationSet();
            engine.setFoundAnnotations(resultSet);
            PSPatternSpecification pattern = this.getPattern(classifier);
            this.engines.put(pattern, engine);
        }
    }

    private PSPatternSpecification getPattern(EClassifier classifier) {
        for (PSPatternSpecification pattern : this.catalog.getPatternSpecifications()) {
            if (!(String.valueOf(pattern.getName()) + "Engine").equals(classifier.getName())) continue;
            return pattern;
        }
        return null;
    }

    public IProcessConsole getConsole() {
        return this.reporter.getConsole();
    }

    public IStatus error(String message, Object ... args) {
        return this.reporter.error(message, args);
    }

    public void warn(String message, Object ... args) {
        this.reporter.warn(message, args);
    }

    public void append(String message, Object ... args) {
        this.reporter.append(message, args);
    }

    public void task(String message, Object ... args) {
        this.reporter.task(message, args);
    }

    public void info(String message, Object ... args) {
        this.reporter.info(message, args);
    }

    public void debug(String message, Object ... args) {
        try {
            this.reporter.debug(message, args);
        }
        catch (MissingFormatArgumentException e) {
            e.printStackTrace();
        }
    }

    public Map<PSPatternSpecification, Collection<ASGAnnotation>> getResults() {
        return this.results;
    }
}

