/*
 * Decompiled with CFR 0.152.
 */
package org.reclipse.structure.inference;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.impl.XMLParserPoolImpl;
import org.fujaba.commons.console.AbstractProcessConsoleJob;
import org.fujaba.commons.console.IControllableReportListener;
import org.fujaba.commons.console.ReportLevel;
import org.reclipse.structure.inference.IAnnotationEvaluator;
import org.reclipse.structure.inference.InferenceEngine;
import org.reclipse.structure.inference.InterpreterInferenceEngine;
import org.reclipse.structure.specification.PSCatalog;

public class DetectPatternsJob
extends AbstractProcessConsoleJob {
    private boolean isAnnotateAdditionalElements;
    private final InferenceEngine inferenceEngine;
    private IAnnotationEvaluator evaluator;
    private PSCatalog catalog;
    private final Resource catalogResource;
    private final Resource enginesResource;
    private final Resource hostGraphResource;

    public DetectPatternsJob(Resource catalogResource, Resource enginesResource, Resource hostGraphResource, ReportLevel reportLevel) {
        super("Reclipse", "Structural Inference", "Structural inference to detect patterns in a given host graph", reportLevel);
        this.catalogResource = catalogResource;
        this.enginesResource = enginesResource;
        this.hostGraphResource = hostGraphResource;
        boolean isDebug = ReportLevel.DEBUG.equals((Object)reportLevel);
        this.inferenceEngine = new InterpreterInferenceEngine((IControllableReportListener)this, isDebug);
    }

    public IStatus start(IProgressMonitor monitor) {
        monitor.beginTask(this.getName(), -1);
        this.catalog = this.loadCatalog();
        EPackage enginesPackage = this.loadEnginesPackage();
        Collection<EObject> hostGraph = this.loadHostGraph();
        this.inferenceEngine.setAnnotationEvaluator(this.evaluator);
        this.inferenceEngine.setCatalog(this.catalog);
        this.inferenceEngine.setHost(hostGraph);
        this.inferenceEngine.setEnginePackage(enginesPackage);
        this.inferenceEngine.setSearchForAdditionalElements(this.isAnnotateAdditionalElements);
        return this.inferenceEngine.start(monitor);
    }

    private PSCatalog loadCatalog() {
        PSCatalog catalog = null;
        this.task("Loading catalog input resource", new Object[0]);
        try {
            this.catalogResource.load(this.getLoadOptions(this.catalogResource));
        }
        catch (IOException e) {
            this.error("Catalog could not be loaded: " + e.getMessage(), new Object[0]);
        }
        this.debug("Catalog input resource loaded.", new Object[0]);
        for (EObject content : this.catalogResource.getContents()) {
            if (!(content instanceof PSCatalog)) continue;
            catalog = (PSCatalog)content;
            return catalog;
        }
        return catalog;
    }

    private EPackage loadEnginesPackage() {
        this.enginesResource.unload();
        try {
            this.enginesResource.load(this.getLoadOptions(this.enginesResource));
        }
        catch (IOException e) {
            this.error("Engines resource could not be loaded: " + e.getMessage(), new Object[0]);
        }
        EList enginesAndAnnotations = this.enginesResource.getContents();
        EPackage enginesPackage = null;
        for (EObject content : enginesAndAnnotations) {
            if (!(content instanceof EPackage)) continue;
            EPackage pack = (EPackage)content;
            this.enginesResource.getResourceSet().getPackageRegistry().put((Object)pack.getNsURI(), (Object)pack);
            if (!"http://ns.reclipse.org/structure/generation/engines".equals(pack.getNsURI())) continue;
            enginesPackage = (EPackage)content;
        }
        if (enginesPackage == null) {
            this.error("There are no valid engines available in the corresponding resource!", new Object[0]);
        }
        return enginesPackage;
    }

    private Collection<EObject> loadHostGraph() {
        this.task("Loading host graph resource", new Object[0]);
        try {
            this.hostGraphResource.load(this.getLoadOptions(this.hostGraphResource));
            this.debug("Resolving all proxies on the host graph resource.", new Object[0]);
            EcoreUtil.resolveAll((ResourceSet)this.hostGraphResource.getResourceSet());
            this.info("Host graph resource loaded.", new Object[0]);
        }
        catch (IOException e) {
            this.error("The host graph input resource could not be loaded: " + e.getLocalizedMessage(), new Object[0]);
        }
        EList hostGraph = this.hostGraphResource.getContents();
        return hostGraph;
    }

    public InferenceEngine getInferenceEngine() {
        return this.inferenceEngine;
    }

    public void setEvaluator(IAnnotationEvaluator evaluator) {
        this.evaluator = evaluator;
    }

    public void setUseExistingEngines(boolean isUsingExistingEngines) {
    }

    public void setAnnotateAdditionalElements(boolean isAnnotateAdditionalElements) {
        this.isAnnotateAdditionalElements = isAnnotateAdditionalElements;
    }

    private Map<Object, Object> getLoadOptions(Resource resource) {
        Map options = resource.getResourceSet().getLoadOptions();
        options.put("DEFER_ATTACHMENT", Boolean.TRUE);
        options.put("DEFER_IDREF_RESOLUTION", Boolean.TRUE);
        options.put("USE_DEPRECATED_METHODS", Boolean.TRUE);
        options.put("USE_PARSER_POOL", new XMLParserPoolImpl());
        options.put("USE_XML_NAME_TO_FEATURE_MAP", new HashMap());
        ((ResourceImpl)resource).setIntrinsicIDToEObjectMap(new HashMap());
        return options;
    }

    public InferenceEngine getEngine() {
        return this.inferenceEngine;
    }
}

