/*
 * Decompiled with CFR 0.152.
 */
package org.reclipse.patterns.structure.generator.ui;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.fujaba.commons.console.AbstractProcessConsoleJob;
import org.fujaba.commons.console.IReportListener;
import org.fujaba.commons.console.ReportLevel;
import org.reclipse.structure.generator.Generator;
import org.reclipse.structure.specification.PSCatalog;

public class ExportPatternsJob
extends AbstractProcessConsoleJob {
    private final String inputPath;
    private final String outputPath;
    private final ResourceSet resourceSet;
    private final Generator generator;

    public ExportPatternsJob(String inputPath, String outputPath, ReportLevel reportLevel) {
        super("Reclipse", "Story Diagram Generation", outputPath, reportLevel);
        this.inputPath = inputPath;
        this.outputPath = outputPath;
        this.resourceSet = new ResourceSetImpl();
        this.generator = new Generator((IReportListener)this);
    }

    public IStatus start(IProgressMonitor monitor) {
        Resource inputResource = this.resourceSet.createResource(URI.createPlatformResourceURI((String)this.inputPath, (boolean)true));
        this.task("Loading catalog input resource", new Object[0]);
        try {
            inputResource.load(this.resourceSet.getLoadOptions());
            this.info("Catalog input resource loaded.", new Object[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
            return this.error("The input file could not be loaded: " + e.getLocalizedMessage(), new Object[0]);
        }
        PSCatalog catalog = null;
        for (EObject content : inputResource.getContents()) {
            if (!(content instanceof PSCatalog)) continue;
            catalog = (PSCatalog)content;
            break;
        }
        if (catalog == null) {
            return this.error("The input file does not contain a valid catalog!", new Object[0]);
        }
        URI outputURI = URI.createPlatformResourceURI((String)this.outputPath, (boolean)true);
        Resource outputResource = null;
        this.task("Preparing output resource", new Object[0]);
        try {
            outputResource = this.resourceSet.getResource(outputURI, true);
            outputResource.getContents().clear();
            this.debug("Existing resource found, it will be overwritten.", new Object[0]);
        }
        catch (WrappedException e) {
            this.info("Creating new output resource", new Object[0]);
        }
        if (outputResource == null) {
            try {
                outputResource = this.resourceSet.createResource(outputURI);
                outputResource.save(Collections.emptyMap());
                outputResource.load(this.resourceSet.getLoadOptions());
                this.debug("New output resource has been created.", new Object[0]);
            }
            catch (WrappedException e) {
                return this.error("Could not create output resource: " + e.exception().getLocalizedMessage(), new Object[0]);
            }
            catch (IOException io) {
                return this.error("Could not create output resource: " + io.getLocalizedMessage(), new Object[0]);
            }
        }
        if (outputResource == null || !outputResource.isLoaded()) {
            return this.error("Output resource could not be loaded!", new Object[0]);
        }
        this.task("Starting generation process", new Object[0]);
        this.generator.generate((Collection)outputResource.getContents(), catalog);
        this.task("Saving generated resource", new Object[0]);
        try {
            outputResource.save(Collections.emptyMap());
            this.info("Output resource has been saved.", new Object[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
            return this.error("Could not save output resource: " + e.getLocalizedMessage(), new Object[0]);
        }
        return Status.OK_STATUS;
    }
}

