/*
 * Decompiled with CFR 0.152.
 */
package org.reclipse.math.functions;

import org.reclipse.math.functions.FunctionParameter;
import org.reclipse.math.functions.MathematicalFunction;

public class LinearFunction
extends MathematicalFunction {
    private static final String DELTA_X = "deltaX";
    private static final String DELTA_Y = "deltaY";
    private static final String GRADIENT = "gradient";

    public LinearFunction() {
        this.init();
    }

    private void init() {
        FunctionParameter param = new FunctionParameter();
        param.setName(DELTA_X);
        param.setValue(0.0);
        this.addToParams(DELTA_X, param);
        param = new FunctionParameter();
        param.setName(DELTA_Y);
        param.setValue(0.0);
        this.addToParams(DELTA_Y, param);
        param = new FunctionParameter();
        param.setName(GRADIENT);
        param.setValue(1.0);
        this.addToParams(GRADIENT, param);
    }

    @Override
    public double value(double x) {
        FunctionParameter deltaX = this.getFromParams(DELTA_X);
        FunctionParameter deltaY = this.getFromParams(DELTA_Y);
        FunctionParameter gradient = this.getFromParams(GRADIENT);
        if (deltaX == null || deltaY == null || gradient == null) {
            throw new IllegalStateException("Function arguments are missing.");
        }
        double dX = deltaX.getValue();
        double dY = deltaY.getValue();
        double m = gradient.getValue();
        return m * (x - dX) + dY;
    }

    public static String getFunctionName() {
        return "Linear function";
    }
}

