/*
 * Decompiled with CFR 0.152.
 */
package org.reclipse.generator.generation;

import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.resource.ImageDescriptor;
import org.fujaba.commons.console.AbstractProcessConsoleJob;
import org.reclipse.generator.IOutputListener;
import org.reclipse.generator.generation.FileInformation;
import org.reclipse.generator.generation.IGeneratorTask;

public abstract class AbstractGenerator
extends AbstractProcessConsoleJob {
    private Set<IOutputListener> listeners = new HashSet<IOutputListener>();
    protected Exception exception;
    protected List<IGeneratorTask> tasks = new ArrayList<IGeneratorTask>();
    protected Set<Object> modelElements = new HashSet<Object>();
    protected File output;

    public AbstractGenerator(String category, String title, String description) {
        super(category, title, description);
    }

    public AbstractGenerator(String category, String title, String description, ImageDescriptor image) {
        super(category, title, description, image);
    }

    public void addGeneratorTask(IGeneratorTask task) {
        if (task != null) {
            this.tasks.add(task);
        }
    }

    public void addOutputListener(IOutputListener listener) {
        this.listeners.add(listener);
    }

    public void addToElementsToProcess(Object element) {
        if (element != null) {
            this.modelElements.add(element);
        }
    }

    public void append(String output) {
        this.info(output, new Object[0]);
        for (IOutputListener listener : this.listeners) {
            listener.appendOutput(output);
        }
    }

    protected Set<FileInformation> generateFiles() throws Exception {
        HashSet<FileInformation> generatedFiles = new HashSet<FileInformation>();
        for (Object element : this.modelElements) {
            for (IGeneratorTask task : this.tasks) {
                Set<FileInformation> files;
                if (!task.isResponsible(element) || (files = task.generateFiles(element)) == null) continue;
                generatedFiles.addAll(files);
            }
        }
        return generatedFiles;
    }

    public Exception getException() {
        return this.exception;
    }

    protected void preProcess() {
        for (Object element : this.modelElements) {
            for (IGeneratorTask task : this.tasks) {
                if (!task.isResponsible(element)) continue;
                task.preProcess(element);
            }
        }
    }

    public void removeOutputListener(IOutputListener listener) {
        this.listeners.remove(listener);
    }

    public void setOutputTo(File file) {
        this.output = file;
    }
}

