/*
 * Decompiled with CFR 0.152.
 */
package org.reclipse.generator.compilation;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.environments.IExecutionEnvironment;
import org.eclipse.jdt.launching.environments.IExecutionEnvironmentsManager;

class PluginProjectCreationHelper {
    private static Hashtable<String, Integer> fSeverityTable = null;
    private static final int SEVERITY_ERROR = 3;
    private static final int SEVERITY_WARNING = 2;
    private static final int SEVERITY_IGNORE = 1;
    private static final IPath REQUIRED_PLUGINS_CONTAINER_PATH = new Path("org.eclipse.pde.core.requiredPlugins");
    private static final String PLUGIN_NATURE = "org.eclipse.pde.PluginNature";

    PluginProjectCreationHelper() {
    }

    static IProject createProject(String projectname, String[] pluginDependencies, String executionEnvironment) throws CoreException, JavaModelException {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectname);
        project.create(null);
        project.open(null);
        if (executionEnvironment == null) {
            executionEnvironment = "1.5";
        }
        PluginProjectCreationHelper.addNatureToProject(project, PLUGIN_NATURE, null);
        PluginProjectCreationHelper.setupJava(project, executionEnvironment);
        IFolder metaFolder = project.getFolder("META-INF");
        metaFolder.create(true, true, null);
        PluginProjectCreationHelper.createManifest(metaFolder, projectname, pluginDependencies);
        PluginProjectCreationHelper.createBuildProperties(project);
        return project;
    }

    private static void addNatureToProject(IProject proj, String natureId, IProgressMonitor monitor) throws CoreException {
        IProjectDescription description = proj.getDescription();
        String[] prevNatures = description.getNatureIds();
        String[] newNatures = new String[prevNatures.length + 1];
        System.arraycopy(prevNatures, 0, newNatures, 0, prevNatures.length);
        newNatures[prevNatures.length] = natureId;
        description.setNatureIds(newNatures);
        proj.setDescription(description, monitor);
    }

    private static void setupJava(IProject project, String executionEnvironment) throws CoreException, JavaModelException {
        PluginProjectCreationHelper.addNatureToProject(project, "org.eclipse.jdt.core.javanature", null);
        IFolder srcFolder = project.getFolder("src");
        srcFolder.create(true, true, null);
        IFolder binFolder = project.getFolder("bin");
        if (!binFolder.exists()) {
            binFolder.create(true, true, null);
        }
        IJavaProject javaProject = JavaCore.create((IProject)project);
        javaProject.setOutputLocation(binFolder.getFullPath(), null);
        IClasspathEntry[] entries = new IClasspathEntry[3];
        PluginProjectCreationHelper.setComplianceOptions(javaProject, executionEnvironment);
        entries[0] = PluginProjectCreationHelper.createJREEntry(executionEnvironment);
        entries[1] = PluginProjectCreationHelper.createContainerEntry();
        entries[2] = JavaCore.newSourceEntry((IPath)srcFolder.getFullPath());
        javaProject.setRawClasspath(entries, null);
    }

    private static void createManifest(IFolder metaFolder, String name, String[] pluginDependencies) throws CoreException {
        IFile manifest = metaFolder.getFile("MANIFEST.MF");
        StringBuffer contents = new StringBuffer();
        contents.append("Manifest-Version: 1.0\n");
        contents.append("Bundle-ManifestVersion: 2\n");
        contents.append("Bundle-Name: " + name + "\n");
        contents.append("Bundle-SymbolicName: " + name + "\n");
        contents.append("Bundle-Version: 1.0.0\n");
        contents.append("Bundle-RequiredExecutionEnvironment: J2SE-1.5\n");
        if (pluginDependencies != null) {
            contents.append("Require-Bundle: ");
            int i = 0;
            while (i < pluginDependencies.length) {
                if (i != 0) {
                    contents.append(",\n ");
                }
                contents.append(pluginDependencies[i]);
                ++i;
            }
            contents.append("\n");
        }
        contents.append("\n");
        manifest.create((InputStream)new ByteArrayInputStream(contents.toString().getBytes()), false, null);
    }

    private static void createBuildProperties(IProject project) throws CoreException {
        IFile buildProperties = project.getFile("build.properties");
        StringBuffer contents = new StringBuffer();
        contents.append("source.. = src/\n");
        contents.append("output.. = bin/\n");
        contents.append("bin.includes = META-INF/,\\\n");
        contents.append("               .\n");
        buildProperties.create((InputStream)new ByteArrayInputStream(contents.toString().getBytes()), false, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void setComplianceOptions(IJavaProject project, String compliance) {
        Map map = project.getOptions(false);
        if (compliance == null) {
            if (map.size() <= 0) return;
            map.remove("org.eclipse.jdt.core.compiler.compliance");
            map.remove("org.eclipse.jdt.core.compiler.source");
            map.remove("org.eclipse.jdt.core.compiler.codegen.targetPlatform");
            map.remove("org.eclipse.jdt.core.compiler.problem.assertIdentifier");
            map.remove("org.eclipse.jdt.core.compiler.problem.enumIdentifier");
        } else if ("1.6".equals(compliance)) {
            map.put("org.eclipse.jdt.core.compiler.compliance", "1.6");
            map.put("org.eclipse.jdt.core.compiler.source", "1.6");
            map.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.6");
            map.put("org.eclipse.jdt.core.compiler.problem.assertIdentifier", "error");
            map.put("org.eclipse.jdt.core.compiler.problem.enumIdentifier", "error");
        } else if ("1.5".equals(compliance)) {
            map.put("org.eclipse.jdt.core.compiler.compliance", "1.5");
            map.put("org.eclipse.jdt.core.compiler.source", "1.5");
            map.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.5");
            map.put("org.eclipse.jdt.core.compiler.problem.assertIdentifier", "error");
            map.put("org.eclipse.jdt.core.compiler.problem.enumIdentifier", "error");
        } else if ("1.4".equals(compliance)) {
            map.put("org.eclipse.jdt.core.compiler.compliance", "1.4");
            map.put("org.eclipse.jdt.core.compiler.source", "1.3");
            map.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.2");
            PluginProjectCreationHelper.updateSeverityComplianceOption(map, "org.eclipse.jdt.core.compiler.problem.assertIdentifier", "warning");
            PluginProjectCreationHelper.updateSeverityComplianceOption(map, "org.eclipse.jdt.core.compiler.problem.enumIdentifier", "warning");
        } else if ("1.3".equals(compliance)) {
            map.put("org.eclipse.jdt.core.compiler.compliance", "1.3");
            map.put("org.eclipse.jdt.core.compiler.source", "1.3");
            map.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.1");
            PluginProjectCreationHelper.updateSeverityComplianceOption(map, "org.eclipse.jdt.core.compiler.problem.assertIdentifier", "ignore");
            PluginProjectCreationHelper.updateSeverityComplianceOption(map, "org.eclipse.jdt.core.compiler.problem.enumIdentifier", "ignore");
        }
        project.setOptions(map);
    }

    private static void updateSeverityComplianceOption(Map<String, String> map, String key, String value) {
        Integer current_value = null;
        Integer new_value = null;
        String current_string_value = null;
        int current_int_value = 0;
        int new_int_value = 0;
        if (fSeverityTable == null) {
            fSeverityTable = new Hashtable(3);
            fSeverityTable.put("ignore", new Integer(1));
            fSeverityTable.put("warning", new Integer(2));
            fSeverityTable.put("error", new Integer(3));
        }
        if ((current_string_value = map.get(key)) != null && (current_value = fSeverityTable.get(current_string_value)) != null) {
            current_int_value = current_value;
        }
        if ((new_value = fSeverityTable.get(value)) != null) {
            new_int_value = new_value;
        }
        if (new_int_value > current_int_value) {
            map.put(key, value);
        }
    }

    private static IClasspathEntry createJREEntry(String ee) {
        IExecutionEnvironmentsManager manager;
        IExecutionEnvironment env;
        IPath path = null;
        if (ee != null && (env = (manager = JavaRuntime.getExecutionEnvironmentsManager()).getEnvironment(ee)) != null) {
            path = JavaRuntime.newJREContainerPath((IExecutionEnvironment)env);
        }
        if (path == null) {
            path = JavaRuntime.newDefaultJREContainerPath();
        }
        return JavaCore.newContainerEntry((IPath)path);
    }

    private static IClasspathEntry createContainerEntry() {
        return JavaCore.newContainerEntry((IPath)REQUIRED_PLUGINS_CONTAINER_PATH);
    }
}

