/*
 * Decompiled with CFR 0.152.
 */
package org.reclipse.generator.ui.wizard;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class SelectFileWizardPage
extends WizardPage
implements SelectionListener,
ModifyListener {
    private static final String CATALOG_FILE_NAME = "catalogFileName";
    private Text catalogFileNameText;
    private Button browseCatalogFileButton;
    private boolean initializing = false;

    protected SelectFileWizardPage(String pageName) {
        super(pageName);
    }

    public void createControl(Composite parent) {
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.numColumns = 2;
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        composite.setLayout((Layout)gridLayout);
        Label label = new Label(composite, 258);
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.horizontalSpan = 2;
        label.setLayoutData((Object)gridData);
        label = new Label(composite, 0);
        label.setText("Choose a catalog file:");
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        label.setLayoutData((Object)gridData);
        this.catalogFileNameText = new Text(composite, 2052);
        this.catalogFileNameText.addModifyListener((ModifyListener)this);
        gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        this.catalogFileNameText.setLayoutData((Object)gridData);
        this.browseCatalogFileButton = new Button(composite, 8);
        this.browseCatalogFileButton.setText("Browse...");
        this.browseCatalogFileButton.addSelectionListener((SelectionListener)this);
        this.setControl((Control)composite);
        Dialog.applyDialogFont((Control)parent);
    }

    public void modifyText(ModifyEvent e) {
        this.checkPageComplete();
    }

    public void widgetSelected(SelectionEvent e) {
        Object source = e.getSource();
        if (source == this.browseCatalogFileButton) {
            FileDialog dialog = new FileDialog(this.getShell(), 8192);
            dialog.setText("Select a Structural Patterns Catalog file:");
            dialog.setFileName(this.catalogFileNameText.getText());
            dialog.setFilterExtensions(new String[]{"*.ecore"});
            dialog.setFilterNames(new String[]{"Structural Patterns Catalog"});
            String traceFile = dialog.open();
            if (traceFile != null) {
                this.catalogFileNameText.setText(traceFile);
            }
        }
        this.checkPageComplete();
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    private void checkPageComplete() {
        if (!this.initializing) {
            this.setPageComplete(false);
            if (this.catalogFileNameText.getText().trim().equals("")) {
                this.setErrorMessage("Please provide a file name for the structural patterns catalog.");
                return;
            }
            this.setPageComplete(true);
            this.setErrorMessage(null);
        }
    }

    private void initialize() {
        String catalogFileName;
        IDialogSettings settings = this.getDialogSettings();
        this.initializing = true;
        if (settings != null && (catalogFileName = settings.get(CATALOG_FILE_NAME)) != null) {
            this.catalogFileNameText.setText(catalogFileName);
        }
        this.initializing = false;
        this.checkPageComplete();
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.initialize();
            this.checkPageComplete();
        }
        super.setVisible(visible);
    }

    public void finish() {
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            settings.put(CATALOG_FILE_NAME, this.getExportFileName());
        }
    }

    public String getExportFileName() {
        return this.catalogFileNameText.getText().trim();
    }
}

