/*
 * Decompiled with CFR 0.152.
 */
package org.reclipse.generator.ui.wizard;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.reclipse.generator.ui.util.PluginSelectionDialog;
import org.reclipse.generator.ui.util.TableSelectionListener;

public class CompileDependenciesPage
extends WizardPage {
    private static final String CLASS_PATH = "classPath";
    private static final String REQUIRED_PLUGINS = "requiredPlugins";
    private ArrayList<String> classPaths;
    private ArrayList<String> requiredPlugins;
    private Table cpTable;
    private Table rpTable;
    private Section classPathSection;
    private Section requiredPluginsSection;
    private ScrolledForm mainForm;

    public CompileDependenciesPage(Collection<String> defaultRequiredPlugins) {
        super("ClassPathPage");
        this.setTitle("Additional Classpaths for Compilation");
        this.setDescription("Add additional paths for compilation of the structural patterns catalog.");
        this.classPaths = new ArrayList();
        this.requiredPlugins = new ArrayList();
        if (defaultRequiredPlugins != null) {
            this.requiredPlugins.addAll(defaultRequiredPlugins);
        }
    }

    private void initTableContent() {
        int i;
        IDialogSettings settings = this.getDialogSettings();
        String[] cps = null;
        String[] rps = null;
        if (settings != null) {
            cps = settings.getArray(CLASS_PATH);
            rps = settings.getArray(REQUIRED_PLUGINS);
        }
        if (cps != null) {
            this.classPaths.clear();
            i = 0;
            while (i < cps.length) {
                this.classPaths.add(cps[i]);
                ++i;
            }
        }
        if (rps != null) {
            this.requiredPlugins.clear();
            i = 0;
            while (i < rps.length) {
                this.requiredPlugins.add(rps[i]);
                ++i;
            }
        }
    }

    public void createControl(Composite parent) {
        FormToolkit kit = new FormToolkit(parent.getDisplay());
        this.mainForm = kit.createScrolledForm(parent);
        GridLayout gridLayout = new GridLayout(1, false);
        GridData gridData = new GridData(1808);
        this.mainForm.getBody().setLayoutData((Object)gridData);
        this.mainForm.getBody().setLayout((Layout)gridLayout);
        this.createRequiredPluginsSection(this.mainForm, kit);
        this.createClassPathSection(this.mainForm, kit);
        this.initTableContent();
        this.refreshCPTable();
        this.refreshRPTable();
        this.setControl((Control)this.mainForm);
        Dialog.applyDialogFont((Control)parent);
    }

    public Collection<String> getClassPath() {
        return this.classPaths;
    }

    public Collection<String> getRequiredPlugins() {
        return this.requiredPlugins;
    }

    public void finish() {
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            Object[] objects = this.classPaths.toArray();
            String[] values = new String[objects.length];
            int i = 0;
            while (i < values.length) {
                values[i] = (String)objects[i];
                ++i;
            }
            settings.put(CLASS_PATH, values);
            objects = this.requiredPlugins.toArray();
            values = new String[objects.length];
            i = 0;
            while (i < values.length) {
                values[i] = (String)objects[i];
                ++i;
            }
            settings.put(REQUIRED_PLUGINS, values);
        }
    }

    private void createClassPathSection(ScrolledForm parent, FormToolkit kit) {
        this.classPathSection = kit.createSection(parent.getBody(), 322);
        this.classPathSection.setText("Additional Classpaths for Compilation");
        this.classPathSection.setDescription("Add additional paths for compilation of the structural patterns catalog.");
        GridData gridData = new GridData(784);
        this.classPathSection.setLayoutData((Object)gridData);
        Composite sectionClient = kit.createComposite((Composite)this.classPathSection, 0);
        sectionClient.setLayout((Layout)new GridLayout(2, false));
        this.cpTable = kit.createTable(sectionClient, 0x10000002);
        gridData = new GridData(1808);
        this.cpTable.setLayoutData((Object)gridData);
        this.classPathSection.setClient((Control)sectionClient);
        Composite buttonComposite = kit.createComposite(sectionClient, 0);
        buttonComposite.setLayout((Layout)new GridLayout());
        GridData data = new GridData();
        data.verticalAlignment = 128;
        buttonComposite.setLayoutData((Object)data);
        Button addLibraryButton = kit.createButton(buttonComposite, "Add Library ...", 0);
        addLibraryButton.setText("Add Library ...");
        data = new GridData(768);
        data.verticalAlignment = 128;
        addLibraryButton.setLayoutData((Object)data);
        addLibraryButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog fileDialog = new FileDialog(Display.getCurrent().getActiveShell(), 4100);
                fileDialog.setText("Choose a library to be added to the classpath.");
                fileDialog.setFilterExtensions(new String[]{"*.jar", "*.zip"});
                fileDialog.setFilterNames(new String[]{"Java Archive (*.jar)", "ZIP Archive (*.zip)"});
                String fileName = fileDialog.open();
                if (fileName != null) {
                    CompileDependenciesPage.this.classPaths.add(fileName);
                    CompileDependenciesPage.this.refreshCPTable();
                }
            }
        });
        Button addDirectoryButton = kit.createButton(buttonComposite, "Add Directory ...", 0);
        data = new GridData(768);
        data.verticalAlignment = 128;
        addDirectoryButton.setLayoutData((Object)data);
        addDirectoryButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog dirDialog = new DirectoryDialog(Display.getCurrent().getActiveShell(), 4100);
                dirDialog.setText("Choose a directory to be added to the classpath.");
                String dirName = dirDialog.open();
                if (dirName != null) {
                    CompileDependenciesPage.this.classPaths.add(dirName);
                    CompileDependenciesPage.this.refreshCPTable();
                }
            }
        });
        Button removeButton = kit.createButton(buttonComposite, "Remove", 0);
        data = new GridData(768);
        data.verticalAlignment = 128;
        removeButton.setLayoutData((Object)data);
        removeButton.setEnabled(false);
        removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (CompileDependenciesPage.this.cpTable.getSelectionCount() > 0) {
                    TableItem[] items;
                    TableItem[] tableItemArray = items = CompileDependenciesPage.this.cpTable.getSelection();
                    int n = items.length;
                    int n2 = 0;
                    while (n2 < n) {
                        TableItem item = tableItemArray[n2];
                        String itemText = item.getText();
                        int index = CompileDependenciesPage.this.cpTable.indexOf(item);
                        if (index > -1) {
                            CompileDependenciesPage.this.cpTable.remove(index);
                            CompileDependenciesPage.this.classPaths.remove(itemText);
                        }
                        ++n2;
                    }
                    CompileDependenciesPage.this.refreshCPTable();
                }
            }
        });
        TableSelectionListener listener = new TableSelectionListener(this.cpTable, removeButton);
        this.cpTable.addSelectionListener((SelectionListener)listener);
    }

    private void createRequiredPluginsSection(ScrolledForm parent, FormToolkit kit) {
        this.requiredPluginsSection = kit.createSection(parent.getBody(), 320);
        this.requiredPluginsSection.setText("Required Projects");
        GridData gridData = new GridData(1808);
        this.requiredPluginsSection.setLayoutData((Object)gridData);
        Composite sectionClient = kit.createComposite((Composite)this.requiredPluginsSection, 0);
        sectionClient.setLayout((Layout)new GridLayout(2, false));
        this.rpTable = kit.createTable(sectionClient, 2);
        gridData = new GridData(1808);
        this.rpTable.setLayoutData((Object)gridData);
        this.requiredPluginsSection.setClient((Control)sectionClient);
        Composite buttonComposite = kit.createComposite(sectionClient, 0);
        buttonComposite.setLayout((Layout)new GridLayout());
        GridData data = new GridData();
        data.verticalAlignment = 128;
        buttonComposite.setLayoutData((Object)data);
        Button addButton = kit.createButton(buttonComposite, "Add...", 0);
        addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IPluginModelBase[] allModels = PluginRegistry.getActiveModels((boolean)false);
                ArrayList<IPluginModelBase> newModels = new ArrayList<IPluginModelBase>();
                int i = 0;
                while (i < allModels.length) {
                    if (allModels[i] instanceof IPluginModelBase && CompileDependenciesPage.this.canAdd(allModels[i])) {
                        newModels.add(allModels[i]);
                    }
                    ++i;
                }
                IPluginModelBase[] candidateModels = newModels.toArray(new IPluginModelBase[newModels.size()]);
                PluginSelectionDialog dialog = new PluginSelectionDialog(CompileDependenciesPage.this.getShell(), candidateModels, true);
                if (dialog.open() == 0) {
                    Object[] models = dialog.getResult();
                    int i2 = 0;
                    while (i2 < models.length) {
                        String id = ((IPluginModelBase)models[i2]).getPluginBase().getId();
                        CompileDependenciesPage.this.requiredPlugins.add(id);
                        ++i2;
                    }
                    CompileDependenciesPage.this.refreshRPTable();
                }
            }
        });
        data = new GridData(768);
        data.verticalAlignment = 128;
        addButton.setLayoutData((Object)data);
        Button removeButton = kit.createButton(buttonComposite, "Remove", 0);
        removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (CompileDependenciesPage.this.rpTable.getSelectionCount() > 0) {
                    TableItem[] items;
                    TableItem[] tableItemArray = items = CompileDependenciesPage.this.rpTable.getSelection();
                    int n = items.length;
                    int n2 = 0;
                    while (n2 < n) {
                        TableItem item = tableItemArray[n2];
                        String itemText = item.getText();
                        int index = CompileDependenciesPage.this.rpTable.indexOf(item);
                        if (index > -1) {
                            CompileDependenciesPage.this.rpTable.remove(index);
                            CompileDependenciesPage.this.requiredPlugins.remove(itemText);
                        }
                        ++n2;
                    }
                    CompileDependenciesPage.this.refreshCPTable();
                }
            }
        });
        data = new GridData(768);
        data.verticalAlignment = 128;
        removeButton.setLayoutData((Object)data);
        removeButton.setEnabled(false);
        TableSelectionListener listener = new TableSelectionListener(this.rpTable, removeButton);
        this.rpTable.addSelectionListener((SelectionListener)listener);
    }

    private void refreshCPTable() {
        this.cpTable.removeAll();
        for (String classPath : this.classPaths) {
            TableItem item = new TableItem(this.cpTable, 0);
            item.setText(classPath);
        }
    }

    private void refreshRPTable() {
        this.rpTable.removeAll();
        for (String requiredPlugin : this.requiredPlugins) {
            TableItem item = new TableItem(this.rpTable, 0);
            item.setText(requiredPlugin);
        }
    }

    private boolean canAdd(IPluginModelBase candidate) {
        IPluginBase plugin = candidate.getPluginBase();
        if (candidate.isFragmentModel()) {
            return false;
        }
        TableItem[] items = this.rpTable.getItems();
        int i = 0;
        while (i < items.length) {
            String alreadyChosen = items[i].getText();
            if (plugin.getId().equals(alreadyChosen)) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

