/*
 * Decompiled with CFR 0.152.
 */
package org.reclipse.generator.ui.util;

import java.util.Comparator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.FilteredItemsSelectionDialog;
import org.reclipse.generator.ui.GeneratorUIActivator;

public class PluginSelectionDialog
extends FilteredItemsSelectionDialog {
    private static final String DIALOG_SETTINGS = "org.reclipse.generator.ui.util.PluginSelectionDialog";
    private IPluginModelBase[] fModels;
    private static final String MESSAGE = "Select a Plug-in:";
    private static final String TITLE = "Plug-in Selection";

    public PluginSelectionDialog(Shell parentShell, boolean multipleSelection) {
        this(parentShell, PluginSelectionDialog.getElements(), multipleSelection);
    }

    public PluginSelectionDialog(Shell parentShell, IPluginModelBase[] models, boolean multipleSelection) {
        super(parentShell, multipleSelection);
        this.fModels = models;
        this.setTitle(TITLE);
        this.setMessage(MESSAGE);
    }

    private static IPluginModelBase[] getElements() {
        return PluginRegistry.getActiveModels((boolean)false);
    }

    protected Control createExtendedContentArea(Composite parent) {
        return null;
    }

    protected FilteredItemsSelectionDialog.ItemsFilter createFilter() {
        return new PluginSearchItemsFilter();
    }

    protected void fillContentProvider(FilteredItemsSelectionDialog.AbstractContentProvider contentProvider, FilteredItemsSelectionDialog.ItemsFilter itemsFilter, IProgressMonitor progressMonitor) throws CoreException {
        int i = 0;
        while (i < this.fModels.length) {
            contentProvider.add((Object)this.fModels[i], itemsFilter);
            progressMonitor.worked(1);
            ++i;
        }
        progressMonitor.done();
    }

    protected IDialogSettings getDialogSettings() {
        IDialogSettings settings = GeneratorUIActivator.getDefault().getDialogSettings().getSection(DIALOG_SETTINGS);
        if (settings == null) {
            settings = GeneratorUIActivator.getDefault().getDialogSettings().addNewSection(DIALOG_SETTINGS);
        }
        return settings;
    }

    public String getElementName(Object item) {
        if (item instanceof IPluginModelBase) {
            IPluginModelBase model = (IPluginModelBase)item;
            return model.getPluginBase().getId();
        }
        return null;
    }

    protected Comparator getItemsComparator() {
        return new PluginSearchComparator();
    }

    protected IStatus validateItem(Object item) {
        return new Status(0, "org.reclipse.generator.ui", 0, "", null);
    }

    private class PluginSearchComparator
    implements Comparator {
        private PluginSearchComparator() {
        }

        public int compare(Object o1, Object o2) {
            int id2;
            int id1 = this.getId(o1);
            if (id1 != (id2 = this.getId(o2))) {
                return id1 - id2;
            }
            return this.compareSimilarObjects(o1, o2);
        }

        private int getId(Object element) {
            if (element instanceof IPluginModelBase) {
                return 100;
            }
            return 0;
        }

        private int compareSimilarObjects(Object o1, Object o2) {
            if (o1 instanceof IPluginModelBase && o2 instanceof IPluginModelBase) {
                IPluginModelBase ipmb1 = (IPluginModelBase)o1;
                IPluginModelBase ipmb2 = (IPluginModelBase)o2;
                return this.comparePlugins(ipmb1.getPluginBase(), ipmb2.getPluginBase());
            }
            return 0;
        }

        private int comparePlugins(IPluginBase ipmb1, IPluginBase ipmb2) {
            return ipmb1.getId().compareTo(ipmb2.getId());
        }
    }

    private class PluginSearchItemsFilter
    extends FilteredItemsSelectionDialog.ItemsFilter {
        private PluginSearchItemsFilter() {
            super((FilteredItemsSelectionDialog)PluginSelectionDialog.this);
        }

        public boolean isConsistentItem(Object item) {
            return true;
        }

        public boolean matchItem(Object item) {
            String id = null;
            if (item instanceof IPluginModelBase) {
                IPluginModelBase model = (IPluginModelBase)item;
                id = model.getPluginBase().getId();
            }
            return this.matches(id);
        }

        protected boolean matches(String text) {
            String pattern = this.patternMatcher.getPattern();
            if (pattern.indexOf("*") != 0 & pattern.indexOf("?") != 0 & pattern.indexOf(".") != 0) {
                pattern = "*" + pattern;
                this.patternMatcher.setPattern(pattern);
            }
            return this.patternMatcher.matches(text);
        }
    }
}

