/*
 * Decompiled with CFR 0.152.
 */
package org.reclipse.structure.specification.navigator;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.workspace.WorkspaceEditingDomainFactory;
import org.eclipse.emf.workspace.util.WorkspaceSynchronizer;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.fujaba.commons.notation.HierarchicalNode;
import org.reclipse.structure.specification.PSPatternSpecification;
import org.reclipse.structure.specification.navigator.PSNavigatorItem;

public class PSNavigatorContentProvider
implements ITreeContentProvider {
    private Viewer viewer;
    private AdapterFactoryEditingDomain editingDomain;
    private WorkspaceSynchronizer synchronizer;
    private Runnable refresher;

    public PSNavigatorContentProvider() {
        TransactionalEditingDomain ted = WorkspaceEditingDomainFactory.INSTANCE.createEditingDomain();
        this.editingDomain = (AdapterFactoryEditingDomain)ted;
        this.editingDomain.setResourceToReadOnlyMap((Map)new HashMap<Resource, Boolean>(){
            private static final long serialVersionUID = 1L;

            @Override
            public Boolean get(Object key) {
                if (key instanceof Resource && !this.containsKey(key)) {
                    this.put((Resource)key, Boolean.TRUE);
                }
                return (Boolean)super.get(key);
            }
        });
        this.refresher = new Runnable(){

            @Override
            public void run() {
                if (PSNavigatorContentProvider.this.viewer != null) {
                    PSNavigatorContentProvider.this.viewer.refresh();
                }
            }
        };
        this.synchronizer = new WorkspaceSynchronizer(ted, new WorkspaceSynchronizer.Delegate(){

            public void dispose() {
            }

            public boolean handleResourceChanged(Resource res) {
                PSNavigatorContentProvider.this.unloadAllResources();
                PSNavigatorContentProvider.this.refresh();
                return true;
            }

            public boolean handleResourceDeleted(Resource res) {
                PSNavigatorContentProvider.this.unloadAllResources();
                PSNavigatorContentProvider.this.refresh();
                return true;
            }

            public boolean handleResourceMoved(Resource res, URI uri) {
                PSNavigatorContentProvider.this.unloadAllResources();
                PSNavigatorContentProvider.this.refresh();
                return true;
            }
        });
    }

    private Set<PSNavigatorItem> createNavigatorItems(List<EObject> contents, Object parent) {
        HashSet<PSNavigatorItem> result = new HashSet<PSNavigatorItem>();
        for (EObject object : contents) {
            if (object instanceof HierarchicalNode && ((HierarchicalNode)object).getModel() instanceof PSPatternSpecification) {
                result.add(new PSNavigatorItem((HierarchicalNode)object, parent));
            }
            if (!(object instanceof PSPatternSpecification)) continue;
            System.out.println("i am am a domain type");
        }
        return result;
    }

    public void dispose() {
        this.synchronizer.dispose();
        this.synchronizer = null;
        this.refresher = null;
        this.viewer = null;
        this.unloadAllResources();
        ((TransactionalEditingDomain)this.editingDomain).dispose();
        this.editingDomain = null;
    }

    public Object[] getChildren(Object parent) {
        if (parent instanceof IFile) {
            IFile file = (IFile)parent;
            URI uri = URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true);
            Resource res = this.editingDomain.getResourceSet().getResource(uri, true);
            return this.createNavigatorItems((List<EObject>)res.getContents(), parent).toArray();
        }
        if (parent instanceof PSNavigatorItem) {
            return ((PSNavigatorItem)((Object)parent)).getChildren().toArray();
        }
        return new Object[0];
    }

    public Object[] getElements(Object input) {
        return this.getChildren(input);
    }

    public Object getParent(Object element) {
        if (element instanceof PSNavigatorItem) {
            return ((PSNavigatorItem)((Object)element)).getParent();
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        return element instanceof IFile || this.getChildren(element).length > 0;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.viewer = viewer;
    }

    protected void refresh() {
        if (this.viewer != null && !this.viewer.getControl().isDisposed()) {
            this.viewer.getControl().getDisplay().asyncExec(this.refresher);
        }
    }

    protected void unloadAllResources() {
        for (Resource res : this.editingDomain.getResourceSet().getResources()) {
            res.unload();
        }
    }
}

