/*
 * Decompiled with CFR 0.152.
 */
package org.reclipse.structure.specification.navigator;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.common.ui.URIEditorInput;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.workspace.util.WorkspaceSynchronizer;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.navigator.CommonActionProvider;
import org.eclipse.ui.navigator.ICommonActionExtensionSite;
import org.eclipse.ui.navigator.ICommonViewerWorkbenchSite;
import org.eclipse.ui.part.FileEditorInput;
import org.fujaba.commons.notation.HierarchicalNode;
import org.reclipse.structure.specification.PSPatternSpecification;
import org.reclipse.structure.specification.navigator.PSNavigatorItem;
import org.reclipse.structure.specification.navigator.PSNavigatorPlugin;

public class PSNavigatorActionProvider
extends CommonActionProvider {
    private boolean isContribute;
    private OpenDiagramAction action;

    public void init(ICommonActionExtensionSite site) {
        super.init(site);
        if (site.getViewSite() instanceof ICommonViewerWorkbenchSite) {
            this.isContribute = true;
            this.makeActions((ICommonViewerWorkbenchSite)site.getViewSite());
        } else {
            this.isContribute = false;
        }
    }

    private void makeActions(ICommonViewerWorkbenchSite viewerSite) {
        this.action = new OpenDiagramAction(viewerSite);
    }

    public void fillActionBars(IActionBars bars) {
        if (!this.isContribute) {
            return;
        }
        IStructuredSelection sel = (IStructuredSelection)this.getContext().getSelection();
        this.action.selectionChanged(sel);
        if (this.action.isEnabled()) {
            bars.setGlobalActionHandler("org.eclipse.ui.navigator.Open", (IAction)this.action);
        }
    }

    public void fillContextMenu(IMenuManager menu) {
    }

    private static class OpenDiagramAction
    extends Action {
        private HierarchicalNode node;
        private ICommonViewerWorkbenchSite site;

        public OpenDiagramAction(ICommonViewerWorkbenchSite site) {
            super("NavigatorActionProvider_OpenDiagramActionName");
            this.site = site;
        }

        public final void selectionChanged(IStructuredSelection sel) {
            this.node = null;
            if (sel.size() == 1) {
                HierarchicalNode diagram;
                Object element = sel.getFirstElement();
                if (element instanceof PSNavigatorItem) {
                    element = ((PSNavigatorItem)((Object)element)).getItem();
                } else if (element instanceof IAdaptable) {
                    element = ((IAdaptable)element).getAdapter(HierarchicalNode.class);
                }
                if (element instanceof HierarchicalNode && (diagram = (HierarchicalNode)element).getModel() instanceof PSPatternSpecification) {
                    this.node = diagram;
                }
            }
            this.setEnabled(this.node != null);
        }

        public void run() {
            if (this.node == null || this.node.eResource() == null) {
                return;
            }
            IEditorInput input = OpenDiagramAction.getEditorInput(this.node);
            IWorkbenchPage page = this.site.getPage();
            try {
                page.openEditor(input, "org.reclipse.structure.specification.ui.PSCatalogEditor");
            }
            catch (PartInitException e) {
                PSNavigatorPlugin.getInstance().logError("Exception while opening diagram", e);
            }
        }

        private static IEditorInput getEditorInput(HierarchicalNode diagram) {
            Resource res = diagram.eResource();
            for (EObject content : res.getContents()) {
                if (content == diagram) {
                    return new FileEditorInput(WorkspaceSynchronizer.getFile((Resource)res));
                }
                if (content instanceof HierarchicalNode) break;
            }
            URI uri = EcoreUtil.getURI((EObject)diagram);
            String editorName = String.valueOf(uri.lastSegment()) + '#' + diagram.eResource().getContents().indexOf((Object)diagram);
            URIEditorInput editorInput = new URIEditorInput(uri, editorName);
            return editorInput;
        }
    }
}

