/*
 * Decompiled with CFR 0.152.
 */
package org.reclipse.structure.inference.ui.matching.views;

import java.io.IOException;
import java.util.Collections;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.gef.EditDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.ui.parts.ScrollingGraphicalViewer;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.ViewPart;
import org.fujaba.commons.console.ProcessConsoleState;
import org.fujaba.commons.edit.parts.AbstractEdgeEditPart;
import org.fujaba.commons.edit.parts.AbstractNodeEditPart;
import org.fujaba.commons.notation.DiagramElement;
import org.fujaba.commons.notation.HierarchicalNode;
import org.fujaba.commons.ui.WorkbenchFileTreeSelectionDialog;
import org.reclipse.structure.inference.annotations.ASGAnnotation;
import org.reclipse.structure.inference.notification.InferenceProgressListener;
import org.reclipse.structure.inference.ui.matching.views.ObjectMatchingView;
import org.reclipse.structure.inference.ui.matching.views.PatternMatchingView;
import org.reclipse.structure.inference.ui.views.annotations.AnnotationView;
import org.reclipse.structure.specification.PSPatternSpecification;

public abstract class AbstractMatchingView
extends ViewPart
implements ISelectionListener,
InferenceProgressListener {
    private static final String MODEL_EXT = ".psc";
    private static final String DIAGRAM_EXT = ".pscdiagram";
    private static EditDomain editDomain;
    private static ASGAnnotation current;
    private ScrollingGraphicalViewer viewer;

    public static final ASGAnnotation getCurrent() {
        return current;
    }

    private static final EditDomain getEditDomain() {
        if (editDomain == null) {
            editDomain = new EditDomain();
        }
        return editDomain;
    }

    public static void setLayout(IWorkbenchPart part, HierarchicalNode root, boolean all) {
        if (part instanceof ObjectMatchingView) {
            if (all) {
                ObjectMatchingView.getAnnotationCache().clear();
            }
            ObjectMatchingView.getPatternCache().put(AbstractMatchingView.getCurrent().getPattern(), root);
        } else if (part instanceof PatternMatchingView) {
            if (all) {
                PatternMatchingView.getAnnotationCache().clear();
            }
            PatternMatchingView.getPatternCache().put(AbstractMatchingView.getCurrent().getPattern(), root);
        }
    }

    protected void addSelection(DiagramElement select) {
        block3: {
            block1: {
                Object part;
                block2: {
                    part = this.getViewer().getEditPartRegistry().get(select);
                    if (part == null) break block1;
                    if (!(part instanceof AbstractNodeEditPart)) break block2;
                    ((EditPart)part).setSelected(1);
                    break block3;
                }
                if (!(part instanceof AbstractEdgeEditPart)) break block3;
                ((EditPart)part).setSelected(1);
                break block3;
            }
            for (Object potential : this.getViewer().getEditPartRegistry().values()) {
                if (!(potential instanceof AbstractNodeEditPart) || !((AbstractNodeEditPart)potential).getRealModel().equals(select.getModel())) continue;
                ((EditPart)potential).setSelected(1);
            }
        }
    }

    public void createPartControl(Composite parent) {
        this.viewer = new ScrollingGraphicalViewer();
        this.viewer.createControl(parent);
        this.viewer.setEditPartFactory(this.getEditPartFactory());
        this.viewer.setEditDomain(AbstractMatchingView.getEditDomain());
        MenuManager contextMenuManager = this.createContextMenuManager(this.viewer);
        if (contextMenuManager != null) {
            this.viewer.setContextMenu(contextMenuManager);
            this.getSite().registerContextMenu(this.getId(), contextMenuManager, (ISelectionProvider)this.viewer);
        }
        this.getSite().getPage().addSelectionListener((ISelectionListener)this);
        this.getSite().setSelectionProvider((ISelectionProvider)this.getViewer());
        this.selectionChanged(this.getSite().getPart(), this.getSite().getPage().getSelection());
    }

    protected abstract String getId();

    protected MenuManager createContextMenuManager(ScrollingGraphicalViewer viewer) {
        return null;
    }

    public void dispose() {
        this.getSite().getPage().removeSelectionListener((ISelectionListener)this);
        if (this.viewer.getControl() != null) {
            this.viewer.getControl().dispose();
        }
        this.viewer = null;
        super.dispose();
    }

    private HierarchicalNode getDiagramRoot(ASGAnnotation anno) {
        HierarchicalNode node = null;
        if (this instanceof ObjectMatchingView) {
            node = ObjectMatchingView.getAnnotationCache().get(anno);
        } else if (this instanceof PatternMatchingView) {
            node = PatternMatchingView.getAnnotationCache().get(anno);
        }
        if (node == null) {
            if (this instanceof ObjectMatchingView) {
                node = ObjectMatchingView.getPatternCache().get(anno.getPattern());
            } else if (this instanceof PatternMatchingView) {
                node = PatternMatchingView.getPatternCache().get(anno.getPattern());
            }
            if (node == null) {
                String path;
                PSPatternSpecification pattern = anno.getPattern();
                Resource res = pattern.eResource();
                ResourceSet ress = res.getResourceSet();
                node = this.getDiagramRootFromExisting(ress, pattern, path = res.getURI().toPlatformString(false).replace(MODEL_EXT, DIAGRAM_EXT));
                if (node == null) {
                    String extension = DIAGRAM_EXT.substring(1);
                    boolean aborted = false;
                    while (node == null && !aborted) {
                        MessageDialog dialog = this.getDiagramSelectionDialog(path, pattern.getName());
                        switch (dialog.open()) {
                            default: {
                                WorkbenchFileTreeSelectionDialog selector = new WorkbenchFileTreeSelectionDialog(this.getSite().getShell(), "Pattern Specification Diagram", "Select a structural pattern specification diagram.", extension);
                                if (selector.open() != 0) break;
                                IFile selected = (IFile)selector.getFirstResult();
                                path = selected.getFullPath().toOSString();
                                break;
                            }
                            case 1: {
                                System.out.println("TODO: auto create diagram");
                                break;
                            }
                            case 2: {
                                aborted = true;
                            }
                        }
                        node = this.getDiagramRootFromExisting(ress, pattern, path);
                    }
                }
                if (this instanceof ObjectMatchingView) {
                    ObjectMatchingView.getPatternCache().put(pattern, node);
                } else if (this instanceof PatternMatchingView) {
                    PatternMatchingView.getPatternCache().put(pattern, node);
                }
            }
            if (this instanceof ObjectMatchingView) {
                node = (HierarchicalNode)EcoreUtil.copy((EObject)ObjectMatchingView.getPatternCache().get(anno.getPattern()));
            } else if (this instanceof PatternMatchingView) {
                node = (HierarchicalNode)EcoreUtil.copy((EObject)PatternMatchingView.getPatternCache().get(anno.getPattern()));
            }
            if (this instanceof ObjectMatchingView) {
                ObjectMatchingView.getAnnotationCache().put(anno, node);
            } else if (this instanceof PatternMatchingView) {
                PatternMatchingView.getAnnotationCache().put(anno, node);
            }
        }
        return node;
    }

    private HierarchicalNode getDiagramRootFromExisting(ResourceSet ress, PSPatternSpecification pattern, String path) {
        URI uri = URI.createPlatformResourceURI((String)path, (boolean)true);
        Resource res = ress.getResource(uri, true);
        if (!res.isLoaded()) {
            try {
                res.load(Collections.emptyMap());
            }
            catch (IOException e) {
                return null;
            }
        }
        for (EObject content : res.getContents()) {
            if (!(content instanceof HierarchicalNode) || !((HierarchicalNode)content).getModel().equals(pattern)) continue;
            return (HierarchicalNode)content;
        }
        return null;
    }

    private MessageDialog getDiagramSelectionDialog(String path, String name) {
        String m = "There is no diagram representation for the Pattern Specification '" + name + "' in the file '" + path + "'.";
        String[] l = new String[]{"Select Another Diagram", "Create Automatically", "Abort"};
        return new MessageDialog(this.getSite().getShell(), "Missing Pattern Specification Diagram", this.getTitleImage(), m, 3, l, 0);
    }

    protected abstract EditPartFactory getEditPartFactory();

    private ScrollingGraphicalViewer getViewer() {
        return this.viewer;
    }

    protected void removeSelection() {
        for (Object part : this.getViewer().getEditPartRegistry().values()) {
            if (!(part instanceof EditPart)) continue;
            ((EditPart)part).setSelected(0);
        }
    }

    protected void selectEditParts(StructuredSelection selection) {
        this.removeSelection();
        for (Object s : selection) {
            if (s instanceof AbstractNodeEditPart) {
                this.addSelection((DiagramElement)((AbstractNodeEditPart)s).getModel());
                continue;
            }
            if (!(s instanceof AbstractEdgeEditPart)) continue;
            this.addSelection((DiagramElement)((AbstractEdgeEditPart)s).getModel());
        }
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (selection == null || selection.isEmpty() || !(selection instanceof StructuredSelection)) {
            return;
        }
        if (part instanceof AbstractMatchingView) {
            this.selectEditParts((StructuredSelection)selection);
            return;
        }
        if (part instanceof AnnotationView) {
            Object selected = ((StructuredSelection)selection).getFirstElement();
            if (selected instanceof ASGAnnotation) {
                this.setContent((ASGAnnotation)selected);
            }
            return;
        }
    }

    private void setContent(ASGAnnotation selected) {
        current = selected;
        this.getViewer().setContents((Object)this.getDiagramRoot(selected));
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    public void newValues(int current, int maximum) {
    }

    public void newAnnotation(ASGAnnotation annotation) {
    }

    public void newState(ProcessConsoleState state) {
    }

    public void init() {
        if (this.viewer != null && !this.viewer.getControl().isDisposed()) {
            this.viewer.setContents(null);
        }
        this.clear();
    }

    protected abstract void clear();
}

