/*
 * Decompiled with CFR 0.152.
 */
package org.reclipse.structure.inference.ui.matching.util;

import java.util.Iterator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.reclipse.structure.inference.annotations.ASGAnnotation;
import org.reclipse.structure.inference.evaluation.SimilarityEvaluator;
import org.reclipse.structure.specification.PSAnnotation;
import org.reclipse.structure.specification.PSAttributeConstraint;
import org.reclipse.structure.specification.PSCombinedFragment;
import org.reclipse.structure.specification.PSFuzzyMetricConstraint;
import org.reclipse.structure.specification.PSFuzzySetRatingConstraint;
import org.reclipse.structure.specification.PSMetricConstraint;
import org.reclipse.structure.specification.PSObject;
import org.reclipse.structure.specification.PSPatternSpecification;
import org.reclipse.structure.specification.PSSpecificationConstraint;
import org.reclipse.structure.specification.util.ModelHelper;

public class SatisfactionUtil {
    private static SimilarityEvaluator evaluator = new SimilarityEvaluator();

    public static String extend(String weightText, String text) {
        StringBuffer buf = new StringBuffer(weightText);
        if (buf.length() > 0) {
            buf.append("\n");
        }
        buf.append(text);
        return buf.toString();
    }

    private static String getSatisfaction(double rank) {
        if (rank == 0.0) {
            return "unsatisfied";
        }
        if (rank == 1.0) {
            return "satisfied";
        }
        return "satisfied=" + SatisfactionUtil.roundedSatisfaction(rank);
    }

    public static String getSatisfaction(PSAnnotation psAnnotation, ASGAnnotation annotation) {
        double rank = !ModelHelper.isCreate((PSAnnotation)psAnnotation) ? evaluator.rank(psAnnotation, annotation) : evaluator.rank(psAnnotation.getType(), annotation);
        return SatisfactionUtil.getSatisfaction(rank);
    }

    public static String getSatisfaction(PSAttributeConstraint attrExprPair, ASGAnnotation annotation) {
        Iterator iterator;
        String key = attrExprPair.getNode().getName();
        if (annotation.getBoundObjects().containsKey((Object)key) && (iterator = ((EList)annotation.getBoundObjects().get((Object)key)).iterator()).hasNext()) {
            EObject element = (EObject)iterator.next();
            double rank = evaluator.rank(attrExprPair, element, annotation);
            return SatisfactionUtil.getSatisfaction(rank);
        }
        return "unsatisfied";
    }

    public static String getSatisfaction(PSCombinedFragment fragment, ASGAnnotation annotation) {
        double rank = evaluator.rank(fragment, annotation);
        return SatisfactionUtil.getSatisfaction(rank);
    }

    public static String getSatisfaction(PSFuzzyMetricConstraint fuzzyExpr, ASGAnnotation annotation) {
        double rank = evaluator.rank(fuzzyExpr, annotation);
        return SatisfactionUtil.getSatisfaction(rank);
    }

    public static String getSatisfaction(PSFuzzySetRatingConstraint fuzzyExpr, ASGAnnotation annotation) {
        return SatisfactionUtil.getSatisfaction(0.0);
    }

    public static String getSatisfaction(PSMetricConstraint metricExpr, ASGAnnotation annotation) {
        double rank = evaluator.rank(metricExpr, annotation);
        return SatisfactionUtil.getSatisfaction(rank);
    }

    public static String getSatisfaction(PSObject psObject, ASGAnnotation annotation) {
        double rank = evaluator.rank(psObject, annotation);
        return SatisfactionUtil.getSatisfaction(rank);
    }

    public static String getSatisfaction(PSSpecificationConstraint constraint, ASGAnnotation annotation) {
        double rank = evaluator.rank(constraint, annotation);
        return SatisfactionUtil.getSatisfaction(rank);
    }

    public static String getWeight(PSAnnotation psAnnotation) {
        double weight = evaluator.weight(psAnnotation);
        return Double.toString(weight);
    }

    public static String getWeight(PSPatternSpecification diagram) {
        double weight = evaluator.weight(diagram);
        return Double.toString(weight);
    }

    private static String roundedSatisfaction(double value) {
        return String.format("%1$#.2f", value);
    }
}

