/*
 * Decompiled with CFR 0.152.
 */
package org.reclipse.structure.inference.ui.matching.handlers;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.handlers.HandlerUtil;
import org.fujaba.commons.edit.parts.AbstractNodeEditPart;
import org.fujaba.commons.notation.DiagramElement;
import org.reclipse.structure.inference.ui.matching.edit.parts.object.MatchingPSObjectEditPart;
import org.reclipse.structure.specification.ModifierType;
import org.reclipse.structure.specification.PSCombinedFragment;
import org.reclipse.structure.specification.PSNode;

public class ToggleSetHandler
extends AbstractHandler {
    private static List<?> getSelection(ExecutionEvent event) {
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (selection.isEmpty() || !(selection instanceof IStructuredSelection)) {
            return Collections.emptyList();
        }
        return ((IStructuredSelection)selection).toList();
    }

    private static boolean isShown(DiagramElement node) {
        String value;
        EAnnotation anno = node.getEAnnotation("http://ns.reclipse.org/structure/inference/ui/matching/objects");
        if (anno == null) {
            anno = EcoreFactory.eINSTANCE.createEAnnotation();
            anno.setSource("http://ns.reclipse.org/structure/inference/ui/matching/objects");
            node.getEAnnotations().add((Object)anno);
        }
        if ((value = (String)anno.getDetails().get((Object)"show_set")) == null) {
            value = Boolean.FALSE.toString();
            anno.getDetails().put((Object)"show_set", (Object)value);
        }
        return Boolean.valueOf(value);
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        HashSet<AbstractNodeEditPart> sets = new HashSet<AbstractNodeEditPart>();
        for (Object selected : ToggleSetHandler.getSelection(event)) {
            if (!(selected instanceof AbstractNodeEditPart)) continue;
            EObject model = ((AbstractNodeEditPart)selected).getRealModel();
            if (model instanceof PSNode && ((PSNode)model).getModifier() == ModifierType.SET) {
                sets.add((AbstractNodeEditPart)selected);
                continue;
            }
            if (!(model instanceof PSCombinedFragment) || ((PSCombinedFragment)model).getKind() != ModifierType.SET) continue;
            sets.add((AbstractNodeEditPart)selected);
        }
        for (AbstractNodeEditPart part : sets) {
            if (ToggleSetHandler.isShown((DiagramElement)part.getModel())) {
                if (!(part instanceof MatchingPSObjectEditPart)) continue;
                ((MatchingPSObjectEditPart)part).closeSet();
                continue;
            }
            if (!(part instanceof MatchingPSObjectEditPart)) continue;
            ((MatchingPSObjectEditPart)part).openSet();
        }
        return null;
    }
}

