/*
 * Decompiled with CFR 0.152.
 */
package org.reclipse.structure.inference.ui.matching.handlers;

import java.util.Collections;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;
import org.fujaba.commons.edit.parts.AbstractEdgeEditPart;
import org.fujaba.commons.edit.parts.AbstractNodeEditPart;
import org.fujaba.commons.notation.HierarchicalNode;
import org.fujaba.commons.notation.Node;
import org.reclipse.structure.inference.ui.matching.views.AbstractMatchingView;

public class CopyLayoutHandler
extends AbstractHandler {
    private static List<?> getSelection(ExecutionEvent event) {
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (selection.isEmpty() || !(selection instanceof IStructuredSelection)) {
            return Collections.emptyList();
        }
        return ((IStructuredSelection)selection).toList();
    }

    private static int getConfirmation(ExecutionEvent event) {
        Shell shell = HandlerUtil.getActiveShell((ExecutionEvent)event);
        String title = "Confirm layout copy";
        Image image = MessageDialog.getDefaultImage();
        String message = "Do you really want to discard the layouts of the other annotations?";
        String[] labels = new String[]{"Copy To All", "Copy To Non-Opened", "Abort"};
        MessageDialog confirmation = new MessageDialog(shell, title, image, message, 5, labels, 0);
        return confirmation.open();
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        HierarchicalNode root = null;
        for (Object selected : CopyLayoutHandler.getSelection(event)) {
            if (selected instanceof AbstractNodeEditPart) {
                Node possible = ((AbstractNodeEditPart)selected).getModel();
                if (possible instanceof HierarchicalNode) {
                    root = (HierarchicalNode)possible;
                    break;
                }
                root = possible.getParent();
                break;
            }
            if (!(selected instanceof AbstractEdgeEditPart)) continue;
            root = ((AbstractEdgeEditPart)selected).getModel().getParent();
            break;
        }
        if (root != null) {
            while (root.getParent() != null) {
                root = root.getParent();
            }
            int result = CopyLayoutHandler.getConfirmation(event);
            if (result == 0) {
                AbstractMatchingView.setLayout(HandlerUtil.getActivePart((ExecutionEvent)event), root, true);
            } else if (result == 1) {
                AbstractMatchingView.setLayout(HandlerUtil.getActivePart((ExecutionEvent)event), root, false);
            }
        }
        return null;
    }
}

