/*
 * Decompiled with CFR 0.152.
 */
package org.reclipse.structure.inference.ui.matching.edit.parts.pattern;

import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.IFigure;
import org.eclipse.gef.EditPolicy;
import org.reclipse.structure.inference.annotations.ASGAnnotation;
import org.reclipse.structure.inference.ui.matching.edit.policies.MatchingSelectionEditPolicy;
import org.reclipse.structure.inference.ui.matching.util.SatisfactionUtil;
import org.reclipse.structure.inference.ui.matching.util.SatisfactionVisualizationUtil;
import org.reclipse.structure.inference.ui.matching.views.PatternMatchingView;
import org.reclipse.structure.specification.ModifierType;
import org.reclipse.structure.specification.PSNode;
import org.reclipse.structure.specification.PSObject;
import org.reclipse.structure.specification.ui.edit.parts.PSObjectEditPart;
import org.reclipse.structure.specification.ui.figures.PSObjectFigure;

public class MatchingPSObjectEditPart
extends PSObjectEditPart {
    protected void refreshVisuals() {
        super.refreshVisuals();
        PSObject model = this.getRealModel();
        PSObjectFigure figure = this.getFigure();
        if (model.getModifier() == ModifierType.ADDITIONAL || SatisfactionVisualizationUtil.isParentDissatisfied(this.getParent())) {
            ASGAnnotation annotation = PatternMatchingView.getCurrent();
            String satisfaction = SatisfactionUtil.getSatisfaction(this.getRealModel(), annotation);
            String tag = "{" + satisfaction + "}";
            String weight = "";
            if (this.getRealModel().getWeight() != 1.0) {
                weight = "{w=" + this.getRealModel().getWeight() + "}";
            }
            figure.setWeightText(SatisfactionUtil.extend(weight, tag));
            SatisfactionVisualizationUtil.setColor((PSNode)model, (IFigure)figure, this.getParent(), satisfaction);
        }
    }

    protected void createEditPolicies() {
        super.createEditPolicies();
        this.installEditPolicy("Selection Feedback", (EditPolicy)new MatchingSelectionEditPolicy((Figure)this.getFigure()));
    }
}

