/*
 * Decompiled with CFR 0.152.
 */
package org.reclipse.structure.inference.ui.matching.edit.parts.pattern;

import org.eclipse.draw2d.IFigure;
import org.fujaba.commons.figures.UMLFragmentFigure;
import org.reclipse.structure.inference.annotations.ASGAnnotation;
import org.reclipse.structure.inference.ui.matching.util.SatisfactionUtil;
import org.reclipse.structure.inference.ui.matching.util.SatisfactionVisualizationUtil;
import org.reclipse.structure.inference.ui.matching.views.PatternMatchingView;
import org.reclipse.structure.specification.PSCombinedFragment;
import org.reclipse.structure.specification.ui.edit.parts.PSCombinedFragmentEditPart;

public class MatchingPSCombinedFragmentEditPart
extends PSCombinedFragmentEditPart {
    private String satisfaction = null;

    public String getSatisfaction() {
        if (this.satisfaction == null) {
            ASGAnnotation annotation = PatternMatchingView.getCurrent();
            this.satisfaction = SatisfactionUtil.getSatisfaction(this.getRealModel(), annotation);
        }
        return this.satisfaction;
    }

    protected void refreshVisuals() {
        super.refreshVisuals();
        PSCombinedFragment model = this.getRealModel();
        UMLFragmentFigure figure = (UMLFragmentFigure)this.getFigure();
        SatisfactionVisualizationUtil.setColor(model, (IFigure)figure, this.getParent(), this.getSatisfaction());
        StringBuilder text = new StringBuilder();
        switch (model.getKind()) {
            case ADDITIONAL: {
                text.append("additional");
                break;
            }
            case NEGATIVE: {
                text.append("negative");
                break;
            }
            case SET: {
                text.append("set");
                figure.setOpaque(false);
                break;
            }
            default: {
                text.append("none");
            }
        }
        if (model.getWeight() != 1.0) {
            figure.setText(text + " {" + this.getSatisfaction() + ", w=" + model.getWeight() + "}");
        } else {
            figure.setText(text + " {" + this.getSatisfaction() + "}");
        }
    }

    public boolean isSatisfied() {
        return !this.getSatisfaction().equals("unsatisfied");
    }
}

