/*
 * Decompiled with CFR 0.152.
 */
package org.reclipse.structure.inference.ui.matching.edit.parts.pattern;

import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.IFigure;
import org.eclipse.gef.EditPolicy;
import org.fujaba.commons.figures.LabelFigure;
import org.reclipse.structure.inference.annotations.ASGAnnotation;
import org.reclipse.structure.inference.ui.matching.edit.policies.MatchingSelectionEditPolicy;
import org.reclipse.structure.inference.ui.matching.util.SatisfactionUtil;
import org.reclipse.structure.inference.ui.matching.util.SatisfactionVisualizationUtil;
import org.reclipse.structure.inference.ui.matching.views.PatternMatchingView;
import org.reclipse.structure.specification.PSAttributeConstraint;
import org.reclipse.structure.specification.PSNodeConstraint;
import org.reclipse.structure.specification.ui.edit.parts.PSAttributeConstraintEditPart;

public class MatchingPSAttributeConstraintEditPart
extends PSAttributeConstraintEditPart {
    protected void refreshVisuals() {
        super.refreshVisuals();
        PSAttributeConstraint model = this.getRealModel();
        LabelFigure figure = this.getFigure();
        ASGAnnotation annotation = PatternMatchingView.getCurrent();
        String satisfaction = SatisfactionUtil.getSatisfaction(model, annotation);
        SatisfactionVisualizationUtil.setColor((PSNodeConstraint)model, (IFigure)figure, this.getParent(), satisfaction);
        figure.setSize(figure.getPreferredSize());
    }

    protected String getBooleanConstraintSuffix() {
        PSAttributeConstraint model = this.getRealModel();
        StringBuilder text = new StringBuilder();
        if (model.isAdditional() || model.getWeight() != 1.0) {
            text.append(" {");
            if (model.isAdditional()) {
                text.append("additional");
            }
            if (model.getWeight() != 1.0) {
                if (model.isAdditional()) {
                    text.append(", ");
                }
                text.append("w=" + model.getWeight());
            }
            ASGAnnotation annotation = PatternMatchingView.getCurrent();
            String satisfaction = SatisfactionUtil.getSatisfaction(this.getRealModel(), annotation);
            text.append(", ");
            text.append(satisfaction);
            text.append("}");
        }
        return text.toString();
    }

    protected void createEditPolicies() {
        super.createEditPolicies();
        this.installEditPolicy("Selection Feedback", (EditPolicy)new MatchingSelectionEditPolicy((Figure)this.getFigure()));
    }
}

