/*
 * Decompiled with CFR 0.152.
 */
package org.reclipse.structure.inference.ui.matching.edit.parts.pattern;

import java.text.DecimalFormat;
import java.util.List;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.IFigure;
import org.eclipse.gef.EditPolicy;
import org.reclipse.structure.inference.annotations.ASGAnnotation;
import org.reclipse.structure.inference.ui.matching.edit.policies.MatchingSelectionEditPolicy;
import org.reclipse.structure.inference.ui.matching.util.SatisfactionUtil;
import org.reclipse.structure.inference.ui.matching.util.SatisfactionVisualizationUtil;
import org.reclipse.structure.inference.ui.matching.views.PatternMatchingView;
import org.reclipse.structure.specification.ModifierType;
import org.reclipse.structure.specification.PSAnnotation;
import org.reclipse.structure.specification.PSNode;
import org.reclipse.structure.specification.ui.edit.parts.PSAnnotationEditPart;
import org.reclipse.structure.specification.ui.figures.PSAnnotationFigure;
import org.reclipse.structure.specification.util.ModelHelper;

public class MatchingPSAnnotationEditPart
extends PSAnnotationEditPart {
    protected void refreshVisuals() {
        super.refreshVisuals();
        PSAnnotation model = this.getRealModel();
        PSAnnotationFigure figure = this.getFigure();
        ASGAnnotation annotation = PatternMatchingView.getCurrent();
        if (model.getModifier() == ModifierType.ADDITIONAL || !model.getParents().isEmpty()) {
            String satisfaction = "";
            if (annotation != null) {
                satisfaction = SatisfactionUtil.getSatisfaction(model, annotation);
            }
            String weight = "?";
            if (ModelHelper.isCreate((PSAnnotation)model)) {
                weight = SatisfactionUtil.getWeight(model.getType());
            } else {
                weight = SatisfactionUtil.getWeight(model);
                SatisfactionVisualizationUtil.setColor((PSNode)model, (IFigure)figure, this.getParent(), satisfaction);
            }
            String tag = "{" + satisfaction + ", total=" + weight + "}";
            figure.setWeightText(SatisfactionUtil.extend(this.getWeightText(), tag));
        } else if (ModifierType.NONE.equals((Object)model.getModifier()) && !ModelHelper.isCreate((PSAnnotation)model)) {
            String name = this.getRealModel().getName();
            List bound = (List)annotation.getBoundObjects().get((Object)name);
            if (bound != null && bound.size() == 1 && bound.get(0) instanceof ASGAnnotation) {
                ASGAnnotation boundAnno = (ASGAnnotation)bound.get(0);
                figure.setWeightText(String.valueOf(new DecimalFormat("0.00").format(boundAnno.getAnnotationRanking())) + " %");
            }
        }
    }

    private String getWeightText() {
        return "weight = " + this.getRealModel().getWeight();
    }

    protected void createEditPolicies() {
        super.createEditPolicies();
        this.installEditPolicy("Selection Feedback", (EditPolicy)new MatchingSelectionEditPolicy((Figure)this.getFigure()));
    }

    public ASGAnnotation getAnnotation() {
        String name = this.getRealModel().getName();
        ASGAnnotation annotation = PatternMatchingView.getCurrent();
        List bound = (List)annotation.getBoundObjects().get((Object)name);
        if (bound != null && bound.size() == 1 && bound.get(0) instanceof ASGAnnotation) {
            return (ASGAnnotation)bound.get(0);
        }
        return null;
    }

    public boolean hasBoundAnnotation() {
        return this.getAnnotation() != null;
    }
}

