/*
 * Decompiled with CFR 0.152.
 */
package org.reclipse.structure.inference.ui.matching.actions;

import java.util.ArrayList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.jface.action.IAction;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.fujaba.commons.edit.parts.AbstractNodeEditPart;
import org.reclipse.structure.inference.ui.matching.actions.AbstractAction;
import org.reclipse.structure.inference.ui.matching.edit.parts.object.MatchingPSPatternSpecificationEditPart;
import org.reclipse.structure.inference.ui.matching.views.ObjectMatchingView;
import org.reclipse.structure.specification.ModifierType;
import org.reclipse.structure.specification.PSAnnotation;
import org.reclipse.structure.specification.PSItem;
import org.reclipse.structure.specification.PSLink;
import org.reclipse.structure.specification.PSNode;
import org.reclipse.structure.specification.PSObject;
import org.reclipse.structure.specification.PSPatternSpecification;
import org.reclipse.structure.specification.SpecificationFactory;

public abstract class OpenSetAction
extends AbstractAction
implements IViewActionDelegate {
    public static final int OPEN = 1;
    public static final int CLOSE = 2;
    public static int state = 1;
    ArrayList<PSItem> objectsInSet = new ArrayList();

    public void run(IAction action) {
        this.openOrCloseObjectSet();
    }

    protected void openOrCloseObjectSet() {
        EditPart psDiagramEditPart;
        EditPart selectedEditPart = this.getSelectedEditParts().get(0);
        PSNode node = (PSNode)((AbstractNodeEditPart)selectedEditPart).getRealModel();
        if (node.getModifier() == ModifierType.SET && (psDiagramEditPart = selectedEditPart.getParent()) instanceof MatchingPSPatternSpecificationEditPart) {
            PSPatternSpecification oDiagram = ((MatchingPSPatternSpecificationEditPart)psDiagramEditPart).getRealModel();
            if (state == 1) {
                this.openObjectSet(node, oDiagram);
            } else if (state == 2) {
                this.closeObjectSet(oDiagram);
            }
        }
    }

    protected void closeObjectSet(PSPatternSpecification oDiagram) {
        for (PSItem obj : this.objectsInSet) {
            if (obj instanceof PSObject) continue;
            boolean cfr_ignored_0 = obj instanceof PSAnnotation;
        }
        this.action.setText("Open Object Set");
        state = 1;
    }

    protected void openObjectSet(PSNode node, PSPatternSpecification oDiagram) {
        this.displayNewObjects(node, oDiagram);
        this.action.setText("Close Object Set");
        state = 2;
    }

    protected void displayNewObjects(PSNode node, PSPatternSpecification oDiagram) {
        for (EObject element : (EList)ObjectMatchingView.getCurrent().getBoundObjects().get((Object)node.getName())) {
            PSNode newObject = this.createNewObject(node, element);
            this.addToDiagram(node, element, newObject, oDiagram);
        }
    }

    protected abstract PSNode createNewObject(PSNode var1, EObject var2);

    protected void addToDiagram(PSNode node, EObject object, PSNode newObject, PSPatternSpecification oDiagram) {
        PSLink newLink = SpecificationFactory.eINSTANCE.createPSLink();
        newLink.setName(node.getName());
        newLink.setSource(node);
        newLink.setTarget(newObject);
        this.objectsInSet.add((PSItem)newObject);
        this.objectsInSet.add((PSItem)newLink);
    }

    public void init(IViewPart view) {
    }
}

