/*
 * Decompiled with CFR 0.152.
 */
package org.reclipse.structure.inference.ui.matching.actions;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IActionDelegate;

public abstract class AbstractAction
implements IActionDelegate {
    protected ISelection selection;
    protected IAction action;

    protected ISelection getSelection() {
        return this.selection;
    }

    public IAction getAction() {
        return this.action;
    }

    protected List<EditPart> getSelectedEditParts() {
        LinkedList<EditPart> result = new LinkedList<EditPart>();
        if (!this.getSelection().isEmpty() && this.getSelection() instanceof StructuredSelection) {
            StructuredSelection sel = (StructuredSelection)this.getSelection();
            for (Object obj : sel) {
                if (!(obj instanceof EditPart)) continue;
                result.add((EditPart)obj);
            }
        }
        return result;
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.action = action;
        this.selection = selection;
        this.handleSelectionChanged();
    }

    protected void handleSelectionChanged() {
        this.refresh();
    }

    protected void refresh() {
        this.action.setEnabled(this.calculateEnabled());
    }

    protected CommandStack getCommandStack() {
        List<EditPart> selected = this.getSelectedEditParts();
        if (!selected.isEmpty()) {
            return selected.get(0).getRoot().getViewer().getEditDomain().getCommandStack();
        }
        return null;
    }

    protected boolean calculateEnabled() {
        return this.checkEnabledFor(this.getSelectedEditParts());
    }

    protected boolean checkEnabledFor(List<EditPart> editparts) {
        for (EditPart editPart : editparts) {
            if (this.checkEnabledFor(editPart)) continue;
            return false;
        }
        return true;
    }

    protected boolean checkEnabledFor(EditPart editpart) {
        return true;
    }
}

