/*
 * Decompiled with CFR 0.152.
 */
package org.reclipse.structure.generator.util.more;

import java.util.Map;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.EReference;
import org.reclipse.structure.generator.util.ExpressionsUtil;
import org.reclipse.structure.generator.util.IGenerator;
import org.reclipse.structure.generator.util.StorydrivenUtil;
import org.reclipse.structure.generator.util.more.Counter;
import org.reclipse.structure.generator.util.more.ExprUtil;
import org.reclipse.structure.inference.annotations.AnnotationsPackage;
import org.reclipse.structure.specification.ModifierType;
import org.reclipse.structure.specification.OperatorType;
import org.reclipse.structure.specification.PSAnnotation;
import org.reclipse.structure.specification.PSAttributeConstraint;
import org.reclipse.structure.specification.PSBooleanConstraint;
import org.reclipse.structure.specification.PSConnection;
import org.reclipse.structure.specification.PSLink;
import org.reclipse.structure.specification.PSMetricConstraint;
import org.reclipse.structure.specification.PSNode;
import org.reclipse.structure.specification.PSNodeConstraint;
import org.reclipse.structure.specification.PSObject;
import org.reclipse.structure.specification.PSPath;
import org.reclipse.structure.specification.util.ModelHelper;
import org.storydriven.core.expressions.Expression;
import org.storydriven.core.expressions.TextualExpression;
import org.storydriven.core.expressions.common.CommonExpressionsFactory;
import org.storydriven.core.expressions.common.ComparisonExpression;
import org.storydriven.core.expressions.common.LiteralExpression;
import org.storydriven.storydiagrams.activities.ActivitiesFactory;
import org.storydriven.storydiagrams.activities.Activity;
import org.storydriven.storydiagrams.activities.ActivityCallNode;
import org.storydriven.storydiagrams.activities.ActivityEdge;
import org.storydriven.storydiagrams.activities.ActivityNode;
import org.storydriven.storydiagrams.activities.EdgeGuard;
import org.storydriven.storydiagrams.activities.JunctionNode;
import org.storydriven.storydiagrams.calls.Callable;
import org.storydriven.storydiagrams.calls.CallsFactory;
import org.storydriven.storydiagrams.calls.Invocation;
import org.storydriven.storydiagrams.calls.ParameterBinding;
import org.storydriven.storydiagrams.expressions.pathExpressions.ImplicitPathDescription;
import org.storydriven.storydiagrams.expressions.pathExpressions.ImplicitPathKind;
import org.storydriven.storydiagrams.expressions.pathExpressions.Path;
import org.storydriven.storydiagrams.expressions.pathExpressions.PathExpression;
import org.storydriven.storydiagrams.expressions.pathExpressions.PathExpressionsFactory;
import org.storydriven.storydiagrams.expressions.pathExpressions.PathSegment;
import org.storydriven.storydiagrams.expressions.pathExpressions.RepeatOperator;
import org.storydriven.storydiagrams.expressions.pathExpressions.RestrictionList;
import org.storydriven.storydiagrams.expressions.pathExpressions.TypeRestriction;
import org.storydriven.storydiagrams.expressions.pathbridge.PathExpressionBridge;
import org.storydriven.storydiagrams.expressions.pathbridge.PathbridgeFactory;
import org.storydriven.storydiagrams.patterns.AbstractLinkVariable;
import org.storydriven.storydiagrams.patterns.AbstractVariable;
import org.storydriven.storydiagrams.patterns.AttributeAssignment;
import org.storydriven.storydiagrams.patterns.BindingOperator;
import org.storydriven.storydiagrams.patterns.BindingSemantics;
import org.storydriven.storydiagrams.patterns.BindingState;
import org.storydriven.storydiagrams.patterns.CollectionVariable;
import org.storydriven.storydiagrams.patterns.Constraint;
import org.storydriven.storydiagrams.patterns.LinkVariable;
import org.storydriven.storydiagrams.patterns.ObjectVariable;
import org.storydriven.storydiagrams.patterns.PatternsFactory;
import org.storydriven.storydiagrams.patterns.PrimitiveVariable;
import org.storydriven.storydiagrams.patterns.StoryPattern;
import org.storydriven.storydiagrams.patterns.expressions.AttributeValueExpression;
import org.storydriven.storydiagrams.patterns.expressions.CollectionSizeExpression;
import org.storydriven.storydiagrams.patterns.expressions.ObjectVariableExpression;
import org.storydriven.storydiagrams.patterns.expressions.PatternsExpressionsFactory;

public abstract class SDMUtil {
    public static LinkVariable createLink(ObjectVariable source, ObjectVariable target, EReference instanceOf, String role, boolean create, BindingSemantics type, StoryPattern storyPattern) {
        LinkVariable link = PatternsFactory.eINSTANCE.createLinkVariable();
        link.setTargetEnd(instanceOf);
        if (instanceOf.getEOpposite() != null) {
            link.setSourceEnd(instanceOf.getEOpposite());
        }
        link = (LinkVariable)SDMUtil.configureAbstractLinkVariable(source, target, role, create, type, storyPattern, (AbstractLinkVariable)link);
        if (role != null) {
            link.setQualifierExpression(SDMUtil.createQualifierExpression(role));
        }
        return link;
    }

    public static org.storydriven.storydiagrams.patterns.Path createPath(PSPath psPath, ObjectVariable source, ObjectVariable target, StoryPattern storyPattern) {
        org.storydriven.storydiagrams.patterns.Path path = PatternsFactory.eINSTANCE.createPath();
        psPath.getTabooClasses();
        PathExpressionBridge bridge = PathbridgeFactory.eINSTANCE.createPathExpressionBridge();
        PathExpression expr = PathExpressionsFactory.eINSTANCE.createPathExpression();
        Path pathAlternative = PathExpressionsFactory.eINSTANCE.createPath();
        PathSegment segment = PathExpressionsFactory.eINSTANCE.createPathSegment();
        ImplicitPathDescription desc = PathExpressionsFactory.eINSTANCE.createImplicitPathDescription();
        path.setPathExpression((Expression)bridge);
        bridge.setPathExpression(expr);
        expr.getPathAlternatives().add((Object)pathAlternative);
        pathAlternative.getSegments().add((Object)segment);
        segment.setRepeatOperator(RepeatOperator.ARBITRARY);
        segment.getAlternatives().add((Object)desc);
        desc.setKind(ImplicitPathKind.CONTAINMENT_SOURCE);
        RestrictionList restrictions = PathExpressionsFactory.eINSTANCE.createRestrictionList();
        for (EClass taboo : psPath.getTabooClasses()) {
            TypeRestriction restriction = PathExpressionsFactory.eINSTANCE.createTypeRestriction();
            restriction.setTypeName(taboo.getName());
            restriction.setForbidden(true);
            restrictions.getRestrictions().add((Object)restriction);
        }
        desc.setRestrictionList(restrictions);
        return (org.storydriven.storydiagrams.patterns.Path)SDMUtil.configureAbstractLinkVariable(source, target, null, false, BindingSemantics.MANDATORY, storyPattern, (AbstractLinkVariable)path);
    }

    private static AbstractLinkVariable configureAbstractLinkVariable(ObjectVariable source, ObjectVariable target, String role, boolean create, BindingSemantics type, StoryPattern storyPattern, AbstractLinkVariable link) {
        link.setSource(source);
        link.setTarget((AbstractVariable)target);
        if (!"".equals(role)) {
            link.setName(role);
        }
        if (create) {
            link.setBindingOperator(BindingOperator.CREATE);
        }
        link.setBindingSemantics(type);
        storyPattern.getLinkVariables().add((Object)link);
        return link;
    }

    private static Expression createQualifierExpression(String qualifier) {
        return ExpressionsUtil.createQualifierExpression(qualifier);
    }

    public static Constraint createConstraint(String constraintText, StoryPattern storyPattern) {
        return SDMUtil.createConstraint((Expression)SDMUtil.createTextualExpression(constraintText), storyPattern);
    }

    private static Constraint createConstraint(Expression constraintExpression, StoryPattern storyPattern) {
        Constraint cons = PatternsFactory.eINSTANCE.createConstraint();
        cons.setPattern(storyPattern);
        cons.setConstraintExpression(constraintExpression);
        return cons;
    }

    private static TextualExpression createTextualExpression(String constraintText) {
        return ExprUtil.textual(constraintText, "OCL", null);
    }

    public static ParameterBinding createParameterBinding(EParameter methodParam, ObjectVariable objectValue, Invocation invocation) {
        ParameterBinding binding = SDMUtil.createParameterBinding(methodParam, objectValue);
        binding.setInvocation(invocation);
        return binding;
    }

    private static ParameterBinding createParameterBinding(EParameter methodParam, ObjectVariable objectValue) {
        ObjectVariableExpression oExpr = PatternsExpressionsFactory.eINSTANCE.createObjectVariableExpression();
        oExpr.setObject(objectValue);
        return SDMUtil.createParameterBinding(methodParam, (Expression)oExpr);
    }

    private static ParameterBinding createParameterBinding(EParameter methodParam, Expression valueExpression) {
        ParameterBinding paramBinding = CallsFactory.eINSTANCE.createParameterBinding();
        paramBinding.setValueExpression(valueExpression);
        paramBinding.setParameter(methodParam);
        return paramBinding;
    }

    public static ObjectVariable createAnnotationResultSetObject(StoryPattern pattern, boolean bound, boolean create) {
        ObjectVariable setObject = PatternsFactory.eINSTANCE.createObjectVariable();
        setObject.setClassifier(SDMUtil.getAnnotationSetClass());
        setObject.setName("annotationResultSet");
        if (bound) {
            setObject.setBindingState(BindingState.BOUND);
        } else {
            setObject.setBindingState(BindingState.UNBOUND);
        }
        if (create) {
            setObject.setBindingOperator(BindingOperator.CREATE);
        }
        pattern.getVariables().add((Object)setObject);
        return setObject;
    }

    public static EClass getAnnotationSetClass() {
        return AnnotationsPackage.eINSTANCE.getAnnotationSet();
    }

    public static ActivityEdge createTransitionNoneGuarded(ActivityNode sourceActivity, ActivityNode targetActivity, Activity activity) {
        return SDMUtil.createTransition(sourceActivity, targetActivity, EdgeGuard.NONE, null, activity);
    }

    public static ActivityEdge createTransition(ActivityNode sourceActivity, ActivityNode targetActivity, EdgeGuard type, Activity activity) {
        return SDMUtil.createTransition(sourceActivity, targetActivity, type, null, activity);
    }

    private static ActivityEdge createTransition(ActivityNode sourceActivity, ActivityNode targetActivity, EdgeGuard type, Expression expression, Activity activity) {
        ActivityEdge edge = ActivitiesFactory.eINSTANCE.createActivityEdge();
        edge.setSource(sourceActivity);
        edge.setTarget(targetActivity);
        edge.setGuardExpression(expression);
        if (type == null) {
            edge.setGuard(EdgeGuard.NONE);
        } else {
            edge.setGuard(type);
        }
        activity.getOwnedActivityEdges().add((Object)edge);
        return edge;
    }

    public static ObjectVariable createAnnotationObject(PSAnnotation annotation, EClass objectType, boolean bound, boolean create, StoryPattern storyPattern, Map<PSNode, ObjectVariable> storyItems, Counter counter) {
        ObjectVariable object = SDMUtil.createTypedObject(objectType, (PSNode)annotation);
        if (ModelHelper.isCreate((PSAnnotation)annotation)) {
            object.setName(StorydrivenUtil.getValidName(annotation.getPatternSpecification(), "annotation"));
        } else if (bound) {
            object.setName(annotation.getName());
        } else {
            String annoName = annotation.getName();
            if (annoName == null || annoName.trim().length() == 0) {
                object.setName(StorydrivenUtil.getValidName(annotation.getPatternSpecification(), "annotation"));
            } else {
                object.setName(annoName);
            }
        }
        if (create) {
            object.setBindingOperator(BindingOperator.CREATE);
        }
        if (bound) {
            object.setBindingState(BindingState.BOUND);
        }
        if (storyItems != null) {
            storyItems.put((PSNode)annotation, object);
        }
        storyPattern.getVariables().add((Object)object);
        return object;
    }

    public static ObjectVariable createObject(PSObject psObject, boolean bound, boolean addNodeExpressions, StoryPattern storyPattern, Map<PSNode, ObjectVariable> storyItems, Counter counter) {
        EClass eClass = psObject.getInstanceOf();
        ObjectVariable object = SDMUtil.createTypedObject(eClass, (PSNode)psObject);
        String name = psObject.getName();
        if (name == null || name.trim().equals("")) {
            if (bound) {
                ObjectVariable lastObject = storyItems.get(psObject);
                if (lastObject != null) {
                    name = lastObject.getName();
                }
            } else {
                name = String.valueOf(psObject.getInstanceOf().getName()) + counter.incCounter();
                if (name.length() != 0) {
                    StringBuffer newBuf = new StringBuffer(name);
                    newBuf.setCharAt(0, Character.toLowerCase(newBuf.charAt(0)));
                    name = newBuf.toString();
                }
            }
        }
        object.setName(name);
        if (bound) {
            object.setBindingState(BindingState.BOUND);
        }
        storyItems.put((PSNode)psObject, object);
        if (!bound && addNodeExpressions) {
            for (PSNodeConstraint psNodeConstraint : psObject.getNodeConstraints()) {
                if (!(psNodeConstraint instanceof PSBooleanConstraint) || ((PSBooleanConstraint)psNodeConstraint).isAdditional()) continue;
                if (psNodeConstraint instanceof PSAttributeConstraint) {
                    SDMUtil.createAttributeExpression((PSAttributeConstraint)psNodeConstraint, object);
                    continue;
                }
                if (!(psNodeConstraint instanceof PSMetricConstraint)) continue;
                SDMUtil.createMetricExpression((PSMetricConstraint)psNodeConstraint, object);
            }
        }
        storyPattern.getVariables().add((Object)object);
        return object;
    }

    private static ObjectVariable createTypedObject(EClass type, PSNode node) {
        Object object = null;
        object = node.getModifier() == ModifierType.SET ? PatternsFactory.eINSTANCE.createCollectionVariable() : PatternsFactory.eINSTANCE.createObjectVariable();
        object.setClassifier(type);
        if (node.getModifier() == ModifierType.ADDITIONAL) {
            object.setBindingSemantics(BindingSemantics.OPTIONAL);
        } else if (node.getModifier() == ModifierType.NEGATIVE) {
            object.setBindingSemantics(BindingSemantics.NEGATIVE);
        }
        return object;
    }

    public static ObjectVariable createObject(EClass type, String name, boolean bound, boolean create, StoryPattern parent) {
        ObjectVariable object = PatternsFactory.eINSTANCE.createObjectVariable();
        object.setClassifier(type);
        if (create) {
            object.setBindingOperator(BindingOperator.CREATE);
        } else {
            object.setBindingOperator(BindingOperator.CHECK_ONLY);
        }
        return (ObjectVariable)SDMUtil.configureAbstractVariable(name, bound, parent, (AbstractVariable)object);
    }

    public static PrimitiveVariable createPrimitiveObject(EDataType type, String name, boolean create, StoryPattern parent) {
        PrimitiveVariable var = PatternsFactory.eINSTANCE.createPrimitiveVariable();
        var.setClassifier(type);
        return (PrimitiveVariable)SDMUtil.configureAbstractVariable(name, false, parent, (AbstractVariable)var);
    }

    private static AbstractVariable configureAbstractVariable(String name, boolean bound, StoryPattern parent, AbstractVariable object) {
        object.setName(name);
        if (bound) {
            object.setBindingState(BindingState.BOUND);
        }
        parent.getVariables().add((Object)object);
        return object;
    }

    public static Constraint createAttributeExpression(PSAttributeConstraint constraint, ObjectVariable object) {
        Constraint cons = PatternsFactory.eINSTANCE.createConstraint();
        cons.setObjectVariable((AbstractVariable)object);
        AttributeValueExpression attrExpr = PatternsExpressionsFactory.eINSTANCE.createAttributeValueExpression();
        attrExpr.setObject(object);
        attrExpr.setAttribute(constraint.getAttribute());
        String valueExpr = constraint.getValueExpression();
        LiteralExpression litExpr = CommonExpressionsFactory.eINSTANCE.createLiteralExpression();
        litExpr.setValue(valueExpr);
        OperatorType op = constraint.getOperator();
        ComparisonExpression compExpr = SDMUtil.createComparingExpression((Expression)attrExpr, op, (Expression)litExpr);
        cons.setConstraintExpression((Expression)compExpr);
        object.getConstraints().add((Object)cons);
        return cons;
    }

    public static Constraint createMetricExpression(PSMetricConstraint metricConstraint, ObjectVariable object) {
        if ("SIZE".equals(metricConstraint.getMetricAcronym()) && object instanceof CollectionVariable) {
            return SDMUtil.createSetConstraint(metricConstraint, (CollectionVariable)object);
        }
        return null;
    }

    private static Constraint createSetConstraint(PSMetricConstraint nodeConstraint, CollectionVariable theSet) {
        Constraint cons = PatternsFactory.eINSTANCE.createConstraint();
        cons.setObjectVariable((AbstractVariable)theSet);
        CollectionSizeExpression setSizeExr = PatternsExpressionsFactory.eINSTANCE.createCollectionSizeExpression();
        setSizeExr.setSet(theSet);
        String valueExpr = nodeConstraint.getValueExpression();
        LiteralExpression litExpr = CommonExpressionsFactory.eINSTANCE.createLiteralExpression();
        litExpr.setValue(valueExpr);
        ComparisonExpression compExpr = SDMUtil.createComparingExpression((Expression)setSizeExr, nodeConstraint.getOperator(), (Expression)litExpr);
        cons.setConstraintExpression((Expression)compExpr);
        theSet.getConstraints().add((Object)cons);
        return cons;
    }

    public static ComparisonExpression createComparingExpression(Expression left, OperatorType op, Expression right) {
        if (op.equals((Object)OperatorType.EQUAL)) {
            return ExprUtil.equal(left, right);
        }
        if (op.equals((Object)OperatorType.UNEQUAL)) {
            return ExprUtil.unequal(left, right);
        }
        if (op.equals((Object)OperatorType.GREATER)) {
            return ExprUtil.greater(left, right);
        }
        if (op.equals((Object)OperatorType.GREATER_OR_EQUAL)) {
            return ExprUtil.greaterOrEqual(left, right);
        }
        if (op.equals((Object)OperatorType.LESS)) {
            return ExprUtil.less(left, right);
        }
        if (op.equals((Object)OperatorType.LESS_OR_EQUAL)) {
            return ExprUtil.lessOrEqual(left, right);
        }
        if (op.equals((Object)OperatorType.REGULAR_EXPRESSION)) {
            return ExprUtil.regularExpression(left, right);
        }
        return null;
    }

    public static LinkVariable createBoundObjectsLink(ObjectVariable annotationObject, ObjectVariable boundObject, PSNode boundObjectsNode, boolean create, StoryPattern storyPattern) {
        EReference boundObjectsRef = AnnotationsPackage.eINSTANCE.getASGAnnotation_BoundObjects();
        String name = boundObjectsNode.getName();
        LinkVariable link = SDMUtil.createLink(annotationObject, boundObject, boundObjectsRef, name, create, BindingSemantics.MANDATORY, storyPattern);
        return link;
    }

    public static LinkVariable createAnnotationResultSetLink(ObjectVariable source, ObjectVariable target, boolean create, StoryPattern storyPattern) {
        EReference ref = AnnotationsPackage.eINSTANCE.getAnnotationSet_Annotations();
        return SDMUtil.createLink(source, target, ref, null, create, BindingSemantics.MANDATORY, storyPattern);
    }

    public static ObjectVariable createObject(PSNode node, boolean bound, boolean addNodeExpressions, StoryPattern storyPattern, Map<PSNode, ObjectVariable> storyItems, Counter counter, IGenerator generator) {
        ObjectVariable object = null;
        if (node instanceof PSAnnotation) {
            PSAnnotation anno = (PSAnnotation)node;
            EClass annoType = generator.getAnnotationClass(anno.getType());
            object = SDMUtil.createAnnotationObject(anno, annoType, bound, addNodeExpressions, storyPattern, storyItems, counter);
        } else {
            object = SDMUtil.createObject((PSObject)node, bound, addNodeExpressions, storyPattern, storyItems, counter);
        }
        return object;
    }

    public static void configureTrigger(ObjectVariable triggerObject, PSNode trigger, StoryPattern storyPattern) {
        if (!(triggerObject instanceof CollectionVariable)) {
            triggerObject.setBindingState(BindingState.BOUND);
        } else {
            PSLink psLink;
            ObjectVariable nonSetTriggerObject = SDMUtil.createObject(triggerObject.getClassifier(), triggerObject.getName(), false, true, triggerObject.getPattern());
            nonSetTriggerObject.setBindingSemantics(BindingSemantics.MANDATORY);
            nonSetTriggerObject.setBindingState(BindingState.BOUND);
            if (nonSetTriggerObject.getName().equals(triggerObject.getName())) {
                nonSetTriggerObject.setName(String.valueOf(nonSetTriggerObject.getName()) + "NonSetTrigger");
            }
            for (PSConnection connection : trigger.getOutgoing()) {
                if (!(connection instanceof PSLink) || ModelHelper.isCreate((PSLink)(psLink = (PSLink)connection))) continue;
                SDMUtil.createLink(nonSetTriggerObject, triggerObject, psLink.getInstanceOf(), psLink.getName(), false, BindingSemantics.MANDATORY, storyPattern);
            }
            for (PSConnection connection : trigger.getOutgoing()) {
                if (!(connection instanceof PSLink) || ModelHelper.isCreate((PSLink)(psLink = (PSLink)connection))) continue;
                SDMUtil.createLink(triggerObject, nonSetTriggerObject, psLink.getInstanceOf(), psLink.getName(), false, BindingSemantics.MANDATORY, storyPattern);
            }
            SDMUtil.createConstraint("maybe " + triggerObject.getName() + " == " + nonSetTriggerObject.getName(), storyPattern);
        }
    }

    public static ObjectVariable createSetResultSetObject(StoryPattern pattern, boolean bound, boolean create) {
        ObjectVariable object = PatternsFactory.eINSTANCE.createObjectVariable();
        object.setClassifier(AnnotationsPackage.Literals.SET_RESULT_SET);
        object.setName("setResult");
        if (bound) {
            object.setBindingState(BindingState.BOUND);
        }
        if (create) {
            object.setBindingOperator(BindingOperator.CREATE);
        }
        pattern.getVariables().add((Object)object);
        return object;
    }

    public static ActivityCallNode createActivityCallNode(Activity owner, Activity callActivity) {
        ActivityCallNode activity = ActivitiesFactory.eINSTANCE.createActivityCallNode();
        activity.setOwningActivity(owner);
        activity.setCallee((Callable)owner);
        activity.getCalledActivities().add((Object)callActivity);
        return activity;
    }

    public static ObjectVariable createTemporaryAnnotationObject(StoryPattern storyPattern, boolean bound, boolean create) {
        ObjectVariable tempObject = PatternsFactory.eINSTANCE.createObjectVariable();
        tempObject.setName("annotation");
        tempObject.setClassifier(AnnotationsPackage.Literals.ASG_ANNOTATION);
        if (bound) {
            tempObject.setBindingState(BindingState.BOUND);
        }
        if (create) {
            tempObject.setBindingOperator(BindingOperator.CREATE);
        }
        storyPattern.getVariables().add((Object)tempObject);
        return tempObject;
    }

    public static JunctionNode createNopActivity(Activity activity) {
        JunctionNode node = ActivitiesFactory.eINSTANCE.createJunctionNode();
        activity.getOwnedActivityNodes().add((Object)node);
        return node;
    }

    public static LinkVariable createSetInstanceAnnotationResultSetLink(ObjectVariable annotationResultSet, ObjectVariable annotationObject, boolean create, StoryPattern storyPattern) {
        return SDMUtil.createLink(annotationResultSet, annotationObject, AnnotationsPackage.eINSTANCE.getAnnotationSet_Annotations(), null, create, BindingSemantics.MANDATORY, storyPattern);
    }

    public static ObjectVariable addNodeToStoryPattern(StoryPattern storyPattern, PSNode node, Map<PSNode, ObjectVariable> storyItems, Counter counter, IGenerator generator) {
        ObjectVariable object = null;
        if (node instanceof PSAnnotation) {
            PSAnnotation anno = (PSAnnotation)node;
            EClass annoType = generator.getAnnotationClass(anno.getType());
            object = SDMUtil.createAnnotationObject((PSAnnotation)node, annoType, false, false, storyPattern, storyItems, counter);
        } else if (node instanceof PSObject) {
            object = SDMUtil.createObject((PSObject)node, false, true, storyPattern, storyItems, counter);
        }
        if (ModelHelper.isAnnotated((PSNode)node) && ModelHelper.isSearchForThisOptional((PSNode)node) && node.getModifier() != ModifierType.SET && object != null) {
            object.setBindingSemantics(BindingSemantics.OPTIONAL);
        }
        if (object != null && object instanceof CollectionVariable) {
            for (PSNodeConstraint psNodeConstraint : node.getNodeConstraints()) {
                if (!(psNodeConstraint instanceof PSMetricConstraint) || ((PSMetricConstraint)psNodeConstraint).isAdditional() || !"SIZE".equals(((PSMetricConstraint)psNodeConstraint).getMetricAcronym())) continue;
                Constraint constraint = SDMUtil.createMetricExpression((PSMetricConstraint)psNodeConstraint, object);
                storyPattern.getConstraints().add((Object)constraint);
            }
        }
        return object;
    }

    public static AbstractVariable findVariableByName(StoryPattern pattern, String name) {
        if (name == null || pattern == null) {
            return null;
        }
        for (AbstractVariable variable : pattern.getVariables()) {
            if (!name.equals(variable.getName())) continue;
            return variable;
        }
        return null;
    }

    public static AttributeAssignment createAttributeAssignment(ObjectVariable owner, EAttribute attribute, Expression value) {
        AttributeAssignment assignment = PatternsFactory.eINSTANCE.createAttributeAssignment();
        assignment.setObjectVariable(owner);
        assignment.setAttribute(attribute);
        assignment.setValueExpression(value);
        return assignment;
    }
}

