/*
 * Decompiled with CFR 0.152.
 */
package org.reclipse.structure.generator.util;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EGenericType;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.ETypeParameter;
import org.fujaba.commons.identifier.Identifier;
import org.storydriven.core.NamedElement;

public final class NameUtil {
    private static void append(StringBuilder result, EClass eClass) {
        int count;
        int i;
        if (eClass.getName() != null) {
            result.append(eClass.getName());
        }
        if (!eClass.getETypeParameters().isEmpty()) {
            result.append("<");
            i = 1;
            count = eClass.getETypeParameters().size();
            for (ETypeParameter eTypeParameter : eClass.getETypeParameters()) {
                NameUtil.append(result, eTypeParameter);
                if (i >= count) continue;
                result.append(", ");
            }
            result.append(">");
        }
        if (!eClass.getEGenericSuperTypes().isEmpty()) {
            result.append(" -> ");
            i = 1;
            count = eClass.getEGenericSuperTypes().size();
            for (EGenericType eGenericSuperType : eClass.getEGenericSuperTypes()) {
                NameUtil.append(result, eGenericSuperType);
                if (i >= count) continue;
                result.append(", ");
            }
        }
        if (eClass.getInstanceTypeName() != null) {
            result.append(" [");
            result.append(eClass.getInstanceTypeName());
            result.append("]");
        }
    }

    private static void append(StringBuilder builder, EGenericType element) {
        EGenericType eGenericType = element;
        ETypeParameter eTypeParameter = eGenericType.getETypeParameter();
        if (eTypeParameter != null) {
            builder.append(eTypeParameter.getName());
            return;
        }
        EClassifier eClassifier = eGenericType.getEClassifier();
        if (eClassifier != null) {
            EList eTypeArguments = eGenericType.getETypeArguments();
            if (eTypeArguments.isEmpty()) {
                builder.append(eClassifier.getName());
                return;
            }
            builder.append(eClassifier.getName());
            builder.append('<');
            int index = 1;
            int count = eTypeArguments.size();
            for (EGenericType eGenericType2 : eTypeArguments) {
                NameUtil.append(builder, eGenericType2);
                if (index >= count) break;
                builder.append(", ");
            }
        } else {
            EGenericType eUpperBound = eGenericType.getEUpperBound();
            if (eUpperBound != null) {
                builder.append("? extends ");
                NameUtil.append(builder, eUpperBound);
                return;
            }
            EGenericType eLowerBound = eGenericType.getELowerBound();
            if (eLowerBound != null) {
                builder.append("? super ");
                NameUtil.append(builder, eLowerBound);
                return;
            }
            builder.append("?");
            return;
        }
        builder.append('>');
    }

    private static void append(StringBuilder result, EOperation eOperation) {
        int count;
        int index;
        result.append(eOperation.getName());
        if (!eOperation.getETypeParameters().isEmpty()) {
            index = 1;
            count = eOperation.getETypeParameters().size();
            result.append("<");
            for (ETypeParameter parameter : eOperation.getETypeParameters()) {
                NameUtil.append(result, parameter);
                if (index < count) {
                    result.append(", ");
                }
                ++index;
            }
            result.append(">");
        }
        result.append("(");
        index = 1;
        count = eOperation.getEParameters().size();
        for (ETypeParameter parameter : eOperation.getEParameters()) {
            if (parameter.getEGenericType() == null) continue;
            NameUtil.append(result, parameter.getEGenericType());
            if (index < count) {
                result.append(", ");
            }
            ++index;
        }
        result.append(")");
        if (eOperation.getEGenericType() != null) {
            result.append(" : ");
            NameUtil.append(result, eOperation.getEGenericType());
        }
        if (!eOperation.getEGenericExceptions().isEmpty()) {
            result.append(" throws ");
            index = 1;
            count = eOperation.getEGenericExceptions().size();
            for (EGenericType eException : eOperation.getEGenericExceptions()) {
                NameUtil.append(result, eException);
                if (index >= count) continue;
                result.append(", ");
            }
        }
    }

    private static void append(StringBuilder result, ETypeParameter parameter) {
        result.append(parameter.getName());
    }

    public static String getName(EClass element) {
        StringBuilder result = new StringBuilder();
        NameUtil.append(result, element);
        return result.toString();
    }

    public static String getName(ENamedElement element) {
        return element.getName();
    }

    public static String getName(EOperation element) {
        StringBuilder result = new StringBuilder();
        NameUtil.append(result, element);
        return result.toString();
    }

    public static String getName(Identifier element) {
        return element.getName();
    }

    public static String getName(NamedElement element) {
        return element.getName();
    }

    public static String getName(Object element) {
        return String.valueOf(element);
    }

    private NameUtil() {
    }
}

