/*
 * Decompiled with CFR 0.152.
 */
package org.reclipse.structure.generator.util;

import org.eclipse.emf.ecore.EParameter;
import org.reclipse.structure.specification.PSAttributeConstraint;
import org.reclipse.structure.specification.PSLink;
import org.reclipse.structure.specification.PSMetricConstraint;
import org.storydriven.core.expressions.Expression;
import org.storydriven.core.expressions.ExpressionsFactory;
import org.storydriven.core.expressions.TextualExpression;
import org.storydriven.core.expressions.common.CommonExpressionsFactory;
import org.storydriven.storydiagrams.activities.Activity;
import org.storydriven.storydiagrams.calls.CallsFactory;
import org.storydriven.storydiagrams.calls.ParameterExtension;
import org.storydriven.storydiagrams.calls.expressions.CallsExpressionsFactory;
import org.storydriven.storydiagrams.calls.expressions.ParameterExpression;
import org.storydriven.storydiagrams.patterns.ObjectVariable;
import org.storydriven.storydiagrams.patterns.PrimitiveVariable;
import org.storydriven.storydiagrams.patterns.expressions.PatternsExpressionsFactory;

public final class ExpressionsUtil {
    private static final PatternsExpressionsFactory PATTERNS_FACTORY = PatternsExpressionsFactory.eINSTANCE;
    private static final CallsExpressionsFactory CALLS_FACTORY = CallsExpressionsFactory.eINSTANCE;
    private static final ExpressionsFactory BASE_FACTORY = ExpressionsFactory.eINSTANCE;
    private static final CommonExpressionsFactory COMMON_FACTORY = CommonExpressionsFactory.eINSTANCE;
    private static final boolean USE_ONLY_OCL_EXPRESSIONS = true;

    private ExpressionsUtil() {
    }

    public static Expression getContextBindingExpression(Activity activity) {
        for (EParameter param : activity.getInParameters()) {
            if (!"element".equals(param.getName())) continue;
            ParameterExtension extension = CallsFactory.eINSTANCE.createParameterExtension();
            extension.setParameter(param);
            ParameterExpression element = CallsExpressionsFactory.eINSTANCE.createParameterExpression();
            element.setParameter(extension);
            return element;
        }
        return null;
    }

    public static TextualExpression createOCLExpression(String expressionText) {
        TextualExpression expr = BASE_FACTORY.createTextualExpression();
        expr.setLanguage("OCL");
        expr.setLanguageVersion("1.0");
        expr.setExpressionText(expressionText);
        return expr;
    }

    public static Expression createParameterExpression(EParameter parameter) {
        return ExpressionsUtil.createOCLParameterExpression(parameter);
    }

    public static TextualExpression createOCLParameterExpression(EParameter parameter) {
        return ExpressionsUtil.createOCLExpression(parameter.getName());
    }

    public static Expression createAttributeExpression(ObjectVariable variable, PSAttributeConstraint constraint) {
        return ExpressionsUtil.createOCLAttributeExpression(variable, constraint);
    }

    public static TextualExpression createOCLAttributeExpression(ObjectVariable variable, PSAttributeConstraint constraint) {
        String attribute = String.valueOf(variable.getName()) + "." + constraint.getAttribute().getName();
        String operator = "";
        switch (constraint.getOperator().getValue()) {
            case 0: {
                operator = "<";
                break;
            }
            case 1: {
                operator = "<=";
                break;
            }
            case 2: {
                operator = ">";
                break;
            }
            case 3: {
                operator = ">=";
                break;
            }
            case 4: {
                operator = "=";
                break;
            }
            case 6: {
                operator = "<>";
                break;
            }
            default: {
                assert (false) : "Unexpected operator type" + constraint.getOperator().getName();
                break;
            }
        }
        String value = constraint.getValueExpression();
        return ExpressionsUtil.createOCLExpression(String.valueOf(attribute) + operator + value);
    }

    public static Expression createMetricExpression(PSMetricConstraint constraint) {
        throw new UnsupportedOperationException("Metric Expressions are not yet implemented!");
    }

    public static Expression createQualifierExpression(PSLink link) {
        return ExpressionsUtil.createOCLQualifierExpression(link);
    }

    public static Expression createQualifierExpression(String qualifier) {
        return ExpressionsUtil.createOCLQualifierExpression(qualifier);
    }

    public static TextualExpression createOCLQualifierExpression(PSLink link) {
        return ExpressionsUtil.createOCLExpression("'" + link.getQualifier() + "'");
    }

    public static TextualExpression createOCLQualifierExpression(String qualifier) {
        return ExpressionsUtil.createOCLExpression("'" + qualifier + "'");
    }

    public static Expression createEBooleanExpression(boolean value) {
        return ExpressionsUtil.createOCLBooleanExpression(value);
    }

    public static TextualExpression createOCLBooleanExpression(boolean value) {
        return ExpressionsUtil.createOCLExpression(String.valueOf(value));
    }

    public static Expression createPrimitiveVariableExpression(PrimitiveVariable variable) {
        return ExpressionsUtil.createOCLPrimitiveVariableExpression(variable);
    }

    public static TextualExpression createOCLPrimitiveVariableExpression(PrimitiveVariable variable) {
        return ExpressionsUtil.createOCLExpression(variable.getVariableName());
    }
}

