/*
 * Decompiled with CFR 0.152.
 */
package org.reclipse.structure.generator.steps;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.EReference;
import org.reclipse.structure.generator.util.Constants;
import org.reclipse.structure.generator.util.ExpressionsUtil;
import org.reclipse.structure.generator.util.IGenerator;
import org.reclipse.structure.generator.util.NameUtil;
import org.reclipse.structure.generator.util.StorydrivenUtil;
import org.reclipse.structure.inference.annotations.AnnotationsPackage;
import org.reclipse.structure.specification.PSPatternSpecification;
import org.storydriven.core.NamedElement;
import org.storydriven.storydiagrams.activities.Activity;
import org.storydriven.storydiagrams.activities.ActivityFinalNode;
import org.storydriven.storydiagrams.activities.ActivityNode;
import org.storydriven.storydiagrams.activities.EdgeGuard;
import org.storydriven.storydiagrams.activities.InitialNode;
import org.storydriven.storydiagrams.activities.StoryNode;
import org.storydriven.storydiagrams.patterns.BindingOperator;
import org.storydriven.storydiagrams.patterns.BindingState;
import org.storydriven.storydiagrams.patterns.LinkVariable;
import org.storydriven.storydiagrams.patterns.ObjectVariable;

public class RemoveInstancesStep
implements Constants {
    private final IGenerator generator;

    public RemoveInstancesStep(IGenerator generator) {
        this.generator = generator;
    }

    public void generate(Activity container, PSPatternSpecification pattern, String setName, String mergedSetName) {
        this.generator.debug("Generating '%1s'...", new Object[]{NameUtil.getName((NamedElement)container)});
        InitialNode initialNode = StorydrivenUtil.addInitialNode(container);
        StoryNode matchAnnotationsToAnnotationSetNode = RemoveInstancesStep.addMatchAnnotationsToAnnotationSetNode(container, setName);
        StorydrivenUtil.addTransition((ActivityNode)initialNode, (ActivityNode)matchAnnotationsToAnnotationSetNode);
        ActivityNode checkMergedSetNode = RemoveInstancesStep.addCheckMergedSetNode(container, mergedSetName);
        StorydrivenUtil.addTransition((ActivityNode)matchAnnotationsToAnnotationSetNode, checkMergedSetNode, EdgeGuard.EACH_TIME);
        StorydrivenUtil.addTransition(checkMergedSetNode, (ActivityNode)matchAnnotationsToAnnotationSetNode, EdgeGuard.SUCCESS);
        ActivityNode deleteNode = RemoveInstancesStep.addDeleteNode(container, setName);
        StorydrivenUtil.addTransition(checkMergedSetNode, deleteNode, EdgeGuard.FAILURE);
        StorydrivenUtil.addTransition(deleteNode, (ActivityNode)matchAnnotationsToAnnotationSetNode);
        ActivityFinalNode finalNode = StorydrivenUtil.addActivityFinalNode(container, setName);
        StorydrivenUtil.addTransition((ActivityNode)matchAnnotationsToAnnotationSetNode, (ActivityNode)finalNode, EdgeGuard.END);
    }

    private static StoryNode addMatchAnnotationsToAnnotationSetNode(Activity container, String setName) {
        EParameter parameter = StorydrivenUtil.getEParameter(container, setName);
        EReference linkType = AnnotationsPackage.Literals.ANNOTATION_SET__ANNOTATIONS;
        StoryNode element = StorydrivenUtil.addStoryNode(container, "Match annotation to '%1s'", setName);
        element.setForEach(true);
        EClass classifier = AnnotationsPackage.Literals.ANNOTATION_SET;
        ObjectVariable resultSet = StorydrivenUtil.addObjectVariable(element, setName, classifier);
        resultSet.setBindingState(BindingState.BOUND);
        resultSet.setBindingExpression(ExpressionsUtil.createParameterExpression(parameter));
        classifier = AnnotationsPackage.Literals.SET_INSTANCE_ANNOTATION;
        ObjectVariable setInstance = StorydrivenUtil.addObjectVariable(element, "annotation", classifier);
        StorydrivenUtil.addLinkVariable(element, resultSet, setInstance, linkType);
        return element;
    }

    private static ActivityNode addCheckMergedSetNode(Activity container, String mergedSetName) {
        EReference linkType = AnnotationsPackage.Literals.ANNOTATION_SET__ANNOTATIONS;
        EParameter parameter = StorydrivenUtil.getEParameter(container, mergedSetName);
        StoryNode element = StorydrivenUtil.addStoryNode(container, "Match annotation to '%1s'", mergedSetName);
        EClass classifier = AnnotationsPackage.Literals.ANNOTATION_SET;
        ObjectVariable resultSet = StorydrivenUtil.addObjectVariable(element, mergedSetName, classifier);
        resultSet.setBindingState(BindingState.BOUND);
        resultSet.setBindingExpression(ExpressionsUtil.createParameterExpression(parameter));
        classifier = AnnotationsPackage.Literals.SET_INSTANCE_ANNOTATION;
        ObjectVariable setInstance = StorydrivenUtil.addObjectVariable(element, "annotation", classifier);
        setInstance.setBindingState(BindingState.BOUND);
        StorydrivenUtil.addLinkVariable(element, resultSet, setInstance, linkType);
        return element;
    }

    private static ActivityNode addDeleteNode(Activity container, String setName) {
        EReference linkType = AnnotationsPackage.Literals.ANNOTATION_SET__ANNOTATIONS;
        EParameter parameter = StorydrivenUtil.getEParameter(container, setName);
        StoryNode element = StorydrivenUtil.addStoryNode(container, "Delete annotation from '%1s'", setName);
        EClass classifier = AnnotationsPackage.Literals.ANNOTATION_SET;
        ObjectVariable resultSet = StorydrivenUtil.addObjectVariable(element, setName, classifier);
        resultSet.setBindingState(BindingState.BOUND);
        resultSet.setBindingExpression(ExpressionsUtil.createParameterExpression(parameter));
        classifier = AnnotationsPackage.Literals.SET_INSTANCE_ANNOTATION;
        ObjectVariable setInstance = StorydrivenUtil.addObjectVariable(element, "annotation", classifier);
        setInstance.setBindingState(BindingState.BOUND);
        setInstance.setBindingOperator(BindingOperator.DESTROY);
        LinkVariable link = StorydrivenUtil.addLinkVariable(element, resultSet, setInstance, linkType);
        link.setBindingOperator(BindingOperator.DESTROY);
        return element;
    }
}

