/*
 * Decompiled with CFR 0.152.
 */
package org.reclipse.structure.generator.steps;

import java.util.Map;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.EReference;
import org.reclipse.structure.generator.util.Constants;
import org.reclipse.structure.generator.util.ExpressionsUtil;
import org.reclipse.structure.generator.util.IGenerator;
import org.reclipse.structure.generator.util.NameUtil;
import org.reclipse.structure.generator.util.StorydrivenUtil;
import org.reclipse.structure.generator.util.more.Counter;
import org.reclipse.structure.generator.util.more.SDMUtil;
import org.reclipse.structure.inference.annotations.AnnotationsPackage;
import org.reclipse.structure.specification.PSCombinedFragment;
import org.reclipse.structure.specification.PSNode;
import org.reclipse.structure.specification.PSPatternSpecification;
import org.reclipse.structure.specification.util.ModelHelper;
import org.storydriven.core.NamedElement;
import org.storydriven.storydiagrams.activities.Activity;
import org.storydriven.storydiagrams.activities.ActivityFinalNode;
import org.storydriven.storydiagrams.activities.ActivityNode;
import org.storydriven.storydiagrams.activities.EdgeGuard;
import org.storydriven.storydiagrams.activities.InitialNode;
import org.storydriven.storydiagrams.activities.StoryNode;
import org.storydriven.storydiagrams.patterns.BindingOperator;
import org.storydriven.storydiagrams.patterns.BindingState;
import org.storydriven.storydiagrams.patterns.ObjectVariable;
import org.storydriven.storydiagrams.patterns.StoryPattern;

public class MatchPairsStep
implements Constants {
    private final IGenerator generator;
    private PSPatternSpecification pattern;
    private Map<PSNode, ObjectVariable> storyItems;
    private Counter counter;
    private PSCombinedFragment set1;
    private PSCombinedFragment set2;

    public MatchPairsStep(IGenerator generator) {
        this.generator = generator;
    }

    public void generate(Activity container, PSPatternSpecification pattern, PSCombinedFragment set1, String paramName1, PSCombinedFragment set2, String paramName2, Counter counter, Map<PSNode, ObjectVariable> storyItems) {
        this.generator.debug("Generating '%1s'...", new Object[]{NameUtil.getName((NamedElement)container)});
        this.pattern = pattern;
        this.set1 = set1;
        this.set2 = set2;
        this.counter = counter;
        this.storyItems = storyItems;
        InitialNode initialNode = StorydrivenUtil.addInitialNode(container);
        StoryNode createResultNode = MatchPairsStep.addCreateResultNode(container);
        StorydrivenUtil.addTransition((ActivityNode)initialNode, (ActivityNode)createResultNode);
        StoryNode matchPairsNode = this.addMatchPairsNode(container, paramName1, paramName2);
        StorydrivenUtil.addTransition((ActivityNode)createResultNode, (ActivityNode)matchPairsNode);
        StoryNode addAnnotationNode = this.addAddAnnotationNode(container, paramName1);
        StorydrivenUtil.addTransition((ActivityNode)matchPairsNode, (ActivityNode)addAnnotationNode, EdgeGuard.EACH_TIME);
        StorydrivenUtil.addTransition((ActivityNode)addAnnotationNode, (ActivityNode)matchPairsNode);
        ActivityFinalNode finalNode = StorydrivenUtil.addActivityFinalNode(container, "annotationSet");
        StorydrivenUtil.addTransition((ActivityNode)matchPairsNode, (ActivityNode)finalNode, EdgeGuard.END);
    }

    private static StoryNode addCreateResultNode(Activity container) {
        StoryNode element = StorydrivenUtil.addStoryNode(container, "Create annotation result set container");
        ObjectVariable resultSet = StorydrivenUtil.addObjectVariable(element, "annotationSet", AnnotationsPackage.Literals.ANNOTATION_SET);
        resultSet.setBindingOperator(BindingOperator.CREATE);
        return element;
    }

    private StoryNode addMatchPairsNode(Activity container, String paramName1, String paramName2) {
        EReference annotationSetAnnotationsType = AnnotationsPackage.Literals.ANNOTATION_SET__ANNOTATIONS;
        EReference annotationBoundObjectType = AnnotationsPackage.Literals.ASG_ANNOTATION__BOUND_OBJECTS;
        EParameter param1 = StorydrivenUtil.getEParameter(container, paramName1);
        EParameter param2 = StorydrivenUtil.getEParameter(container, paramName2);
        StoryNode element = StorydrivenUtil.addStoryNode(container, "Match pairs");
        element.setForEach(true);
        EClass classifier = AnnotationsPackage.Literals.ANNOTATION_SET;
        ObjectVariable annoSet1 = StorydrivenUtil.addObjectVariable(element, paramName1, classifier);
        annoSet1.setBindingState(BindingState.BOUND);
        annoSet1.setBindingExpression(ExpressionsUtil.createParameterExpression(param1));
        classifier = AnnotationsPackage.Literals.SET_INSTANCE_ANNOTATION;
        ObjectVariable anno1 = StorydrivenUtil.addObjectVariable(element, "anno0", classifier);
        StorydrivenUtil.addLinkVariable(element, annoSet1, anno1, annotationSetAnnotationsType);
        classifier = AnnotationsPackage.Literals.ANNOTATION_SET;
        ObjectVariable annoSet2 = StorydrivenUtil.addObjectVariable(element, paramName2, classifier);
        annoSet2.setBindingState(BindingState.BOUND);
        annoSet2.setBindingExpression(ExpressionsUtil.createParameterExpression(param2));
        classifier = AnnotationsPackage.Literals.SET_INSTANCE_ANNOTATION;
        ObjectVariable anno2 = StorydrivenUtil.addObjectVariable(element, "anno1", classifier);
        StorydrivenUtil.addLinkVariable(element, annoSet2, anno2, annotationSetAnnotationsType);
        StoryPattern storyPattern = element.getStoryPattern();
        for (PSNode node : ModelHelper.getOverlappingNodes((PSCombinedFragment)this.set1, (PSCombinedFragment)this.set2)) {
            ObjectVariable boundObject = SDMUtil.addNodeToStoryPattern(storyPattern, node, this.storyItems, this.counter, this.generator);
            StorydrivenUtil.addLinkVariable(element, anno1, boundObject, annotationBoundObjectType);
            StorydrivenUtil.addLinkVariable(element, anno2, boundObject, annotationBoundObjectType);
        }
        return element;
    }

    private StoryNode addAddAnnotationNode(Activity container, String paramName) {
        StoryNode element = StorydrivenUtil.addStoryNode(container, "Create and fill annotation and add it to new set");
        EClass classifier = AnnotationsPackage.Literals.ANNOTATION_SET;
        ObjectVariable annotationObject = StorydrivenUtil.addObjectVariable(element, "anno0", classifier);
        annotationObject.setClassifier(AnnotationsPackage.Literals.SET_INSTANCE_ANNOTATION);
        annotationObject.setBindingState(BindingState.BOUND);
        classifier = AnnotationsPackage.Literals.SET_INSTANCE_ANNOTATION;
        ObjectVariable annotationObject2 = StorydrivenUtil.addObjectVariable(element, "anno1", classifier);
        annotationObject.setBindingState(BindingState.BOUND);
        classifier = AnnotationsPackage.Literals.SET_INSTANCE_ANNOTATION;
        ObjectVariable newInstanceAnnotationObject = StorydrivenUtil.addObjectVariable(element, "newAnnotation", classifier);
        newInstanceAnnotationObject.setBindingOperator(BindingOperator.CREATE);
        classifier = AnnotationsPackage.Literals.ANNOTATION_SET;
        ObjectVariable annotationResultSet = StorydrivenUtil.addObjectVariable(element, "annotationSet", classifier);
        annotationResultSet.setBindingState(BindingState.BOUND);
        StorydrivenUtil.addLinkVariable(element, annotationResultSet, newInstanceAnnotationObject, AnnotationsPackage.Literals.ANNOTATION_SET__ANNOTATIONS);
        this.addElementsFromBothSets(element.getStoryPattern(), newInstanceAnnotationObject, annotationObject, annotationObject2);
        SDMUtil.createSetInstanceAnnotationResultSetLink(annotationResultSet, annotationObject, true, element.getStoryPattern());
        SDMUtil.createSetInstanceAnnotationResultSetLink(annotationResultSet, annotationObject2, true, element.getStoryPattern());
        return element;
    }

    private void addElementsFromBothSets(StoryPattern storyPattern, ObjectVariable newAnno, ObjectVariable anno1, ObjectVariable anno2) {
        for (PSNode node : this.pattern.getNodes()) {
            if (node.getParents().contains((Object)this.set1)) {
                this.addNodeAndLinks(storyPattern, newAnno, anno1, node);
                continue;
            }
            if (!node.getParents().contains((Object)this.set2)) continue;
            this.addNodeAndLinks(storyPattern, newAnno, anno2, node);
        }
    }

    private void addNodeAndLinks(StoryPattern storyPattern, ObjectVariable newAnno, ObjectVariable anno1, PSNode node) {
        ObjectVariable boundObject = SDMUtil.addNodeToStoryPattern(storyPattern, node, this.storyItems, this.counter, this.generator);
        SDMUtil.createBoundObjectsLink(anno1, boundObject, node, false, storyPattern);
        SDMUtil.createBoundObjectsLink(newAnno, boundObject, node, true, storyPattern);
    }
}

